/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTLongList;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTRemoveVecs
extends ASTUniPrefixOp {
    long[] _rmVecs;

    @Override
    String opStr() {
        return "removeVecs";
    }

    ASTRemoveVecs() {
        super(new String[]{"", "ary", "llist"});
    }

    @Override
    ASTOp make() {
        return new ASTRemoveVecs();
    }

    @Override
    ASTRemoveVecs parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        if (a instanceof ASTLongList) {
            this._rmVecs = ((ASTLongList)a)._l;
        } else if (a instanceof ASTDoubleList) {
            double[] dlist = ((ASTDoubleList)a)._d;
            this._rmVecs = new long[dlist.length];
            for (int i = 0; i < dlist.length; ++i) {
                this._rmVecs[i] = (long)dlist[i];
            }
        } else if (a instanceof ASTNum) {
            this._rmVecs = new long[]{(long)((ASTNum)a)._d};
        } else {
            throw new IllegalArgumentException("Expected to get an `llist` or `num`. Got: " + a.getClass());
        }
        E.eatEnd();
        ASTRemoveVecs res = (ASTRemoveVecs)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        int[] idxs = new int[this._rmVecs.length];
        int i = 0;
        for (long l : this._rmVecs) {
            idxs[i++] = (int)l;
        }
        Frame fr = e.popAry();
        for (Vec v : fr.remove(idxs)) {
            v.remove();
        }
        DKV.put(fr._key, fr);
        e.pushAry(fr);
    }
}

