/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Key;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.IllegalASTException;

class ASTRename
extends ASTUniPrefixOp {
    String _newname;
    boolean _deepCopy;

    @Override
    String opStr() {
        return "rename";
    }

    ASTRename() {
        super(new String[]{"", "ary", "new_name", "deepCopy"});
    }

    @Override
    ASTOp make() {
        return new ASTRename();
    }

    @Override
    ASTRename parse_impl(Exec E) {
        AST ary = E.parse();
        this._newname = ((ASTString)E.parse())._s;
        AST a = E.parse();
        if (!(a instanceof ASTId)) {
            throw new IllegalASTException("Expected to get TRUE/FALSE for deepCopy argument");
        }
        this._deepCopy = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
        E.eatEnd();
        ASTRename res = (ASTRename)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env e) {
        Frame fr = e.popAry();
        if (this._deepCopy) {
            if (fr._key != null) {
                DKV.remove(fr._key);
            }
            Frame fr2 = new Frame(Key.make(this._newname), fr.names(), fr.vecs());
            DKV.put(fr2._key, fr2);
        } else {
            Frame fr2 = fr.deepCopy(this._newname);
            DKV.put(fr2._key, fr2);
            e.pushAry(fr2);
        }
    }
}

