/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.HashSet;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTRepLen
extends ASTUniPrefixOp {
    double _length;

    @Override
    String opStr() {
        return "rep_len";
    }

    public ASTRepLen() {
        super(new String[]{"rep_len", "x", "length.out"});
    }

    @Override
    ASTOp make() {
        return new ASTRepLen();
    }

    @Override
    ASTRepLen parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        this._length = a.treeWalk(new Env(new HashSet<Key>())).popDbl();
        E.eatEnd();
        ASTRepLen res = (ASTRepLen)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        if (env.isAry()) {
            final Frame fr = env.popAry();
            if (fr.numCols() == 1) {
                Vec v = Vec.makeRepSeq((long)this._length, fr.numRows());
                new MRTask(){

                    @Override
                    public void map(Chunk c) {
                        for (int i = 0; i < c._len; ++i) {
                            c.set(i, fr.anyVec().at((long)c.atd(i)));
                        }
                    }
                }.doAll(v);
                v.setDomain(fr.anyVec().domain());
                Frame f = new Frame(new String[]{"C1"}, new Vec[]{v});
                env.pushAry(f);
            } else {
                String[] col_names = new String[(int)this._length];
                for (int i = 0; i < col_names.length; ++i) {
                    col_names[i] = "C" + (i + 1);
                }
                Frame f = new Frame(new Vec[0]);
                int i = 0;
                while ((double)i < this._length) {
                    f.add(Frame.defaultColName(f.numCols()), fr.vec(i % fr.numCols()));
                    ++i;
                }
                env.pushAry(f);
            }
        } else {
            int len = (int)this._length;
            if (len <= 0) {
                throw new IllegalArgumentException("Error in rep_len: argument length.out must be coercible to a positive integer");
            }
            if (env.isStr()) {
                Frame fr = new Frame(new String[]{"C1"}, new Vec[]{Vec.makeCon(0.0, len)});
                fr.anyVec().setDomain(new String[]{env.popStr()});
                env.pushAry(fr);
            } else if (env.isNum()) {
                Frame fr = new Frame(new String[]{"C1"}, new Vec[]{Vec.makeCon(env.popDbl(), len)});
                env.pushAry(fr);
            } else {
                throw new IllegalArgumentException("Unkown input. Type: " + env.peekType() + " Stack: " + env.toString());
            }
        }
    }
}

