/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTRound
extends ASTUniPrefixOp {
    int _digits = 0;

    @Override
    String opStr() {
        return "round";
    }

    ASTRound() {
        super(new String[]{"round", "x", "digits"});
    }

    @Override
    ASTRound parse_impl(Exec E) {
        AST ary = E.parse();
        try {
            this._digits = (int)((ASTNum)E.parse()).dbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Expected a number for `digits` argument.");
        }
        E.eatEnd();
        ASTRound res = (ASTRound)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    ASTOp make() {
        return new ASTRound();
    }

    @Override
    void apply(Env env) {
        final int digits = this._digits;
        if (env.isAry()) {
            Frame fr = env.popAry();
            for (int i = 0; i < fr.vecs().length; ++i) {
                if (!fr.vecs()[i].isEnum()) continue;
                throw new IllegalArgumentException("Non-numeric column " + String.valueOf(i + 1) + " in data frame");
            }
            Frame fr2 = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] chks, NewChunk[] nchks) {
                    for (int i = 0; i < nchks.length; ++i) {
                        NewChunk n = nchks[i];
                        Chunk c = chks[i];
                        int rlen = c._len;
                        for (int r = 0; r < rlen; ++r) {
                            n.addNum(ASTRound.roundDigits(c.atd(r), digits));
                        }
                    }
                }
            }.doAll(fr.numCols(), fr)).outputFrame(fr.names(), fr.domains());
            env.pushAry(fr2);
        } else {
            env.push(new ValNum(ASTRound.roundDigits(env.popDbl(), digits)));
        }
    }

    static double roundDigits(double x, int digits) {
        if (Double.isNaN(x)) {
            return x;
        }
        double sgn = x < 0.0 ? -1.0 : 1.0;
        x = Math.abs(x);
        double power_of_10 = (int)Math.pow(10.0, digits);
        return sgn * (digits == 0 ? (x % 1.0 >= 0.5 && Math.floor(x) % 2.0 != 0.0 ? Math.ceil(x) : Math.floor(x)) : Math.floor(x * power_of_10 + 0.5) / power_of_10);
    }
}

