/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.HashSet;
import java.util.Random;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTRunif
extends ASTUniPrefixOp {
    long _seed;

    @Override
    String opStr() {
        return "h2o.runif";
    }

    public ASTRunif() {
        super(new String[]{"h2o.runif", "dbls", "seed"});
    }

    @Override
    ASTOp make() {
        return new ASTRunif();
    }

    @Override
    ASTRunif parse_impl(Exec E) {
        AST ary = E.parse();
        this._seed = (long)E.parse().treeWalk(new Env(new HashSet<Key>())).popDbl();
        E.eatEnd();
        ASTRunif res = (ASTRunif)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        long seed;
        long l = seed = this._seed == -1L ? new Random().nextLong() : this._seed;
        if (!env.isAry()) {
            throw new IllegalArgumentException("Frame not found: " + env.pop().value());
        }
        Vec rnd = env.popAry().anyVec().makeRand(seed);
        Frame f = new Frame(new String[]{"rnd"}, new Vec[]{rnd});
        env.pushAry(f);
    }
}

