/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.Futures;
import water.Key;
import water.fvec.AppendableVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValNum;

class ASTSeq
extends ASTUniPrefixOp {
    double _from;
    double _to;
    double _by;

    @Override
    String opStr() {
        return "seq";
    }

    ASTSeq() {
        super(new String[]{"seq", "from", "to", "by"});
    }

    @Override
    ASTOp make() {
        return new ASTSeq();
    }

    @Override
    ASTSeq parse_impl(Exec E) {
        try {
            if (!E.skipWS().hasNext()) {
                throw new IllegalArgumentException("End of input unexpected. Badly formed AST. Missing `from` argument.");
            }
            this._from = E.nextDbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `from` expected to be a number.");
        }
        try {
            if (!E.skipWS().hasNext()) {
                throw new IllegalArgumentException("End of input unexpected. Badly formed AST. Missing `to` argument.");
            }
            this._to = E.nextDbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `to` expected to be a number.");
        }
        try {
            if (!E.skipWS().hasNext()) {
                throw new IllegalArgumentException("End of input unexpected. Badly formed AST. Missing `by` argument.");
            }
            this._by = E.nextDbl();
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Argument `by` expected to be a number.");
        }
        if (this._from >= this._to) {
            throw new IllegalArgumentException("`from` >= `to`: " + this._from + ">=" + this._to);
        }
        if (this._by <= 0.0) {
            throw new IllegalArgumentException("`by` must be >0: " + this._by + " <=0");
        }
        E.eatEnd();
        ASTSeq res = (ASTSeq)this.clone();
        res._asts = new AST[0];
        return res;
    }

    @Override
    void apply(Env env) {
        double delta = this._to - this._from;
        if (delta == 0.0 && this._to == 0.0) {
            env.push(new ValNum(this._to));
        } else {
            double n = delta / this._by;
            if (n < 0.0) {
                throw new IllegalArgumentException("wrong sign in 'by' argument");
            }
            if (n > Double.MAX_VALUE) {
                throw new IllegalArgumentException("'by' argument is much too small");
            }
            double dd = Math.abs(delta) / Math.max(Math.abs(this._from), Math.abs(this._to));
            if (dd < 4.94E-322) {
                env.push(new ValNum(this._from));
            } else {
                Futures fs = new Futures();
                AppendableVec av = new AppendableVec((Key)Vec.newKey());
                NewChunk nc = new NewChunk(av, 0);
                int len = (int)n + 1;
                for (int r = 0; r < len; ++r) {
                    nc.addNum(this._from + (double)r * this._by);
                }
                nc.close(0, fs);
                Vec vec = av.close(fs);
                fs.blockForPending();
                Frame fr = new Frame(new String[]{"C1"}, new Vec[]{vec});
                env.pushAry(fr);
            }
        }
    }
}

