/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTDoubleList;
import water.rapids.ASTFrame;
import water.rapids.ASTLongList;
import water.rapids.ASTNum;
import water.rapids.ASTSpan;
import water.rapids.ASTString;
import water.rapids.ASTStringList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.util.Log;

class ASTSetColNames
extends ASTUniPrefixOp {
    long[] _idxs;
    String[] _names;

    @Override
    String opStr() {
        return "colnames=";
    }

    public ASTSetColNames() {
        super(new String[0]);
    }

    @Override
    ASTSetColNames make() {
        return new ASTSetColNames();
    }

    @Override
    ASTSetColNames parse_impl(Exec E) {
        AST ary = E.parse();
        AST cols = E.parse();
        if (cols instanceof ASTSpan) {
            this._idxs = ((ASTSpan)cols).toArray();
        } else if (cols instanceof ASTLongList) {
            this._idxs = ((ASTLongList)cols)._l;
        } else if (cols instanceof ASTDoubleList) {
            double[] d = ((ASTDoubleList)cols)._d;
            this._idxs = new long[d.length];
            int i = 0;
            for (double dd : d) {
                this._idxs[i++] = (long)dd;
            }
        } else if (cols instanceof ASTNum) {
            this._idxs = new long[]{(long)((ASTNum)cols).dbl()};
        } else {
            throw new IllegalArgumentException("Bad AST: Expected a span, llist, or number for the column indices. Got: " + cols.getClass());
        }
        AST names = E.parse();
        if (names instanceof ASTStringList) {
            this._names = ((ASTStringList)names)._s;
        } else if (names instanceof ASTString) {
            this._names = new String[]{((ASTString)names)._s};
        } else if (names instanceof ASTFrame) {
            this._names = new String[]{((ASTFrame)names)._key};
        } else {
            throw new IllegalArgumentException("Bad AST: Expected slist or string for column names. Got: " + names.getClass());
        }
        if (this._names.length != this._idxs.length) {
            throw new IllegalArgumentException("Mismatch! Number of columns to change (" + this._idxs.length + ") does not match number of names given (" + this._names.length + ").");
        }
        E.eatEnd();
        ASTSetColNames res = (ASTSetColNames)this.clone();
        res._asts = new AST[]{ary};
        res._idxs = this._idxs;
        res._names = this._names;
        return res;
    }

    @Override
    void apply(Env env) {
        try {
            Frame f = env.popAry();
            for (int i = 0; i < this._names.length; ++i) {
                f._names[(int)this._idxs[i]] = this._names[i];
            }
            if (f._key != null && DKV.get(f._key) != null) {
                DKV.put(f);
            }
            env.pushAry(f);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.info("AIOOBE!!! _idxs.length=" + this._idxs.length + "; _names.length=" + this._names.length);
            throw e;
        }
    }
}

