/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTNull;
import water.rapids.ASTOp;
import water.rapids.ASTStringList;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTSetDomain
extends ASTUniPrefixOp {
    String[] _domains;

    @Override
    String opStr() {
        return "setDomain";
    }

    public ASTSetDomain() {
        super(new String[]{"setDomain", "x", "slist"});
    }

    @Override
    ASTOp make() {
        return new ASTSetDomain();
    }

    @Override
    ASTSetDomain parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        if (a instanceof ASTStringList) {
            this._domains = ((ASTStringList)a)._s;
        } else if (a instanceof ASTNull) {
            this._domains = null;
        } else {
            throw new IllegalArgumentException("domains expected to an array of strings. Got :" + a.getClass());
        }
        ASTSetDomain res = (ASTSetDomain)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame f = env.peekAry();
        if (f.numCols() != 1) {
            throw new IllegalArgumentException("Must be a single column. Got: " + f.numCols() + " columns.");
        }
        Vec v = f.anyVec();
        if (!v.isEnum()) {
            throw new IllegalArgumentException("Vector must be a factor column. Got: " + v.get_type_str());
        }
        if (this._domains != null && this._domains.length != v.domain().length) {
            Vec.CollectDomainFast t = new Vec.CollectDomainFast((int)v.max());
            t.doAll(v);
            final long[] dom = t.domain();
            if (dom.length != this._domains.length) {
                throw new IllegalArgumentException("Number of replacement factors must equal current number of levels. Current number of levels: " + dom.length + " != " + this._domains.length);
            }
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (c.isNA(i)) continue;
                        long num = Arrays.binarySearch(dom, c.at8(i));
                        if (num < 0L) {
                            throw new IllegalArgumentException("Could not find the enum value!");
                        }
                        c.set(i, num);
                    }
                }
            }.doAll(v);
        }
        v.setDomain(this._domains);
        DKV.put(v);
    }
}

