/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.rapids.AST;
import water.rapids.ASTNum;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValSpan;

class ASTSpan
extends AST {
    final long _min;
    double _max;
    final ASTNum _ast_min;
    final ASTNum _ast_max;
    boolean _isCol;
    boolean _isRow;

    @Override
    String opStr() {
        return ":";
    }

    ASTSpan() {
        this._min = 0L;
        this._max = 0.0;
        this._ast_max = null;
        this._ast_min = null;
    }

    ASTSpan(ASTNum min, ASTNum max) {
        this._ast_min = min;
        this._ast_max = max;
        this._min = (long)min._d;
        this._max = max._d;
        if (this._min <= 0L && this._max <= 0.0) {
            if (!Double.isNaN(this._max) && this._max > (double)this._min) {
                throw new IllegalArgumentException("max>min: All negative, incorrect order.");
            }
        } else if (!Double.isNaN(this._max) && (double)this._min > this._max) {
            throw new IllegalArgumentException("min > max: min <= max for `:` operator.");
        }
    }

    ASTSpan(long min, long max) {
        this._ast_min = new ASTNum(min);
        this._ast_max = new ASTNum(max);
        this._min = min;
        this._max = max;
        if (this._min < 0L && this._max < 0.0) {
            if (this._max > (double)this._min) {
                throw new IllegalArgumentException("max>min: All negative, incorrect order.");
            }
        } else if ((double)this._min > this._max) {
            throw new IllegalArgumentException("min > max: min <= max for `:` operator.");
        }
    }

    @Override
    ASTSpan parse_impl(Exec E) {
        AST l = E.parse();
        AST r = E.parse();
        E.eatEnd();
        return new ASTSpan((ASTNum)l, (ASTNum)r);
    }

    boolean contains(long a) {
        if (this.all_neg()) {
            return this._max <= (double)a && a <= this._min;
        }
        return this._min <= a && (double)a <= this._max;
    }

    boolean isColSelector() {
        return this._isCol;
    }

    boolean isRowSelector() {
        return this._isRow;
    }

    ASTSpan setSlice(boolean row, boolean col) {
        this._isRow = row;
        this._isCol = col;
        return this;
    }

    @Override
    void exec(Env e) {
        ValSpan v = new ValSpan(this._ast_min, this._ast_max);
        v.setSlice(this._isRow, this._isCol);
        e.push(v);
    }

    @Override
    String value() {
        return null;
    }

    @Override
    int type() {
        return 5;
    }

    public String toString() {
        return this._min + ":" + this._max;
    }

    long length() {
        return (long)this._max - this._min + 1L;
    }

    long[] toArray() {
        long[] res = new long[(int)this._max - (int)this._min + 1];
        long min = this._min;
        for (int i = 0; i < res.length; ++i) {
            ++min;
        }
        return res;
    }

    boolean all_neg() {
        return this._min < 0L || this._max < 0.0;
    }

    boolean all_pos() {
        return !this.all_neg();
    }

    boolean isNum() {
        return (double)this._min == this._max;
    }

    long toNum() {
        return this._min;
    }

    @Override
    ASTSpan make() {
        return new ASTSpan(new ASTNum(0.0), new ASTNum(0.0));
    }
}

