/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTStrSplit
extends ASTUniPrefixOp {
    String _split;

    ASTStrSplit() {
        super(new String[]{"strsplit", "x", "split"});
    }

    @Override
    String opStr() {
        return "strsplit";
    }

    @Override
    ASTOp make() {
        return new ASTStrSplit();
    }

    @Override
    ASTStrSplit parse_impl(Exec E) {
        AST ary = E.parse();
        this._split = E.nextStr();
        E.eatEnd();
        ASTStrSplit res = (ASTStrSplit)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame fr = env.popAry();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("strsplit requires a single column.");
        }
        final String[] old_domains = fr.anyVec().domain();
        final String[][] new_domains = this.newDomains(old_domains, this._split);
        final String regex = this._split;
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Chunk c = cs[0];
                for (int i = 0; i < c._len; ++i) {
                    int cnt = 0;
                    if (!c.isNA(i)) {
                        String[] ss;
                        int idx = (int)c.at8(i);
                        String s = old_domains[idx];
                        for (String s1 : ss = s.split(regex)) {
                            int n_idx = Arrays.asList(new_domains[cnt]).indexOf(s1);
                            if (n_idx == -1) {
                                ncs[cnt++].addNA();
                                continue;
                            }
                            ncs[cnt++].addNum(n_idx);
                        }
                    }
                    if (cnt >= ncs.length) continue;
                    while (cnt < ncs.length) {
                        ncs[cnt].addNA();
                        ++cnt;
                    }
                }
            }
        }.doAll(new_domains.length, fr)).outputFrame(null, null, new_domains);
        env.pushAry(fr2);
    }

    private String[][] newDomains(String[] domains, String regex) {
        HashSet<String> x;
        ArrayList strs = new ArrayList();
        for (String domain : domains) {
            String[] news = domain.split(regex);
            for (int i = 0; i < news.length; ++i) {
                if (strs.size() == i) {
                    x = new HashSet<String>();
                    x.add(news[i]);
                    strs.add(x);
                    continue;
                }
                ((HashSet)strs.get(i)).add(news[i]);
            }
        }
        String[][] doms = new String[strs.size()][];
        for (int i = 0; i < strs.size(); ++i) {
            x = (HashSet<String>)strs.get(i);
            doms[i] = new String[x.size()];
            for (int j = 0; j < x.size(); ++j) {
                doms[i][j] = (String)x.toArray()[j];
            }
        }
        return doms;
    }
}

