/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Locale;
import water.DKV;
import water.fvec.Frame;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTStrSub
extends ASTUniPrefixOp {
    String _pattern;
    String _replacement;
    boolean _ignoreCase;

    ASTStrSub() {
        super(new String[]{"sub", "pattern", "replacement", "x", "ignore.case"});
    }

    @Override
    String opStr() {
        return "sub";
    }

    @Override
    ASTOp make() {
        return new ASTStrSub();
    }

    @Override
    ASTStrSub parse_impl(Exec E) {
        this._pattern = E.nextStr();
        this._replacement = E.nextStr();
        AST ary = E.parse();
        AST a = E.parse();
        if (a instanceof ASTId) {
            this._ignoreCase = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
        }
        E.eatEnd();
        ASTStrSub res = (ASTStrSub)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame fr = env.popAry();
        if (fr.numCols() != 1) {
            throw new IllegalArgumentException("sub works on a single column at a time.");
        }
        String replacement = this._replacement;
        String pattern = this._pattern;
        String[] doms = fr.anyVec().domain();
        for (int i = 0; i < doms.length; ++i) {
            doms[i] = this._ignoreCase ? doms[i].toLowerCase(Locale.ENGLISH).replaceFirst(pattern, replacement) : doms[i].replaceFirst(pattern, replacement);
        }
        fr.anyVec().setDomain(doms);
        if (fr._key != null && DKV.getGet(fr._key) != null) {
            DKV.put(fr._key, fr);
        }
        env.pushAry(fr);
    }
}

