/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Random;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTStratifiedKFold
extends ASTUniPrefixOp {
    int _nfolds;
    long _seed;

    @Override
    String opStr() {
        return "stratified_kfold_column";
    }

    @Override
    ASTOp make() {
        return new ASTStratifiedKFold();
    }

    public ASTStratifiedKFold() {
        super(new String[]{"y", "nfolds", "seed"});
    }

    @Override
    ASTStratifiedKFold parse_impl(Exec E) {
        AST ary = E.parse();
        this._nfolds = (int)E.nextDbl();
        this._seed = (long)E.nextDbl();
        E.eatEnd();
        ASTStratifiedKFold res = (ASTStratifiedKFold)this.clone();
        res._asts = new AST[]{ary};
        return res;
    }

    @Override
    public void apply(Env e) {
        Vec y = e.popAry().anyVec();
        e.pushAry(new Frame(ASTStratifiedKFold.stratifiedKFoldColumn(y, this._nfolds, this._seed == -1L ? new Random().nextLong() : this._seed)));
    }
}

