/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.Env;
import water.rapids.ValNum;

class ASTSum
extends ASTReducerOp {
    ASTSum() {
        super(0.0);
    }

    @Override
    String opStr() {
        return "sum";
    }

    @Override
    ASTOp make() {
        return new ASTSum();
    }

    @Override
    double op(double d0, double d1) {
        return d0 + d1;
    }

    @Override
    void apply(Env env) {
        double sum = this._init;
        int argcnt = this._argcnt;
        for (int i = 0; i < argcnt; ++i) {
            if (env.isNum()) {
                sum = this.op(sum, env.popDbl());
                continue;
            }
            Frame fr = env.popAry();
            for (Vec v : fr.vecs()) {
                if (!v.isEnum() && !v.isUUID() && !v.isString()) continue;
                throw new IllegalArgumentException("`" + this.opStr() + "`" + " only defined on a data frame with all numeric variables");
            }
            sum += ((RedSum)new RedSum((boolean)this._narm).doAll((Frame)fr))._d;
        }
        env.push(new ValNum(sum));
    }

    private static class RedSum
    extends MRTask<RedSum> {
        final boolean _narm;
        double _d;

        RedSum(boolean narm) {
            this._narm = narm;
        }

        @Override
        public void map(Chunk[] chks) {
            int rows = chks[0]._len;
            for (Chunk C : chks) {
                double d;
                int r;
                double sum = this._d;
                if (this._narm) {
                    for (r = 0; r < rows; ++r) {
                        d = C.atd(r);
                        if (Double.isNaN(d)) continue;
                        sum += d;
                    }
                } else {
                    for (r = 0; r < rows; ++r) {
                        d = C.atd(r);
                        sum += d;
                    }
                }
                this._d = sum;
                if (Double.isNaN(sum)) break;
            }
        }

        @Override
        public void reduce(RedSum s) {
            this._d += s._d;
        }
    }
}

