/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Map;
import sun.misc.Unsafe;
import water.AutoBuffer;
import water.Iced;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.nbhm.UtilUnsafe;
import water.rapids.AST;
import water.rapids.ASTGroupBy;
import water.rapids.ASTNull;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTUniPrefixOp;
import water.rapids.ASTddply;
import water.rapids.Env;
import water.rapids.Exec;
import water.util.ArrayUtils;
import water.util.Log;

class ASTTable
extends ASTUniPrefixOp {
    ASTTable() {
        super(new String[]{"table", "..."});
    }

    @Override
    String opStr() {
        return "table";
    }

    @Override
    ASTOp make() {
        return new ASTTable();
    }

    @Override
    ASTTable parse_impl(Exec E) {
        AST ary = E.parse();
        AST two = E.parse();
        if (two instanceof ASTString) {
            two = new ASTNull();
        }
        E.eatEnd();
        ASTTable res = (ASTTable)this.clone();
        res._asts = new AST[]{ary, two};
        return res;
    }

    @Override
    void apply(Env env) {
        Frame fr2;
        Vec dataLayoutVec;
        Frame fr;
        int ncol;
        Frame two;
        Frame frame = two = env.peekType() == 99999 ? null : env.popAry();
        if (two == null) {
            env.pop();
        }
        Frame one = env.popAry();
        if (two != null) {
            if (two.numCols() != 1 || one.numCols() != 1) {
                throw new IllegalArgumentException("`table` supports at *most* two vectors");
            }
            if (one.numCols() < 1 || one.numCols() > 2) {
                throw new IllegalArgumentException("`table` supports at *most* two vectors and at least one vector.");
            }
        }
        if ((ncol = (fr = two != null ? new Frame(one.add(two)) : one).vecs().length) > 2) {
            throw new IllegalArgumentException("table does not apply to more than two cols.");
        }
        String[][] d = new String[ncol + 1][];
        if (ncol == 1 && fr.anyVec().isInt()) {
            int min = (int)fr.anyVec().min();
            final int max = (int)fr.anyVec().max();
            String[] colnames = new String[]{fr.name(0), "Count"};
            d[0] = fr.anyVec().domain();
            d[1] = null;
            if (min >= 0) {
                UniqueColumnCountTask t = (UniqueColumnCountTask)new UniqueColumnCountTask(max, false, false, 0).doAll(fr.anyVec());
                final long[] cts = t._cts;
                dataLayoutVec = Vec.makeCon(0.0, cts.length);
                fr2 = ((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] c, NewChunk[] cs) {
                        for (int i = 0; i < c[0]._len; ++i) {
                            int idx = (int)((long)i + c[0].start());
                            if (cts[idx] == 0L) continue;
                            cs[0].addNum(idx);
                            cs[1].addNum(cts[idx]);
                        }
                    }
                }.doAll(2, dataLayoutVec)).outputFrame(colnames, d);
            } else if (min <= 0 && max <= 0) {
                UniqueColumnCountTask t = (UniqueColumnCountTask)new UniqueColumnCountTask(-1 * min, true, false, 0).doAll(fr.anyVec());
                final long[] cts = t._cts;
                dataLayoutVec = Vec.makeCon(0.0, cts.length);
                fr2 = ((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] c, NewChunk[] cs) {
                        for (int i = 0; i < c[0]._len; ++i) {
                            int idx = (int)((long)i + c[0].start());
                            if (cts[idx] == 0L) continue;
                            cs[0].addNum(idx * -1);
                            cs[1].addNum(cts[idx]);
                        }
                    }
                }.doAll(2, dataLayoutVec)).outputFrame(colnames, d);
            } else {
                UniqueColumnCountTask t = (UniqueColumnCountTask)new UniqueColumnCountTask(max + -1 * min, false, true, max).doAll(fr.anyVec());
                final long[] cts = t._cts;
                dataLayoutVec = Vec.makeCon(0.0, cts.length);
                fr2 = ((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] c, NewChunk[] cs) {
                        for (int i = 0; i < c[0]._len; ++i) {
                            int idx = (int)((long)i + c[0].start());
                            if (cts[idx] == 0L) continue;
                            cs[0].addNum(idx > max ? (double)((idx - max) * -1) : (double)idx);
                            cs[1].addNum(cts[idx]);
                        }
                    }
                }.doAll(2, dataLayoutVec)).outputFrame(colnames, d);
            }
        } else {
            String[] stringArray;
            if (ncol == 1) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = fr.name(0);
                stringArray = stringArray2;
                stringArray2[1] = "count";
            } else {
                String[] stringArray3 = new String[3];
                stringArray3[0] = fr.name(0);
                stringArray3[1] = fr.name(1);
                stringArray = stringArray3;
                stringArray3[2] = "count";
            }
            String[] colnames = stringArray;
            long s = System.currentTimeMillis();
            Uniq2ColTsk u = (Uniq2ColTsk)new Uniq2ColTsk().doAll(fr);
            Log.info("Finished gathering uniq groups in: " + (double)(System.currentTimeMillis() - s) / 1000.0 + " (s)");
            final ASTddply.Group[] pairs = u._s._g.toArray(new ASTddply.Group[u._s.size()]);
            dataLayoutVec = Vec.makeCon(0.0, pairs.length);
            s = System.currentTimeMillis();
            NewHashMap h = (NewHashMap)new NewHashMap(pairs).doAll(dataLayoutVec);
            Log.info("Finished creating new HashMap in: " + (double)(System.currentTimeMillis() - s) / 1000.0 + " (s)");
            s = System.currentTimeMillis();
            final long[] cnts = ((CountUniq2ColTsk)new CountUniq2ColTsk(h._s).doAll((Frame)fr))._cnts;
            Log.info("Finished gathering counts in: " + (double)(System.currentTimeMillis() - s) / 1000.0 + " (s)");
            d[0] = fr.vec(0).domain();
            if (ncol == 2) {
                d[1] = fr.vec(1).domain();
            }
            fr2 = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] c, NewChunk[] cs) {
                    int start = (int)c[0].start();
                    for (int i = 0; i < c[0]._len; ++i) {
                        double[] g = pairs[i + start]._ds;
                        cs[0].addNum(g[0]);
                        if (ncol == 2) {
                            cs[1].addNum(g[1]);
                            cs[2].addNum(cnts[i + start]);
                            continue;
                        }
                        cs[1].addNum(cnts[i + start]);
                    }
                }
            }.doAll(ncol + 1, dataLayoutVec)).outputFrame(colnames, d);
        }
        Keyed.remove(dataLayoutVec._key);
        env.pushAry(fr2);
    }

    private static class IcedHM<Group extends ASTddply.Group, Int extends Integer>
    extends Iced {
        private NonBlockingHashMap<Group, Integer> _m = new NonBlockingHashMap();

        IcedHM() {
        }

        void put(Group g, Int i) {
            this._m.put(g, (Integer)i);
        }

        void putAll(IcedHM<Group, Int> m) {
            this._m.putAll((Map<Group, Integer>)m._m);
        }

        int size() {
            return this._m.size();
        }

        int get(Group g) {
            return this._m.get(g);
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer ab) {
            if (this._m == null || this._m.size() == 0) {
                return ab.put4(0);
            }
            ab.put4(this._m.size());
            for (ASTddply.Group g : this._m.keySet()) {
                ab.put(g);
                ab.put4(this._m.get(g));
            }
            return ab;
        }

        @Override
        public IcedHM read_impl(AutoBuffer ab) {
            int mLen = ab.get4();
            if (mLen != 0) {
                this._m = new NonBlockingHashMap();
                for (int i = 0; i < mLen; ++i) {
                    this._m.put((Group)((ASTddply.Group)ab.get()), ab.get4());
                }
            }
            return this;
        }
    }

    private static class CountUniq2ColTsk
    extends MRTask<CountUniq2ColTsk> {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        IcedHM<ASTddply.Group, Integer> _m;
        private long[] _cols;
        long[] _cnts;
        private static final int _b = _unsafe.arrayBaseOffset(long[].class);
        private static final int _s = _unsafe.arrayIndexScale(long[].class);

        private static long ssid(int i) {
            return _b + _s * i;
        }

        CountUniq2ColTsk(IcedHM<ASTddply.Group, Integer> s) {
            this._m = s;
        }

        @Override
        public void setupLocal() {
            this._cnts = MemoryManager.malloc8(this._m.size());
            this._cols = new long[this._fr.numCols()];
            for (int i = 0; i < this._cols.length; ++i) {
                this._cols[i] = i;
            }
        }

        @Override
        public void map(Chunk[] cs) {
            ASTddply.Group g = new ASTddply.Group(this._cols.length);
            for (int i = 0; i < cs[0]._len; ++i) {
                int h = this._m.get((ASTddply.Group)g.fill(i, cs, this._cols));
                long offset = CountUniq2ColTsk.ssid(h);
                long c = this._cnts[h];
                while (!_unsafe.compareAndSwapLong(this._cnts, offset, c, c + 1L)) {
                    c = this._cnts[h];
                }
            }
        }

        @Override
        public void reduce(CountUniq2ColTsk t) {
            if (this._cnts != t._cnts) {
                ArrayUtils.add(this._cnts, t._cnts);
            }
        }
    }

    private static class NewHashMap
    extends MRTask<NewHashMap> {
        IcedHM<ASTddply.Group, Integer> _s;
        ASTddply.Group[] _m;

        NewHashMap(ASTddply.Group[] m) {
            this._m = m;
        }

        @Override
        public void setupLocal() {
            this._s = new IcedHM();
        }

        @Override
        public void map(Chunk[] c) {
            int start = (int)c[0].start();
            for (int i = 0; i < c[0]._len; ++i) {
                this._s.put(this._m[i + start], i + start);
            }
        }

        @Override
        public void reduce(NewHashMap t) {
            if (this._s != t._s) {
                this._s.putAll(t._s);
            }
        }
    }

    private static class Uniq2ColTsk
    extends MRTask<Uniq2ColTsk> {
        ASTGroupBy.IcedNBHS<ASTddply.Group> _s;
        private long[] _cols;

        private Uniq2ColTsk() {
        }

        @Override
        public void setupLocal() {
            this._s = new ASTGroupBy.IcedNBHS();
            this._cols = new long[this._fr.numCols()];
            for (int i = 0; i < this._cols.length; ++i) {
                this._cols[i] = i;
            }
        }

        @Override
        public void map(Chunk[] c) {
            ASTddply.Group g = new ASTddply.Group(this._cols.length);
            for (int i = 0; i < c[0]._len; ++i) {
                if (!this._s.add((ASTddply.Group)g.fill(i, c, this._cols))) continue;
                g = new ASTddply.Group(this._cols.length);
            }
        }

        @Override
        public void reduce(Uniq2ColTsk t) {
            if (this._s != t._s) {
                this._s.addAll(t._s._g);
            }
        }
    }

    public static class UniqueColumnCountTask
    extends MRTask<UniqueColumnCountTask> {
        long[] _cts;
        final int _max;
        final boolean _flip;
        final boolean _mixed;
        final int _piv;

        public UniqueColumnCountTask(int max, boolean flip, boolean mixed, int piv) {
            this._max = max;
            this._flip = flip;
            this._mixed = mixed;
            this._piv = piv;
        }

        @Override
        public void map(Chunk c) {
            this._cts = MemoryManager.malloc8(this._max + 1);
            if (this._flip) {
                for (int i = 0; i < c._len; ++i) {
                    int val;
                    if (c.isNA(i)) continue;
                    int n = val = (int)(-1L * c.at8(i));
                    this._cts[n] = this._cts[n] + 1L;
                }
            } else if (this._mixed) {
                for (int i = 0; i < c._len; ++i) {
                    int idx;
                    if (c.isNA(i)) continue;
                    int val = (int)c.at8(i);
                    int n = idx = val < 0 ? -1 * val + this._piv : val;
                    this._cts[n] = this._cts[n] + 1L;
                }
            } else {
                for (int i = 0; i < c._len; ++i) {
                    int val;
                    if (c.isNA(i)) continue;
                    int n = val = (int)c.at8(i);
                    this._cts[n] = this._cts[n] + 1L;
                }
            }
        }

        @Override
        public void reduce(UniqueColumnCountTask t) {
            ArrayUtils.add(this._cts, t._cts);
        }
    }
}

