/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.parser.ParseTime;
import water.parser.ValueString;
import water.rapids.AST;
import water.rapids.ASTOp;
import water.rapids.ASTString;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;

class ASTasDate
extends ASTUniPrefixOp {
    String _format;

    ASTasDate() {
        super(new String[]{"as.Date", "x", "format"});
    }

    @Override
    String opStr() {
        return "as.Date";
    }

    @Override
    ASTOp make() {
        return new ASTasDate();
    }

    @Override
    ASTasDate parse_impl(Exec E) {
        AST ast = E.parse();
        AST a = E.parse();
        if (!(a instanceof ASTString)) {
            throw new IllegalArgumentException("`format` must be a string.");
        }
        this._format = ((ASTString)a)._s;
        E.eatEnd();
        ASTasDate res = (ASTasDate)this.clone();
        res._asts = new AST[]{ast};
        return res;
    }

    @Override
    void apply(Env env) {
        boolean isStr;
        final String format = this._format;
        if (format.isEmpty()) {
            throw new IllegalArgumentException("as.Date requires a non-empty format string");
        }
        Frame fr = env.popAry();
        if (fr.vecs().length != 1 || !fr.vecs()[0].isEnum() && !fr.vecs()[0].isString()) {
            throw new IllegalArgumentException("as.Date requires a single column of factors or strings");
        }
        final String[] dom = fr.anyVec().domain();
        boolean bl = isStr = dom == null && fr.anyVec().isString();
        if (!isStr) assert (dom != null) : "as.Date error: domain is null, but vec is not String";
        Frame fr2 = ((MRTask)new MRTask(){
            private transient DateTimeFormatter _fmt;

            @Override
            public void setupLocal() {
                this._fmt = ParseTime.forStrptimePattern(format).withZone(ParseTime.getTimezone());
            }

            @Override
            public void map(Chunk c, NewChunk nc) {
                ValueString vStr = new ValueString();
                for (int i = 0; i < c._len; ++i) {
                    if (!c.isNA(i)) {
                        String date = isStr ? c.atStr(vStr, i).toString() : dom[(int)c.at8(i)];
                        nc.addNum(DateTime.parse((String)date, (DateTimeFormatter)this._fmt).getMillis(), 0);
                        continue;
                    }
                    nc.addNA();
                }
            }
        }.doAll(1, fr)).outputFrame(fr._names, null);
        env.pushAry(fr2);
    }
}

