/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.EnumWrappedVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTString;
import water.rapids.IllegalASTException;
import water.rapids.Val;
import water.rapids.ValDoubleList;
import water.rapids.ValFrame;
import water.rapids.ValId;
import water.rapids.ValLongList;
import water.rapids.ValNull;
import water.rapids.ValNum;
import water.rapids.ValSeries;
import water.rapids.ValSpan;
import water.rapids.ValStr;
import water.rapids.ValStringList;
import water.util.IcedHashMap;
import water.util.IcedInt;
import water.util.Log;

public class Env
extends Iced {
    static final int ID = 0;
    static final int ARY = 1;
    static final int STR = 2;
    static final int NUM = 3;
    static final int FUN = 4;
    static final int SPAN = 5;
    static final int SERIES = 6;
    static final int VEC = 8;
    static final int LIST = 9;
    static final int LARY = 10;
    static final int NULL = 99999;
    transient ExecStack _stack = new ExecStack();
    transient HashMap<Key, IcedInt> _refcnt = new HashMap();
    public final transient StringBuilder _sb = new StringBuilder();
    final transient HashSet<Key> _locked;
    final SymbolTable _global;
    SymbolTable _local;
    final Env _parent;
    private final boolean _isGlobal;
    transient HashSet<ValFrame> _trash;
    transient HashSet<Frame> _tmpFrames;

    @Override
    public AutoBuffer write_impl(AutoBuffer ab) {
        ab.put4(this._refcnt.size());
        for (Key k : this._refcnt.keySet()) {
            ab.put(k);
            ab.put4(this._refcnt.get((Object)k)._val);
        }
        return ab;
    }

    @Override
    public Env read_impl(AutoBuffer ab) {
        this._refcnt = new HashMap();
        this._stack = new ExecStack();
        this._trash = new HashSet();
        int len = ab.get4();
        for (int i = 0; i < len; ++i) {
            this._refcnt.put(ab.get(Key.class), new IcedInt(ab.get4()));
        }
        return this;
    }

    Env(HashSet<Key> locked) {
        this._locked = locked;
        this._global = new SymbolTable();
        this._local = null;
        this._parent = null;
        this._isGlobal = true;
        this._trash = new HashSet();
        this._tmpFrames = new HashSet();
    }

    Env capture() {
        return new Env(this);
    }

    private Env(Env e) {
        this._locked = new HashSet();
        this._global = null;
        this._local = new SymbolTable();
        this._parent = e;
        this._isGlobal = false;
        this._trash = new HashSet();
        this._tmpFrames = new HashSet();
    }

    static Env make(HashSet<Key> locked) {
        Env env = new Env(locked);
        env.put("TRUE", 3, "1");
        env.put("T", 3, "1");
        env.put("FALSE", 3, "0");
        env.put("F", 3, "0");
        env.put("NA", 3, Double.toString(Double.NaN));
        env.put("Inf", 3, Double.toString(Double.POSITIVE_INFINITY));
        env.put("-Inf", 3, Double.toString(Double.NEGATIVE_INFINITY));
        env.put("E", 3, Double.toString(Math.E));
        env.put("PI", 3, Double.toString(Math.PI));
        return env;
    }

    public boolean isGlobal() {
        return this._isGlobal && this._parent == null && this._local == null;
    }

    public static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "ID";
            }
            case 1: {
                return "ARY";
            }
            case 2: {
                return "STR";
            }
            case 3: {
                return "NUM";
            }
            case 4: {
                return "FUN";
            }
            case 5: {
                return "SPAN";
            }
            case 6: {
                return "SERIES";
            }
            case 8: {
                return "VEC";
            }
            case 99999: {
                return "NULL";
            }
        }
        return "No type for number: " + type;
    }

    public int sp() {
        return this._stack._head + 1;
    }

    public void push(Val o) {
        if (o instanceof ValFrame) {
            ValFrame f = (ValFrame)o;
            if (!this._isGlobal) {
                assert (f._key == null || DKV.get(f._key) != null);
                this._local.put(Key.make().toString(), f._fr, false);
            }
            this.addRef(f);
        }
        this._stack.push(o);
        this.clean();
    }

    public void pushAry(Frame fr) {
        this.push(new ValFrame(fr));
    }

    public boolean isEmpty() {
        return this._stack.isEmpty();
    }

    public Val peek() {
        return this._stack.peek();
    }

    public Val peekAt(int i) {
        return this._stack.peekAt(i);
    }

    public int peekType() {
        return this._stack.peekType();
    }

    public Frame peekAryAt(int i) {
        try {
            return ((ValFrame)this._stack.peekAt((int)i))._fr;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Bad input: Expected input to be a Frame.");
        }
    }

    public int peekTypeAt(int i) {
        return this._stack.peekTypeAt(i);
    }

    public boolean isAry() {
        return this.peekType() == 1;
    }

    public boolean isNum() {
        return this.peekType() == 3;
    }

    public boolean isStr() {
        return this.peekType() == 2;
    }

    public boolean isId() {
        return this.peekType() == 0;
    }

    public boolean isFun() {
        return this.peekType() == 4;
    }

    public boolean isNul() {
        return this.peekType() == 99999;
    }

    public boolean isSpan() {
        return this.peekType() == 5;
    }

    public boolean isSeries() {
        return this.peekType() == 6;
    }

    public Val pop() {
        return this._stack.pop();
    }

    public void pop(int n) {
        for (int i = 0; i < n; ++i) {
            this.pop();
        }
    }

    public void poppush(int n, Val v) {
        this.pop(n);
        this.push(v);
    }

    public Frame popAry() {
        return ((ValFrame)this.pop())._fr;
    }

    public double popDbl() {
        return ((ValNum)this.pop())._d;
    }

    public String popStr() {
        Val v = this.pop();
        if (v instanceof ValStr) {
            return ((ValStr)v)._s;
        }
        if (v instanceof ValFrame) {
            return ((ValFrame)v)._fr._key.toString();
        }
        throw new IllegalASTException("shouldn't be here.");
    }

    public ValSeries popSeries() {
        return (ValSeries)this.pop();
    }

    public ValSpan popSpan() {
        return (ValSpan)this.pop();
    }

    public Frame peekAry() {
        return ((ValFrame)this.peek())._fr;
    }

    public double peekDbl() {
        return ((ValNum)this.peek())._d;
    }

    public AST pop2AST() {
        if (this.isAry()) {
            return new ASTFrame(this.popAry());
        }
        if (this.isNum()) {
            return new ASTNum(this.popDbl());
        }
        if (this.isStr()) {
            return new ASTString('\"', this.popStr());
        }
        if (this.isNul()) {
            this.pop();
            return new ASTNull();
        }
        throw new IllegalArgumentException("Invalid use of pop2AST. Got bad type: " + this.peekType());
    }

    public void toss(ValFrame f) {
        this._trash.add(f);
    }

    public synchronized void clean() {
        if (this._trash == null) {
            return;
        }
        for (ValFrame f : this._trash) {
            if (f._g) continue;
            this.cleanup(f._fr);
        }
        this._trash.clear();
    }

    public void addRef(ValFrame o) {
        this.addRef(o._fr);
    }

    public void addRef(Frame f) {
        for (Vec v : f.vecs()) {
            this.addRef(v);
        }
    }

    public void addRef(Vec v) {
        if (this.inScope(v)) {
            IcedInt I = this.getRef(v);
            assert (I == null || I._val >= 0);
            this.putRef(v, new IcedInt(I == null ? 1 : I._val + 1));
            if (v instanceof EnumWrappedVec) {
                Vec mv = ((EnumWrappedVec)v).masterVec();
                IcedInt Imv = this.getRef(mv);
                assert (Imv == null || Imv._val >= 0);
                this.putRef(mv, new IcedInt(Imv == null ? 1 : Imv._val + 1));
            }
        }
    }

    private IcedInt getRef(Vec v) {
        return v._key == null ? null : this._refcnt.get(v._key);
    }

    private void putRef(Vec v, IcedInt i) {
        this._refcnt.put(v._key, i);
    }

    private void rmRef(Vec v) {
        if (v._key != null) {
            this._refcnt.remove(v._key);
        }
    }

    private boolean hasRef(Vec v) {
        return v._key != null && this._refcnt.containsKey(v._key);
    }

    private boolean inScope(Vec v) {
        Env e = this._parent;
        boolean in = false;
        while (e != null) {
            in |= e._refcnt.containsKey(v);
            e = e._parent;
        }
        return this._refcnt.containsKey(v) || !in;
    }

    public boolean hasLock(Key k) {
        boolean locked;
        boolean bl = locked = this._locked != null && this._locked.contains(k);
        if (this._parent != null) {
            locked |= this._parent.hasLock(k);
        }
        return locked;
    }

    public void lock(Key k) {
        this._locked.add(k);
    }

    public void lock(Frame fr) {
        for (Vec v : fr.vecs()) {
            this.lock(v);
        }
        this.lock(fr._key);
    }

    public void lock(Vec v) {
        this.lock(v._key);
    }

    public void lock(String k) {
        this.lock(Key.make(k));
    }

    public Key lock() {
        Key k = Key.make();
        this._locked.add(k);
        return k;
    }

    private void subRef(Val o) {
        assert (o instanceof ValFrame);
        boolean delete = true;
        Frame f = ((ValFrame)o)._fr;
        for (Vec v : f.vecs()) {
            delete &= this.subRef(v);
        }
        if (delete && f._key != null && !this.hasLock(f._key)) {
            f.delete();
        }
    }

    public boolean subRef(Vec v) {
        boolean delete;
        if (v == null) {
            return false;
        }
        if (this.getRef(v) == null) {
            return false;
        }
        if (this.hasLock(v._key)) {
            return false;
        }
        int cnt = this.getRef((Vec)v)._val - 1;
        if (cnt > 0) {
            this.putRef(v, new IcedInt(cnt));
            delete = false;
        } else {
            this.extinguishCounts(v);
            delete = true;
        }
        if (delete) {
            Env.removeVec(v, null);
        }
        return delete;
    }

    public void subRef(Frame f) {
        for (Vec v : f.vecs()) {
            this.subRef(v);
        }
    }

    static Futures removeVec(Vec v, Futures fs) {
        if (fs == null) {
            fs = new Futures();
            Keyed.remove(v._key, fs);
            fs.blockForPending();
            return null;
        }
        Keyed.remove(v._key, fs);
        return fs;
    }

    private void extinguishCounts(Object o) {
        if (o instanceof Vec) {
            this.rmRef((Vec)o);
        } else {
            for (Vec v : ((Frame)o).vecs()) {
                this.rmRef(v);
            }
        }
    }

    public void postWrite() {
        Futures fs = new Futures();
        for (Key key : this._refcnt.keySet()) {
            Vec v = (Vec)DKV.getGet(key);
            if (v == null) continue;
            v.postWrite(fs);
        }
        fs.blockForPending();
    }

    public void remove_and_unlock() {
        block3: while (!this._stack.isEmpty()) {
            int type = this.peekType();
            switch (type) {
                case 1: {
                    this.remove(this.peek(), false);
                    continue block3;
                }
            }
            this.pop();
        }
        Futures fs = new Futures();
        for (Key k : this._refcnt.keySet()) {
            if (this._refcnt.get((Object)k)._val != 0) continue;
            Env.removeVec((Vec)DKV.getGet(k), fs);
        }
        fs.blockForPending();
        for (Frame f : this._tmpFrames) {
            if (f._key == null) continue;
            DKV.remove(f._key);
        }
    }

    public void unlock() {
        while (!this._stack.isEmpty()) {
            if (this._stack.peekType() == 1) {
                Frame fr = ((ValFrame)this._stack.pop())._fr;
                if (fr._lockers == null || !this.lockerKeysNotNull(fr)) continue;
                fr.unlock_all();
                continue;
            }
            this._stack.pop();
        }
    }

    void remove(Object o, boolean popped) {
        assert (o instanceof ValFrame || o instanceof Frame || o == null);
        if (o == null) {
            return;
        }
        if (o instanceof ValFrame) {
            this.remove_and_unlock(((ValFrame)o)._fr);
        } else {
            this.remove_and_unlock((Frame)o);
        }
        if (!popped) {
            this.pop();
        }
    }

    void cleanup(Frame f) {
        if (f == null) {
            return;
        }
        if (f._lockers != null && this.lockerKeysNotNull(f)) {
            f.unlock_all();
        }
        this.subRef(new ValFrame(f));
    }

    void popScope() {
        if (this._parent == null) {
            throw new IllegalArgumentException("Cannot pop the parent scope!");
        }
        Key k = this.isAry() ? this.peekAry()._key : null;
        Set local = this._local._table.keySet();
        for (String name : local) {
            if (this._local.getType(name) != 10) continue;
            Frame f = this._local.getFrame((String)name)._fr;
            if (this.isAry() && f == this.peekAry()) continue;
            this.cleanup(f);
        }
        this._local.clear();
        for (Key key : this._locked) {
            if ((k == null || k != key) && this.isAry() && !Arrays.asList(this.peekAry().keys()).contains(key)) continue;
        }
        this._locked.clear();
        for (Key ik : this._refcnt.keySet()) {
            if (this._refcnt.get((Object)ik)._val != 0 || this.hasLock(ik)) continue;
            Keyed.remove(ik);
        }
    }

    private void remove_and_unlock(Frame fr) {
        this.extinguishCounts(fr);
        if (fr._lockers != null && this.lockerKeysNotNull(fr)) {
            fr.unlock_all();
        }
        if (this.anyLocked(fr)) {
            return;
        }
        fr.delete();
    }

    private boolean lockerKeysNotNull(Frame f) {
        for (Key k : f._lockers) {
            if (k != null) continue;
            return false;
        }
        return true;
    }

    private boolean anyLocked(Frame fr) {
        if (this.hasLock(fr._key)) {
            return true;
        }
        for (Vec v : fr.vecs()) {
            if (!this.hasLock(v._key)) continue;
            return true;
        }
        return false;
    }

    public String toString(int i) {
        int type = this.peekTypeAt(i);
        Val o = this.peekAt(i);
        switch (type) {
            case 1: {
                return ((ValFrame)o)._fr.numRows() + "x" + ((ValFrame)o)._fr.numCols();
            }
            case 3: {
                return Double.toString(((ValNum)o)._d);
            }
            case 2: {
                return ((ValStr)o)._s;
            }
            case 0: {
                return ((ValId)o)._id;
            }
            case 6: {
                return o.toString();
            }
            case 5: {
                return o.toString();
            }
            case 99999: {
                return "null";
            }
        }
        throw H2O.unimpl("Bad value on the stack: " + type);
    }

    public String toString() {
        int sp = this.sp();
        String s = "{";
        for (int i = -sp + 1; i <= 0; ++i) {
            s = s + this.toString(i) + ",";
        }
        return s + "}";
    }

    SymbolTable newTable() {
        return new SymbolTable();
    }

    void put(String name, int type, String value) {
        if (this._isGlobal) {
            this._global.put(name, type, value);
        } else {
            this._local.put(name, type, value);
        }
    }

    void put(String name, Frame f, boolean isFrame) {
        if (this._isGlobal) {
            this._global.put(name, f, isFrame);
        } else {
            this._local.put(name, f, isFrame);
        }
    }

    void put(String name, Frame f) {
        this.put(name, f, true);
    }

    int getType(String name, boolean search_global) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Tried to lookup on a missing name. Are there free floating `%` in your AST?");
        }
        int res = 99999;
        if (this._local != null) {
            res = this._local.getType(name);
        }
        if (res == 99999 && this._local != null) {
            res = this._local.getType(name);
        }
        if (res == 99999 && search_global && this._global != null) {
            res = this._global.getType(name);
        }
        if (res == 99999 && search_global) {
            res = Env.kvLookup(name);
        }
        if (res == 99999 && this._parent != null) {
            res = this._parent.getType(name, false);
        }
        if (res == 99999) {
            throw new H2OIllegalArgumentException("Failed lookup of variable: " + name, "Failed lookup of variable: " + name + " in: " + this);
        }
        return res;
    }

    private static int kvLookup(String name) {
        Value v = DKV.get(Key.make(name));
        if (v == null) {
            return 99999;
        }
        if (v.get() instanceof Frame) {
            return 1;
        }
        if (v.get() instanceof Vec) {
            return 1;
        }
        throw new IllegalArgumentException("Unexpected type: " + v.getClass());
    }

    String getValue(String name, boolean search_global) {
        String res = null;
        if (this._local != null) {
            res = this._local.getValue(name);
        }
        if (res == null && search_global) {
            res = this._global.getValue(name);
        }
        if (res == null && this._parent != null) {
            res = this._parent.getValue(name, false);
        }
        return res;
    }

    ASTFrame getFrame(String name, boolean search_global) {
        ASTFrame res = null;
        if (this._local != null) {
            res = this._local.getFrame(name);
        }
        if (res == null && search_global) {
            Value v = DKV.get(Key.make(name));
            res = v == null || v.get() == null ? null : new ASTFrame(name);
        }
        if (res == null && this._global != null) {
            res = this._global.getFrame(name);
        }
        if (res == null && this._parent != null) {
            res = this._parent.getFrame(name, false);
        }
        return res;
    }

    AST lookup(ASTId id) {
        switch (this.getType(id.value(), true)) {
            case 3: {
                return new ASTNum(Double.valueOf(this.getValue(id.value(), true)));
            }
            case 1: {
                return new ASTFrame(id.value());
            }
            case 10: {
                return this.getFrame(id.value(), false);
            }
            case 2: {
                return id.value().equals("()") ? new ASTNull() : new ASTString('\"', id.value());
            }
        }
        throw H2O.unimpl("Could not find appropriate type for identifier " + id);
    }

    boolean tryLookup(ASTId id) {
        try {
            this.lookup(id);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static AST staticLookup(ASTId id) {
        return Env.kvLookup(id.value()) == 1 ? new ASTFrame(id.value()) : id;
    }

    static AST staticLookup(ASTString str) {
        return Env.kvLookup(str.value()) == 1 ? new ASTFrame(str.value()) : str;
    }

    private class SymbolAttributes
    extends Iced {
        private int _type;
        private String _value;

        SymbolAttributes(int type, String value) {
            this._type = type;
            this._value = value;
        }

        public void write(int type) {
            this._type = type;
        }

        public void write(String value) {
            this._value = value;
        }
    }

    class SymbolTable<T extends Iced>
    extends Iced<T> {
        IcedHashMap<String, T> _table = new IcedHashMap();

        void clear() {
            this._table.clear();
        }

        public void put(String name, int type, String value) {
            if (this._table.containsKey(name)) {
                this.write(name, type);
                this.write(name, value);
            } else {
                SymbolAttributes attributes = new SymbolAttributes(type, value);
                this._table.put(name, attributes);
            }
        }

        public void put(String name, Frame localFrame, boolean isFrame) {
            ASTFrame fr = new ASTFrame(localFrame);
            fr.isFrame = isFrame;
            this._table.put(name, fr);
        }

        public T get(String name) {
            if (!this._table.containsKey(name)) {
                return null;
            }
            return (T)((Iced)this._table.get(name));
        }

        public int getType(String name) {
            if (!this._table.containsKey(name)) {
                return 99999;
            }
            T V = this.get(name);
            if (V instanceof ASTFrame) {
                return 10;
            }
            return ((SymbolAttributes)V)._type;
        }

        public String getValue(String name) {
            if (!this._table.containsKey(name)) {
                return null;
            }
            T V = this.get(name);
            try {
                return ((SymbolAttributes)V)._value;
            }
            catch (ClassCastException e) {
                throw new ClassCastException("API Error in Symbol Attributes. Caller expected SymbolAttributes but got " + V.getClass());
            }
        }

        public ASTFrame getFrame(String name) {
            if (!this._table.containsKey(name)) {
                return null;
            }
            T V = this.get(name);
            try {
                return (ASTFrame)V;
            }
            catch (ClassCastException e) {
                throw new ClassCastException("API Error in Symbol Attributes. Caller expected Frame but got " + V.getClass());
            }
        }

        private void write(String name, int type) {
            SymbolAttributes attrs = (SymbolAttributes)this.get(name);
            attrs.write(type);
        }

        private void write(String name, String value) {
            SymbolAttributes attrs = (SymbolAttributes)this.get(name);
            attrs.write(value);
        }
    }

    private class ExecStack
    implements Stack {
        private final ArrayList<Val> _stack = new ArrayList();
        private int _head = -1;

        private ExecStack() {
        }

        @Override
        public Val peek() {
            if (this.isEmpty()) {
                return null;
            }
            return this._stack.get(this._head);
        }

        @Override
        public Val peekAt(int i) {
            if (i <= 0 && (i = this._head + i) < 0) {
                throw new IllegalArgumentException("Trying to peekAt a negative position in the stack: " + i);
            }
            if (this.isEmpty()) {
                return null;
            }
            if (i > this._head) {
                Log.warn("peekAt(" + i + "): i is greater than the top of the stack: " + this._head + "<" + i);
                return null;
            }
            if (i > this.size()) {
                Log.warn("peekAt(" + i + "): i is greater than the size of the stack: " + this.size() + "<" + i);
                return null;
            }
            return this._stack.get(i);
        }

        @Override
        public int peekType() {
            return this.getType(this.peek());
        }

        @Override
        public int peekTypeAt(int i) {
            return this.getType(this.peekAt(i));
        }

        private int getType(Val o) {
            if (o instanceof ValNull || o == null) {
                return 99999;
            }
            if (o instanceof ValId) {
                return 0;
            }
            if (o instanceof ValFrame) {
                return 1;
            }
            if (o instanceof ValStr) {
                return 2;
            }
            if (o instanceof ValNum) {
                return 3;
            }
            if (o instanceof ValSpan) {
                return 5;
            }
            if (o instanceof ValSeries) {
                return 6;
            }
            if (o instanceof ValLongList) {
                return 9;
            }
            if (o instanceof ValStringList) {
                return 9;
            }
            if (o instanceof ValDoubleList) {
                return 9;
            }
            throw H2O.unimpl("Got a bad type on the ExecStack: Object class: " + o.getClass() + ". Not a Frame, String, Double, Fun, Span, or Series");
        }

        @Override
        public boolean isEmpty() {
            return this._head == -1;
        }

        @Override
        public int size() {
            if (!this.isEmpty()) {
                assert (this._stack.size() == this._head + 1) : "The stack size and the pointer to the top are out of alignment! Stack size: " + (this._stack.size() - 1) + ", _head: " + this._head;
                return this._stack.size();
            }
            return -1;
        }

        @Override
        public Val pop() {
            AST f;
            if (this.isEmpty()) {
                return null;
            }
            Val o = this.peek();
            if (o instanceof ValStr && (f = Env.staticLookup(new ASTString('\"', ((ValStr)o)._s))) instanceof ASTFrame) {
                this._stack.remove(this._head--);
                f.exec(Env.this);
                return this.pop();
            }
            this._stack.remove(this._head--);
            if (o instanceof ValFrame) {
                Env.this.toss((ValFrame)o);
            }
            return o;
        }

        public void popAll() {
            if (this.isEmpty()) {
                return;
            }
            while (this.size() != -1) {
                Val v = this.pop();
                if (!(v instanceof ValFrame)) continue;
                ((ValFrame)v)._fr.unlock_all();
            }
        }

        @Override
        public void push(Val t) {
            ++this._head;
            this._stack.add(this._head, t);
        }
    }

    private static interface Stack {
        public Val peek();

        public Val peekAt(int var1);

        public Val pop();

        public void push(Val var1);

        public boolean isEmpty();

        public int size();

        public int peekType();

        public int peekTypeAt(int var1);
    }
}

