/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.HashSet;
import water.Iced;
import water.Key;
import water.MRTask;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTFuncDef;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTPlus;
import water.rapids.ASTString;
import water.rapids.Env;
import water.rapids.IllegalASTException;

public class Exec
extends Iced {
    final byte[] _ast;
    final String _str;
    int _x;
    final Env _env;
    private static boolean _inited;

    public Exec(String ast, Env env) {
        this._str = ast;
        this._ast = ast == null ? null : ast.getBytes();
        this._env = env;
    }

    public static Env exec(String str) throws IllegalArgumentException {
        Exec.cluster_init();
        HashSet<Key> locked = new HashSet<Key>();
        Env env = Env.make(locked);
        try {
            Exec ex = new Exec(str, env);
            AST ast = ex.parse();
            if (!ex.allDone()) {
                Exec.throwErr("Note that only a single statement can be processed at a time. Junk at the end of the statement: ", ex);
            }
            env = ast.treeWalk(env);
            env.postWrite();
        }
        catch (RuntimeException t) {
            env.remove_and_unlock();
            throw t;
        }
        return env;
    }

    public static void new_func(final String str) throws IllegalArgumentException {
        Exec.cluster_init();
        new MRTask(){

            @Override
            public void setupLocal() {
                HashSet<Key> locked = new HashSet<Key>();
                Env env = Env.make(locked);
                Exec ex = new Exec(str, env);
                ex.parse_fun();
            }
        }.doAllNodes();
    }

    protected AST parse() {
        this.skipWS();
        if (!this.hasNext()) {
            throw new IllegalASTException("End of input unexpected. Badly formed AST.");
        }
        String tok = this.parseID();
        if (!this.hasNext()) {
            throw new IllegalASTException("End of input unexpected. Badly formed AST.");
        }
        AST ast = this.lookup(tok);
        return ast.parse_impl(this);
    }

    protected void parse_fun() {
        String tok = this.parseID();
        if (!tok.equals("def")) {
            throw new IllegalArgumentException("Expected function definition but got " + tok);
        }
        ASTFuncDef ast = new ASTFuncDef();
        ast.parse_func(this);
    }

    private AST lookup(String tok) {
        AST sym = ASTOp.SYMBOLS.get(tok);
        if (sym != null) {
            return sym.make();
        }
        sym = ASTOp.UDF_OPS.get(tok);
        if (sym != null) {
            return sym.make();
        }
        throw new IllegalArgumentException("*Unimplemented* failed lookup on token: `" + tok + "`. Contact support@h2o.ai for more information.");
    }

    String parseID() {
        StringBuilder sb = new StringBuilder();
        if (this.peek() == '(') {
            ++this._x;
            this.skipWS();
            if (this.peek() == ')') {
                sb.append((char)this._ast[this._x++]);
                return sb.toString();
            }
            return this.parseID();
        }
        if (this.isSpecial(this.peek())) {
            return sb.append((char)this._ast[this._x++]).toString();
        }
        while (this._x < this._ast.length && this._ast[this._x] != 32 && this._ast[this._x] != 41 && this._ast[this._x] != 59 && this._ast[this._x] != 39 && this._ast[this._x] != 34) {
            sb.append((char)this._ast[this._x++]);
        }
        this.skipWS();
        return sb.toString();
    }

    String parseString(char eq) {
        StringBuilder sb = new StringBuilder();
        while (this._ast[this._x] != eq) {
            sb.append((char)this._ast[this._x++]);
        }
        ++this._x;
        return sb.toString();
    }

    boolean hasNext() {
        return this._x < this._ast.length;
    }

    boolean allDone() {
        this.skipWS();
        if (this._x >= this._ast.length) {
            return true;
        }
        while (this.isEnd() && this._x < this._ast.length) {
            ++this._x;
            this.skipWS();
        }
        return this._x >= this._ast.length;
    }

    double nextDbl() {
        AST a = this.parse();
        if (a instanceof ASTNum) {
            return ((ASTNum)a)._d;
        }
        throw new IllegalArgumentException("Expected to parse a number, but got " + a.getClass());
    }

    String nextStr() {
        AST a = this.parse();
        if (a instanceof ASTFrame) {
            return ((ASTFrame)a)._key;
        }
        if (a instanceof ASTString) {
            return ((ASTString)a)._s;
        }
        throw new IllegalArgumentException("Expected to parse a String, but got " + a.getClass());
    }

    Exec xpeek(char c) {
        assert (this._ast[this._x] == c) : "Expected '" + c + "'. Got: '" + (char)this._ast[this._x] + "'. unparsed: " + this.unparsed() + " ; _x = " + this._x;
        ++this._x;
        return this;
    }

    char ppeek() {
        return (char)this._ast[this._x - 1];
    }

    char peek() {
        return (char)this._ast[this._x];
    }

    char peekPlus() {
        this.skipWS();
        return (char)this._ast[this._x++];
    }

    boolean isEnd() {
        return this._x >= this._ast.length || (char)this._ast[this._x] == ')';
    }

    void eatEnd() {
        this.skipWS();
        if (!this.isEnd()) {
            Exec.throwErr("No end to eat!", this);
        }
        ++this._x;
        this.skipWS();
    }

    Exec skipWS() {
        while (this._x < this._ast.length && (this.peek() == ' ' || this.peek() == ';')) {
            ++this._x;
        }
        return this;
    }

    boolean isSpecial(char c) {
        return c == '\"' || c == '\'' || c == '#' || c == '!' || c == '%' || c == '{';
    }

    boolean isQuoted(char c) {
        return c == '\"' || c == '\'';
    }

    char getQuote() {
        return (char)this._ast[this._x++];
    }

    String unparsed() {
        return new String(this._ast, this._x, this._ast.length - this._x);
    }

    static AST throwErr(String msg, Exec E) {
        int i;
        int idx = E._ast.length - 1;
        int lo = E._x;
        int hi = idx;
        String str = E._str;
        if (idx < lo) {
            hi = lo = idx;
        }
        String s = msg + '\n' + str + '\n';
        for (i = 0; i < lo; ++i) {
            s = s + ' ';
        }
        s = s + '^';
        ++i;
        while (i < hi) {
            s = s + '-';
            ++i;
        }
        if (i <= hi) {
            s = s + '^';
        }
        s = s + '\n';
        throw new IllegalArgumentException(s);
    }

    static void cluster_init() {
        if (_inited) {
            return;
        }
        new MRTask(){

            @Override
            public void setupLocal() {
                new ASTPlus();
            }
        }.doAllNodes();
        _inited = true;
    }
}

