/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.DKV;
import water.Key;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.fvec.Frame;
import water.rapids.Val;

class ValFrame
extends Val {
    final String _key;
    final Frame _fr;
    boolean _isVec;
    boolean _g;

    ValFrame(Frame fr) {
        this._key = null;
        this._fr = fr;
    }

    ValFrame(Frame fr, boolean g) {
        this(fr);
        this._g = g;
    }

    ValFrame(Frame fr, boolean isVec, boolean g) {
        this._key = null;
        this._fr = fr;
        this._isVec = isVec;
        this._g = g;
    }

    ValFrame(String key) {
        Key k = Key.make(key);
        if (DKV.get(k) == null) {
            throw new H2OKeyNotFoundArgumentException(key);
        }
        this._key = key;
        this._fr = (Frame)k.get();
        this._g = true;
    }

    public String toString() {
        return "Frame with key " + this._key + ". Frame: :" + this._fr.toString();
    }

    @Override
    int type() {
        return 1;
    }

    @Override
    String value() {
        return this._key;
    }
}

