/*
 * Decompiled with CFR 0.152.
 */
package water.serial;

import java.lang.reflect.Field;
import water.AutoBuffer;
import water.Freezable;
import water.serial.AutoBufferWithClassNames;
import water.serial.Serializer;

abstract class BinarySerializer<T extends Freezable, IO>
implements Serializer<T, IO> {
    BinarySerializer() {
    }

    protected int id(T m) {
        int r = m.getClass().getCanonicalName().hashCode();
        for (Field f : m.getClass().getDeclaredFields()) {
            r ^= f.getName().hashCode();
        }
        return r;
    }

    protected AutoBuffer saveHeader(T m, AutoBuffer ab) {
        ab.put4(this.id(m));
        ab.putStr(m.getClass().getName());
        return ab;
    }

    protected T loadHeader(AutoBuffer ab) {
        int smId = ab.get4();
        String smCN = ab.getStr();
        T m = null;
        try {
            m = AutoBufferWithClassNames.newInstance(smCN);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot instantiate the type " + smCN, e);
        }
        int amId = this.id(m);
        if (amId != smId) {
            throw new IllegalArgumentException("Trying to load incompatible model! Actual model id = " + amId + ", stored id = " + smId + ", type=" + smCN);
        }
        return m;
    }
}

