/*
 * Decompiled with CFR 0.152.
 */
package water.serial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import water.H2O;
import water.Key;
import water.Keyed;
import water.persist.Persist;
import water.serial.BinarySerializer;
import water.serial.KeyedBinarySerializer;
import water.serial.Serializer;
import water.util.FileUtils;
import water.util.Log;

public class ObjectTreeBinarySerializer
implements Serializer<List<Key>, URI> {
    public static final String METAFILE = "__h2o_bin.mbin";
    public static final String EXTENSION = ".bin";
    public static final String NULL_PLACEHOLDER = "<NULL>";
    final boolean dkvPutAfterLoad;
    final boolean overrideInDkv;
    final boolean overrideFile;

    public ObjectTreeBinarySerializer() {
        this(true, true, true);
    }

    public ObjectTreeBinarySerializer(boolean overrideFile) {
        this(true, true, overrideFile);
    }

    public ObjectTreeBinarySerializer(boolean dkvPutAfterLoad, boolean overrideInDkv, boolean overrideFile) {
        this.dkvPutAfterLoad = dkvPutAfterLoad;
        this.overrideInDkv = overrideInDkv;
        this.overrideFile = overrideFile;
    }

    @Override
    public void save(List<Key> objectTree, URI outputDir) throws IOException {
        assert (outputDir.getQuery() == null) : "Query parameters are not allowed in URI.";
        Persist persist = H2O.getPM().getPersistForURI(outputDir);
        if (!persist.mkdirs(outputDir.toString())) {
            boolean targetExists = persist.exists(outputDir.toString());
            if (this.overrideFile && targetExists) {
                Log.warn("Directory " + outputDir + " already exists.");
            } else {
                if (this.overrideFile && !targetExists || !this.overrideFile && !targetExists) {
                    throw new IllegalArgumentException("Directory " + outputDir + " cannot be created! Check you access privileges!");
                }
                throw new IllegalArgumentException("Directory " + outputDir + " already exists but " + "the flag for force overwrite is `false`.");
            }
        }
        ArrayList<String> savedFilenames = new ArrayList<String>(objectTree.size());
        BinarySerializer<Keyed, URI> serial = this.getKeyedSerializer();
        for (Key k : objectTree) {
            if (k != null) {
                String filename = FileUtils.keyToFileName(k) + EXTENSION;
                URI fileUri = URI.create(outputDir + "/" + filename);
                serial.save((Keyed)k.get(), fileUri);
                savedFilenames.add(filename);
                continue;
            }
            savedFilenames.add(NULL_PLACEHOLDER);
        }
        this.dumpMetaFile(persist, savedFilenames, outputDir);
    }

    @Override
    public List<Key> load(List<Key> l, URI inputDir) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Key> load(URI inputDir) throws IOException {
        Persist persist = H2O.getPM().getPersistForURI(inputDir);
        List<String> filenames = this.loadMetaFile(persist, inputDir);
        ArrayList<Key> objectTree = new ArrayList<Key>(filenames.size());
        BinarySerializer<Keyed, URI> serial = this.getKeyedSerializer();
        for (String filename : filenames) {
            if (!NULL_PLACEHOLDER.equals(filename)) {
                URI fileUri = URI.create(inputDir + "/" + filename);
                Keyed ok = (Keyed)serial.load(fileUri);
                objectTree.add(ok._key);
                continue;
            }
            objectTree.add(null);
        }
        Collections.reverse(objectTree);
        return objectTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpMetaFile(Persist persist, List<String> filenames, URI outputDir) throws IOException {
        URI metafileUri = URI.create(outputDir + "/" + METAFILE);
        PrintStream os = new PrintStream(persist.create(metafileUri.toString(), true));
        Collections.reverse(filenames);
        try {
            for (String fname : filenames) {
                os.println(fname);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(os);
            throw throwable;
        }
        FileUtils.close(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> loadMetaFile(Persist persist, URI inputDir) throws IOException {
        URI metafileUri = URI.create(inputDir + "/" + METAFILE);
        BufferedReader reader = new BufferedReader(new InputStreamReader(persist.open(metafileUri.toString())));
        LinkedList<String> filenames = new LinkedList<String>();
        try {
            String fname = null;
            while ((fname = reader.readLine()) != null) {
                filenames.add(fname);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(reader);
            throw throwable;
        }
        FileUtils.close(reader);
        return filenames;
    }

    protected BinarySerializer<Keyed, URI> getKeyedSerializer() {
        return new KeyedBinarySerializer(this.dkvPutAfterLoad, this.overrideInDkv, this.overrideFile);
    }
}

