/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import hex.Transformer;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.MathUtils;

public class DCTTransformer
extends Transformer<DCTTransformer> {
    public Frame _dataset;
    public Key<Frame> _destination_frame = Key.make();
    int[] _dimensions = null;
    boolean _inverse = false;

    public DCTTransformer() {
        this(Key.make());
    }

    public DCTTransformer(Key<DCTTransformer> dest) {
        this(dest, "DCTTransformer job");
    }

    public DCTTransformer(Key<DCTTransformer> dest, String desc) {
        super(dest, desc);
    }

    @Override
    protected DCTTransformer execImpl() {
        if (this._dimensions.length != 3) {
            this.error("_dimensions", "Need 3 dimensions (width/height/depth): WxHxD (1D: Wx1x1, 2D: WxHx1, 3D: WxHxD)");
        }
        if (ArrayUtils.minValue(this._dimensions) < 1L) {
            this.error("_dimensions", "Dimensions must be >= 1");
        }
        if (this._dataset.numCols() < this._dimensions[0] * this._dimensions[1] * this._dimensions[2]) {
            this.error("_dimensions", "Product of dimensions WxHxD must be <= #columns (" + this._dataset.numCols() + ")");
        }
        MathUtils.DCT.initCheck(this._dataset, this._dimensions[0], this._dimensions[1], this._dimensions[2]);
        return (DCTTransformer)this.start(new H2O.H2OCountedCompleter(){

            @Override
            protected void compute2() {
                Frame fft = DCTTransformer.this._dimensions[1] == 1 && DCTTransformer.this._dimensions[2] == 1 ? MathUtils.DCT.transform1D(DCTTransformer.this._dataset, DCTTransformer.this._dimensions[0], DCTTransformer.this._inverse) : (DCTTransformer.this._dimensions[2] == 1 ? MathUtils.DCT.transform2D(DCTTransformer.this._dataset, DCTTransformer.this._dimensions[0], DCTTransformer.this._dimensions[1], DCTTransformer.this._inverse) : MathUtils.DCT.transform3D(DCTTransformer.this._dataset, DCTTransformer.this._dimensions[0], DCTTransformer.this._dimensions[1], DCTTransformer.this._dimensions[2], DCTTransformer.this._inverse));
                Frame dest = new Frame(DCTTransformer.this._destination_frame, fft.names(), fft.vecs());
                DKV.put(dest);
                this.tryComplete();
            }

            @Override
            public void onCompletion(CountedCompleter caller) {
                DCTTransformer.this.done();
            }
        }, 1L, true);
    }
}

