/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.Vec;
import water.parser.ParseDataset;
import water.util.ChunkSummary;
import water.util.Log;
import water.util.RandomUtils;

public class FrameUtils {
    public static Frame parseFrame(Key okey, File ... files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("List of files is empty!");
        }
        for (File f : files) {
            if (f.exists()) continue;
            throw new FileNotFoundException("File not found " + f);
        }
        if (okey == null) {
            okey = Key.make(files[0].getName());
        }
        Key[] inKeys = new Key[files.length];
        for (int i = 0; i < files.length; ++i) {
            inKeys[i] = NFSFileVec.make((File)files[i])._key;
        }
        return ParseDataset.parse(okey, inKeys);
    }

    public static Frame parseFrame(Key okey, URI ... uris) throws IOException {
        if (uris == null || uris.length == 0) {
            throw new IllegalArgumentException("List of uris is empty!");
        }
        if (okey == null) {
            okey = Key.make(uris[0].toString());
        }
        Key[] inKeys = new Key[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            inKeys[i] = H2O.getPM().anyURIToKey(uris[i]);
        }
        return ParseDataset.parse(okey, inKeys);
    }

    public static double[] asDoubles(Vec v) {
        if (v.length() > 100000L) {
            throw new IllegalArgumentException("Vec is too big to be extracted into array");
        }
        return ((Vec2ArryTsk)new Vec2ArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
    }

    public static int[] asInts(Vec v) {
        if (v.length() > 100000L) {
            throw new IllegalArgumentException("Vec is too big to be extracted into array");
        }
        return ((Vec2IntArryTsk)new Vec2IntArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
    }

    public static ChunkSummary chunkSummary(Frame fr) {
        return (ChunkSummary)new ChunkSummary().doAll(fr);
    }

    public static Key[] generateNumKeys(Key mk, int num) {
        return FrameUtils.generateNumKeys(mk, num, "_part");
    }

    public static Key[] generateNumKeys(Key mk, int num, String delim) {
        Key[] ks = new Key[num];
        String n = mk != null ? mk.toString() : "noname";
        String suffix = "";
        if (n.endsWith(".hex")) {
            n = n.substring(0, n.length() - 4);
            suffix = ".hex";
        }
        for (int i = 0; i < num; ++i) {
            ks[i] = Key.make(n + delim + i + suffix);
        }
        return ks;
    }

    public static double sparseRatio(Frame fr) {
        double reg = 1.0 / (double)fr.numCols();
        double res = 0.0;
        for (Vec v : fr.vecs()) {
            res += v.sparseRatio();
        }
        return res * reg;
    }

    public static double sparseRatio(Chunk[] chks) {
        int cnt = 0;
        double reg = 1.0 / (double)chks.length;
        for (Chunk c : chks) {
            if (!c.isSparse()) continue;
            ++cnt;
        }
        return (double)cnt * reg;
    }

    public static class WeightedMean
    extends MRTask<WeightedMean> {
        private double _wresponse;
        private double _wsum;

        public double weightedMean() {
            return this._wsum == 0.0 ? 0.0 : this._wresponse / this._wsum;
        }

        @Override
        public void map(Chunk response, Chunk weight, Chunk offset) {
            for (int i = 0; i < response._len; ++i) {
                double w;
                if (response.isNA(i) || (w = weight.atd(i)) == 0.0) continue;
                this._wresponse += w * (response.atd(i) - offset.atd(i));
                this._wsum += w;
            }
        }

        @Override
        public void reduce(WeightedMean mrt) {
            this._wresponse += mrt._wresponse;
            this._wsum += mrt._wsum;
        }
    }

    public static class MissingInserter
    extends Job<Frame> {
        final Key _dataset;
        final double _fraction;
        final long _seed;

        public MissingInserter(Key frame, long seed, double frac) {
            super(frame, "MissingValueInserter");
            this._dataset = frame;
            this._seed = seed;
            this._fraction = frac;
        }

        public void execImpl() {
            if (DKV.get(this._dataset) == null) {
                throw new IllegalArgumentException("Invalid Frame key " + this._dataset + " (Frame doesn't exist).");
            }
            if (this._fraction < 0.0 || this._fraction > 1.0) {
                throw new IllegalArgumentException("fraction must be between 0 and 1.");
            }
            try {
                Frame frame = (Frame)DKV.getGet(this._dataset);
                MissingInserterDriver mid = new MissingInserterDriver(frame);
                int work = frame.vecs()[0].nChunks();
                this.start(mid, work, true);
            }
            catch (Throwable t) {
                Job thisJob = (Job)DKV.getGet(this._key);
                if (thisJob._state == Job.JobState.CANCELLED) {
                    Log.info("Job cancelled by user.");
                }
                this.failed(t);
                throw t;
            }
        }

        class MissingInserterDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;

            MissingInserterDriver(Frame frame) {
                this._frame = frame;
            }

            @Override
            protected void compute2() {
                new MRTask(){

                    @Override
                    public void map(Chunk[] cs) {
                        Random rng = RandomUtils.getRNG(0L);
                        for (int c = 0; c < cs.length; ++c) {
                            for (int r = 0; r < cs[c]._len; ++r) {
                                rng.setSeed(MissingInserter.this._seed + (long)(1234 * c) ^ 1723L * (cs[c].start() + (long)r));
                                if (!(rng.nextDouble() < MissingInserter.this._fraction)) continue;
                                cs[c].setNA(r);
                            }
                        }
                        MissingInserter.this.update(1L);
                    }
                }.doAll(this._frame);
                this.tryComplete();
            }

            @Override
            public void onCompletion(CountedCompleter caller) {
                MissingInserter.this.done();
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter cc) {
                MissingInserter.this.failed(ex);
                return true;
            }
        }
    }

    private static class Vec2IntArryTsk
    extends MRTask<Vec2IntArryTsk> {
        final int N;
        public int[] res;

        public Vec2IntArryTsk(int N) {
            this.N = N;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc4(this.N);
        }

        @Override
        public void map(Chunk c) {
            int off = (int)c.start();
            int i = 0;
            while (i < c._len) {
                this.res[off + i] = (int)c.at8(i);
                i = c.nextNZ(i);
            }
        }

        @Override
        public void reduce(Vec2IntArryTsk other) {
            if (this.res != other.res) {
                for (int i = 0; i < this.res.length; ++i) {
                    assert (this.res[i] == 0 || other.res[i] == 0);
                    int n = i;
                    this.res[n] = this.res[n] + other.res[i];
                }
            }
        }
    }

    private static class Vec2ArryTsk
    extends MRTask<Vec2ArryTsk> {
        final int N;
        public double[] res;

        public Vec2ArryTsk(int N) {
            this.N = N;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc8d(this.N);
        }

        @Override
        public void map(Chunk c) {
            int off = (int)c.start();
            int i = 0;
            while (i < c._len) {
                this.res[off + i] = c.atd(i);
                i = c.nextNZ(i);
            }
        }

        @Override
        public void reduce(Vec2ArryTsk other) {
            if (this.res != other.res) {
                for (int i = 0; i < this.res.length; ++i) {
                    assert (this.res[i] == 0.0 || other.res[i] == 0.0);
                    int n = i;
                    this.res[n] = this.res[n] + other.res[i];
                }
            }
        }
    }
}

