/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import water.H2O;
import water.util.SB;

public class JCodeGen {
    public static int MAX_STRINGS_IN_CONST_POOL = 3000;
    private static final Method DEFINE_CLASS_METHOD;
    private static final JavaCompiler COMPILER;

    public static SB toStaticVar(SB sb, String varname, int value, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        return sb.ip("public static final int ").p(varname).p(" = ").p(value).p(';').nl();
    }

    public static SB toStaticVar(SB sb, String varname, String[] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final String[] ").p(varname).p(" = ");
        if (values == null) {
            return sb.p("null;").nl();
        }
        sb.p("new String[]{").p("\"" + values[0] + "\"");
        for (int i = 1; i < values.length; ++i) {
            sb.p(",").p("\"" + values[i] + "\"");
        }
        return sb.p("};").nl();
    }

    public static SB toStaticVar(SB sb, String varname, float[] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final float[] ").p(varname).p(" = ");
        if (values == null) {
            return sb.p("null;").nl();
        }
        sb.p("{").pj(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.p(",").pj(values[i]);
        }
        return sb.p("};").nl();
    }

    public static SB toStaticVarZeros(SB sb, String varname, double[] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final double[] ").p(varname).p(" = new double[" + values.length + "];");
        return sb.nl();
    }

    public static SB toStaticVar(SB sb, String varname, double[] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final double[] ").p(varname).p(" = ");
        if (values == null) {
            return sb.p("null;").nl();
        }
        sb.p("{").pj(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.p(",").pj(values[i]);
        }
        return sb.p("};").nl();
    }

    public static SB toStaticVar(SB sb, String varname, int[] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final int[] ").p(varname).p(" = ");
        if (values == null) {
            return sb.p("null;").nl();
        }
        sb.p("{").p(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.p(",").p(values[i]);
        }
        return sb.p("};").nl();
    }

    public static SB toStaticVar(SB sb, String varname, double[][] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final double[][] ").p(varname).p(" = ");
        return sb.toJavaStringInit(values).p(';').nl();
    }

    public static SB toStaticVar(SB sb, String varname, double[][][] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final double[][][] ").p(varname).p(" = ");
        return sb.toJavaStringInit(values).p(';').nl();
    }

    public static SB toStaticVar(SB sb, String varname, boolean[] values, String comment) {
        if (comment != null) {
            sb.ip("// ").p(comment).nl();
        }
        sb.ip("public static final boolean[] ").p(varname).p(" = ");
        if (values == null) {
            return sb.p("null;").nl();
        }
        sb.p("{").p(values[0]);
        for (int i = 1; i < values.length; ++i) {
            sb.p(",").p(values[i]);
        }
        return sb.p("};").nl();
    }

    public static SB toClassWithArray(SB sb, String modifiers, String className, String[] values) {
        sb.ip(modifiers != null ? modifiers + " " : "").p("class ").p(className).p(" implements java.io.Serializable {").nl().ii(1);
        sb.ip("public static final String[] VALUES = ");
        if (values == null) {
            sb.p("null;").nl();
        } else {
            int len;
            sb.p("new String[").p(values.length).p("];").nl();
            int s = 0;
            int its = 0;
            SB sb4fillers = new SB().ci(sb);
            sb.ip("static {").ii(1).nl();
            for (int remain = values.length; remain > 0; remain -= len) {
                String subClzName = className + "_" + its++;
                len = Math.min(MAX_STRINGS_IN_CONST_POOL, remain);
                JCodeGen.toClassWithArrayFill(sb4fillers, subClzName, values, s, len);
                sb.ip(subClzName).p(".fill(VALUES);").nl();
                s += len;
            }
            sb.di(1).ip("}").nl();
            sb.p(sb4fillers);
        }
        return sb.di(1).p("}").nl();
    }

    public static SB toClassWithArray(SB sb, String modifiers, String className, double[] values) {
        sb.ip(modifiers != null ? modifiers + " " : "").p("class ").p(className).p(" implements java.io.Serializable {").nl().ii(1);
        sb.ip("public static final double[] VALUES = ");
        if (values == null) {
            sb.p("null;").nl();
        } else {
            int len;
            sb.p("new double[").p(values.length).p("];").nl();
            int s = 0;
            int its = 0;
            SB sb4fillers = new SB().ci(sb);
            sb.ip("static {").ii(1).nl();
            for (int remain = values.length; remain > 0; remain -= len) {
                String subClzName = className + "_" + its++;
                len = Math.min(MAX_STRINGS_IN_CONST_POOL, remain);
                JCodeGen.toClassWithArrayFill(sb4fillers, subClzName, values, s, len);
                sb.ip(subClzName).p(".fill(VALUES);").nl();
                s += len;
            }
            sb.di(1).ip("}").nl();
            sb.p(sb4fillers);
        }
        return sb.di(1).p("}").nl();
    }

    public static SB toClassWithArray(SB sb, String modifiers, String className, float[] values) {
        sb.ip(modifiers != null ? modifiers + " " : "").p("class ").p(className).p(" implements java.io.Serializable {").nl().ii(1);
        sb.ip("public static final float[] VALUES = ");
        if (values == null) {
            sb.p("null;").nl();
        } else {
            int len;
            sb.p("new float[").p(values.length).p("];").nl();
            int s = 0;
            int its = 0;
            SB sb4fillers = new SB().ci(sb);
            sb.ip("static {").ii(1).nl();
            for (int remain = values.length; remain > 0; remain -= len) {
                String subClzName = className + "_" + its++;
                len = Math.min(MAX_STRINGS_IN_CONST_POOL, remain);
                JCodeGen.toClassWithArrayFill(sb4fillers, subClzName, values, s, len);
                sb.ip(subClzName).p(".fill(VALUES);").nl();
                s += len;
            }
            sb.di(1).ip("}").nl();
            sb.p(sb4fillers);
        }
        return sb.di(1).p("}").nl();
    }

    public static SB toClassWithArrayFill(SB sb, String clzName, String[] values, int start, int len) {
        sb.ip("static final class ").p(clzName).p(" implements java.io.Serializable {").ii(1).nl();
        sb.ip("static final void fill(String[] sa) {").ii(1).nl();
        for (int i = 0; i < len; ++i) {
            sb.ip("sa[").p(start + i).p("] = ").ps(values[start + i]).p(";").nl();
        }
        sb.di(1).ip("}").nl();
        sb.di(1).ip("}").nl();
        return sb;
    }

    public static SB toClassWithArrayFill(SB sb, String clzName, float[] values, int start, int len) {
        sb.ip("static final class ").p(clzName).p(" implements java.io.Serializable {").ii(1).nl();
        sb.ip("static final void fill(float[] sa) {").ii(1).nl();
        for (int i = 0; i < len; ++i) {
            sb.ip("sa[").p(start + i).p("] = ").pj(values[start + i]).p(";").nl();
        }
        sb.di(1).ip("}").nl();
        sb.di(1).ip("}").nl();
        return sb;
    }

    public static SB toClassWithArrayFill(SB sb, String clzName, double[] values, int start, int len) {
        sb.ip("static final class ").p(clzName).p(" implements java.io.Serializable {").ii(1).nl();
        sb.ip("static final void fill(double[] sa) {").ii(1).nl();
        for (int i = 0; i < len; ++i) {
            sb.ip("sa[").p(start + i).p("] = ").pj(values[start + i]).p(";").nl();
        }
        sb.di(1).ip("}").nl();
        sb.di(1).ip("}").nl();
        return sb;
    }

    public static String toJavaId(String s) {
        return s.replaceAll("[+\\-* !@#$%^&()={}\\[\\]|;:'\"<>,.?/]", "_");
    }

    public static boolean canCompile() {
        return COMPILER != null;
    }

    public static Class compile(String class_name, String java_text) throws Exception {
        if (COMPILER == null) {
            throw new UnsupportedOperationException("Unable to launch an internal instance of javac");
        }
        JavaSourceFromString file = new JavaSourceFromString(class_name, java_text);
        JavacFileManager jfm = new JavacFileManager(COMPILER.getStandardFileManager(null, null, null));
        if (!COMPILER.getTask(null, jfm, null, null, null, Arrays.asList(file)).call().booleanValue()) {
            throw H2O.fail("Internal POJO compilation failed.");
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        for (Map.Entry<String, ByteArrayOutputStream> entry : jfm._buffers.entrySet()) {
            byte[] bits = entry.getValue().toByteArray();
            DEFINE_CLASS_METHOD.invoke((Object)cl, entry.getKey(), bits, 0, bits.length);
        }
        return Class.forName(class_name);
    }

    static {
        COMPILER = ToolProvider.getSystemJavaCompiler();
        try {
            DEFINE_CLASS_METHOD = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            DEFINE_CLASS_METHOD.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    static class JavacFileManager
    implements JavaFileManager {
        private final StandardJavaFileManager _fileManager;
        final HashMap<String, ByteArrayOutputStream> _buffers = new HashMap();

        JavacFileManager(StandardJavaFileManager fileManager) {
            this._fileManager = fileManager;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this._fileManager.getClassLoader(location);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            return this._fileManager.list(location, packageName, kinds, recurse);
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            return this._fileManager.inferBinaryName(location, file);
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            return this._fileManager.isSameFile(a, b);
        }

        @Override
        public boolean handleOption(String current, Iterator<String> remaining) {
            return this._fileManager.handleOption(current, remaining);
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            return this._fileManager.hasLocation(location);
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            if (location == StandardLocation.CLASS_OUTPUT && this._buffers.containsKey(className) && kind == JavaFileObject.Kind.CLASS) {
                final byte[] bytes = this._buffers.get(className).toByteArray();
                return new SimpleJavaFileObject(URI.create(className), kind){

                    @Override
                    public InputStream openInputStream() {
                        return new ByteArrayInputStream(bytes);
                    }
                };
            }
            return this._fileManager.getJavaFileForInput(location, className, kind);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return new SimpleJavaFileObject(URI.create(className), kind){

                @Override
                public OutputStream openOutputStream() {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    JavacFileManager.this._buffers.put(className, baos);
                    return baos;
                }
            };
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            return this._fileManager.getFileForInput(location, packageName, relativeName);
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            return this._fileManager.getFileForOutput(location, packageName, relativeName, sibling);
        }

        @Override
        public void flush() throws IOException {
            this._fileManager.flush();
        }

        @Override
        public void close() throws IOException {
            this._fileManager.close();
        }

        @Override
        public int isSupportedOption(String option) {
            return this._fileManager.isSupportedOption(option);
        }
    }

    static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String _code;

        JavaSourceFromString(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this._code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this._code;
        }
    }
}

