/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import water.DTask;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.RPC;
import water.api.API;
import water.api.Schema;
import water.persist.PersistManager;
import water.util.Log;

public class WaterMeterIo
extends Iced {
    public int nodeidx;
    public IoStatsEntry[] persist_stats;

    public void doIt(boolean aggregateAllNodes) {
        if (!aggregateAllNodes) {
            this.doIt(this.nodeidx);
            return;
        }
        for (int i = 0; i < H2O.CLOUD.size(); ++i) {
            int j;
            WaterMeterIo io = new WaterMeterIo();
            io.doIt(i);
            if (i == 0) {
                this.persist_stats = new IoStatsEntry[io.persist_stats.length];
                for (j = 0; j < this.persist_stats.length; ++j) {
                    this.persist_stats[j] = new IoStatsEntry();
                    this.persist_stats[j].backend = io.persist_stats[j].backend;
                }
            }
            for (j = 0; j < this.persist_stats.length; ++j) {
                this.persist_stats[j].store_count += io.persist_stats[j].store_count;
                this.persist_stats[j].store_bytes += io.persist_stats[j].store_bytes;
                this.persist_stats[j].delete_count += io.persist_stats[j].delete_count;
                this.persist_stats[j].load_count += io.persist_stats[j].load_count;
                this.persist_stats[j].load_bytes += io.persist_stats[j].load_bytes;
            }
        }
    }

    private void doIt(int idx) {
        H2ONode node = H2O.CLOUD._memary[idx];
        GetTask t = new GetTask();
        Log.trace("IO GetTask starting to node " + idx + "...");
        new RPC<GetTask>(node, t).call().get();
        Log.trace("IO GetTask completed to node " + idx);
        this.persist_stats = t._persist_stats;
    }

    private static class GetTask
    extends DTask<GetTask> {
        private IoStatsEntry[] _persist_stats = null;

        @Override
        public void compute2() {
            int[] backendsToZeroCheck;
            PersistManager.PersistStatsEntry[] s = H2O.getPM().getStats();
            int[] backendsToQuery = new int[]{4, 2, 3, 1};
            this._persist_stats = new IoStatsEntry[backendsToQuery.length];
            for (int i = 0; i < this._persist_stats.length; ++i) {
                int j = backendsToQuery[i];
                this._persist_stats[i] = new IoStatsEntry();
                IoStatsEntry dest_e = this._persist_stats[i];
                switch (j) {
                    case 1: {
                        dest_e.backend = "ice";
                        break;
                    }
                    case 2: {
                        dest_e.backend = "hdfs";
                        break;
                    }
                    case 3: {
                        dest_e.backend = "s3";
                        break;
                    }
                    case 4: {
                        dest_e.backend = "local";
                        break;
                    }
                    default: {
                        throw H2O.fail();
                    }
                }
                PersistManager.PersistStatsEntry src_e = s[j];
                dest_e.store_count = src_e.store_count.get();
                dest_e.store_bytes = src_e.store_bytes.get();
                dest_e.delete_count = src_e.delete_count.get();
                dest_e.load_count = src_e.load_count.get();
                dest_e.load_bytes = src_e.load_bytes.get();
            }
            for (int j : backendsToZeroCheck = new int[]{0, 5, 6, 7}) {
                PersistManager.PersistStatsEntry src_e = s[j];
                assert (src_e.store_count.get() == 0L);
                assert (src_e.store_bytes.get() == 0L);
                assert (src_e.delete_count.get() == 0L);
                assert (src_e.load_count.get() == 0L);
                assert (src_e.load_bytes.get() == 0L);
            }
            this.tryComplete();
        }

        @Override
        public byte priority() {
            return 119;
        }
    }

    public static class IoStatsEntry
    extends Schema<Iced, IoStatsEntry> {
        @API(help="Back end type", direction=API.Direction.OUTPUT)
        public String backend;
        @API(help="Number of store events", direction=API.Direction.OUTPUT)
        public long store_count;
        @API(help="Cumulative stored bytes", direction=API.Direction.OUTPUT)
        public long store_bytes;
        @API(help="Number of delete events", direction=API.Direction.OUTPUT)
        public long delete_count;
        @API(help="Number of load events", direction=API.Direction.OUTPUT)
        public long load_count;
        @API(help="Cumulative loaded bytes", direction=API.Direction.OUTPUT)
        public long load_bytes;
    }
}

