/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Random;
import water.H2O;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.fvec.FrameCreator;
import water.util.PrettyPrint;

public class CreateFrame
extends Job<Frame> {
    public long rows = 10000L;
    public int cols = 10;
    public long seed = new Random().nextLong();
    public boolean randomize = true;
    public long value = 0L;
    public long real_range = 100L;
    public double categorical_fraction = 0.2;
    public int factors = 100;
    public double integer_fraction = 0.2;
    public long integer_range = 100L;
    public double binary_fraction = 0.1;
    public double binary_ones_fraction = 0.02;
    public double missing_fraction = 0.01;
    public int response_factors = 2;
    public boolean positive_response;
    public boolean has_response = false;

    public CreateFrame(Key<Frame> dest, String desc) {
        super(dest, desc == null ? "CreateFrame" : desc);
    }

    public CreateFrame() {
        super(Key.make(), "CreateFrame");
    }

    public Job<Frame> execImpl() {
        double byte_estimate;
        if (this.integer_fraction + this.binary_fraction + this.categorical_fraction > 1.0) {
            throw new IllegalArgumentException("Integer, binary and categorical fractions must add up to <= 1.");
        }
        if (Math.abs(this.missing_fraction) > 1.0) {
            throw new IllegalArgumentException("Missing fraction must be between 0 and 1.");
        }
        if (Math.abs(this.integer_fraction) > 1.0) {
            throw new IllegalArgumentException("Integer fraction must be between 0 and 1.");
        }
        if (Math.abs(this.binary_fraction) > 1.0) {
            throw new IllegalArgumentException("Binary fraction must be between 0 and 1.");
        }
        if (Math.abs(this.binary_ones_fraction) > 1.0) {
            throw new IllegalArgumentException("Binary ones fraction must be between 0 and 1.");
        }
        if (Math.abs(this.categorical_fraction) > 1.0) {
            throw new IllegalArgumentException("Categorical fraction must be between 0 and 1.");
        }
        if (this.categorical_fraction > 0.0 && this.factors <= 1) {
            throw new IllegalArgumentException("Factors must be larger than 2 for categorical data.");
        }
        if (this.response_factors < 1) {
            throw new IllegalArgumentException("Response factors must be either 1 (real-valued response), or >=2 (factor levels).");
        }
        if (this.response_factors > 1024) {
            throw new IllegalArgumentException("Response factors must be <= 1024.");
        }
        if (this.factors > 1000000) {
            throw new IllegalArgumentException("Number of factors must be <= 1,000,000).");
        }
        if (this.cols <= 0 || this.rows <= 0L) {
            throw new IllegalArgumentException("Must have number of rows > 0 and columns > 1.");
        }
        double d = this.randomize ? (double)(this.rows * (long)this.cols) * (this.binary_fraction * 1.0 / 8.0 + this.categorical_fraction * (double)(this.factors < 128 ? 1 : (this.factors < 32768 ? 2 : 4)) + this.integer_fraction * (double)(this.integer_range < 128L ? 1 : (this.integer_range < 32768L ? 2 : (this.integer_range < Integer.MIN_VALUE ? 4 : 8))) + (1.0 - this.integer_fraction - this.binary_fraction - this.categorical_fraction) * 8.0) + (double)(this.rows * 1L) : (byte_estimate = 0.0);
        if (byte_estimate > (double)(H2O.CLOUD._memary[0].get_max_mem() * (long)H2O.CLOUD.size())) {
            throw new IllegalArgumentException("Frame is expected to require " + PrettyPrint.bytes((long)byte_estimate) + ", won't fit into H2O's memory.");
        }
        if (!this.randomize) {
            if (this.integer_fraction != 0.0 || this.categorical_fraction != 0.0) {
                throw new IllegalArgumentException("Cannot have integer or categorical fractions > 0 unless randomize=true.");
            }
        } else if (this.value != 0L) {
            throw new IllegalArgumentException("Cannot set data to a constant value if randomize=true.");
        }
        if (this._dest == null) {
            throw new IllegalArgumentException("Destination frame name cannot be null.");
        }
        FrameCreator fc = new FrameCreator(this, this._key);
        this.start(fc, fc.nChunks() * 5, true);
        return this;
    }
}

