/*
 * Decompiled with CFR 0.152.
 */
package hex;

import water.H2O;
import water.Iced;

public class Distribution
extends Iced {
    public static double MIN_LOG = -19.0;
    public static double MAX = Math.exp(19.0);
    public final Family distribution;
    public final double tweediePower;

    public Distribution(Family distribution) {
        assert (distribution != Family.tweedie);
        this.distribution = distribution;
        this.tweediePower = 0.0;
    }

    public Distribution(Family distribution, double tweediePower) {
        this.distribution = distribution;
        assert (tweediePower > 1.0 && tweediePower < 2.0);
        this.tweediePower = tweediePower;
    }

    public static double exp(double x) {
        double val = Math.min(MAX, Math.exp(x));
        return val;
    }

    public static double log(double x) {
        double val = (x = Math.max(0.0, x)) == 0.0 ? MIN_LOG : Math.max(MIN_LOG, Math.log(x));
        return val;
    }

    public static String expString(String x) {
        return "Math.min(" + MAX + ", Math.exp(" + x + "))";
    }

    public double deviance(double w, double y, double f) {
        f = this.link(f);
        switch (this.distribution) {
            case AUTO: 
            case gaussian: {
                return w * (y - f) * (y - f);
            }
            case huber: {
                if (Math.abs(y - f) < 1.0) {
                    return w * (y - f) * (y - f);
                }
                return 2.0 * w * Math.abs(y - f) - 1.0;
            }
            case laplace: {
                return 2.0 * w * Math.abs(y - f);
            }
            case bernoulli: {
                return -2.0 * w * (y * f - Distribution.log(1.0 + Distribution.exp(f)));
            }
            case poisson: {
                return -2.0 * w * (y * f - Distribution.exp(f));
            }
            case gamma: {
                return 2.0 * w * (y * Distribution.exp(-f) + f);
            }
            case tweedie: {
                assert (this.tweediePower > 1.0 && this.tweediePower < 2.0);
                return 2.0 * w * (Math.pow(y, 2.0 - this.tweediePower) / ((1.0 - this.tweediePower) * (2.0 - this.tweediePower)) - y * Distribution.exp(f * (1.0 - this.tweediePower)) / (1.0 - this.tweediePower) + Distribution.exp(f * (2.0 - this.tweediePower)) / (2.0 - this.tweediePower));
            }
        }
        throw H2O.unimpl();
    }

    public double gradient(double y, double f) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case bernoulli: 
            case poisson: {
                return y - this.linkInv(f);
            }
            case gamma: {
                return y * Distribution.exp(-f) - 1.0;
            }
            case tweedie: {
                assert (this.tweediePower > 1.0 && this.tweediePower < 2.0);
                return y * Distribution.exp(f * (1.0 - this.tweediePower)) - Distribution.exp(f * (2.0 - this.tweediePower));
            }
            case huber: {
                if (Math.abs(y - f) < 1.0) {
                    return y - f;
                }
                return f - 1.0 >= y ? -1.0 : 1.0;
            }
            case laplace: {
                return f > y ? -1.0 : 1.0;
            }
        }
        throw H2O.unimpl();
    }

    public double link(double f) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case huber: 
            case laplace: {
                return f;
            }
            case bernoulli: {
                return Distribution.log(f / (1.0 - f));
            }
            case poisson: 
            case gamma: 
            case tweedie: 
            case multinomial: {
                return Distribution.log(f);
            }
        }
        throw H2O.unimpl();
    }

    public double linkInv(double f) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case huber: 
            case laplace: {
                return f;
            }
            case bernoulli: {
                return 1.0 / (1.0 + Distribution.exp(-f));
            }
            case poisson: 
            case gamma: 
            case tweedie: 
            case multinomial: {
                return Distribution.exp(f);
            }
        }
        throw H2O.unimpl();
    }

    public String linkInvString(String f) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case huber: 
            case laplace: {
                return f;
            }
            case bernoulli: {
                return "1/(1+" + Distribution.expString("-" + f) + ")";
            }
            case poisson: 
            case gamma: 
            case tweedie: 
            case multinomial: {
                return Distribution.expString(f);
            }
        }
        throw H2O.unimpl();
    }

    public double initFNum(double w, double o, double y) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case bernoulli: 
            case multinomial: {
                return w * (y - o);
            }
            case poisson: {
                return w * y;
            }
            case gamma: {
                return w * y * this.linkInv(-o);
            }
            case tweedie: {
                return w * y * Distribution.exp(o * (1.0 - this.tweediePower));
            }
        }
        throw H2O.unimpl();
    }

    public double initFDenom(double w, double o) {
        switch (this.distribution) {
            case AUTO: 
            case gaussian: 
            case bernoulli: 
            case gamma: 
            case multinomial: {
                return w;
            }
            case poisson: {
                return w * this.linkInv(o);
            }
            case tweedie: {
                return w * Distribution.exp(o * (2.0 - this.tweediePower));
            }
        }
        throw H2O.unimpl();
    }

    public double gammaNum(double w, double y, double z, double f) {
        switch (this.distribution) {
            case gaussian: 
            case bernoulli: 
            case multinomial: {
                return w * z;
            }
            case poisson: {
                return w * y;
            }
            case gamma: {
                return w * (z + 1.0);
            }
            case tweedie: {
                return w * y * Distribution.exp(f * (1.0 - this.tweediePower));
            }
        }
        throw H2O.unimpl();
    }

    public double gammaDenom(double w, double y, double z, double f) {
        switch (this.distribution) {
            case gaussian: 
            case gamma: {
                return w;
            }
            case bernoulli: {
                double ff = y - z;
                return w * ff * (1.0 - ff);
            }
            case multinomial: {
                double absz = Math.abs(z);
                return w * (absz * (1.0 - absz));
            }
            case poisson: {
                return w * (y - z);
            }
            case tweedie: {
                return w * Distribution.exp(f * (2.0 - this.tweediePower));
            }
        }
        throw H2O.unimpl();
    }

    public static enum Family {
        AUTO,
        bernoulli,
        multinomial,
        gaussian,
        poisson,
        gamma,
        tweedie,
        huber,
        laplace;

    }
}

