/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.Model;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.schemas.ModelBuilderSchema;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import jsr166y.CountedCompleter;
import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.MRTask;
import water.TAtomic;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.ASTOp;
import water.util.FrameUtils;
import water.util.Log;
import water.util.MRUtils;
import water.util.ReflectionUtils;

public abstract class ModelBuilder<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends Job<M> {
    public P _parms;
    protected transient Frame _train;
    protected transient Frame _valid;
    private Key[] cvModelBuilderKeys;
    private static final Map<String, Class<? extends ModelBuilder>> _builders = new HashMap<String, Class<? extends ModelBuilder>>();
    private static final Map<Class<? extends Model>, String> _model_class_to_algo = new HashMap<Class<? extends Model>, String>();
    private static final Map<String, String> _algo_to_algo_full_name = new HashMap<String, String>();
    private static final Map<String, Class<? extends Model>> _algo_to_model_class = new HashMap<String, Class<? extends Model>>();
    boolean _deleteProgressKey = true;
    protected transient Vec _response;
    protected transient Vec _vresponse;
    protected transient Vec _offset;
    protected transient Vec _weights;
    protected transient Vec _fold;
    protected int _nclass;
    transient double[] _distribution;
    transient double[] _priorClassDist;

    public final Frame train() {
        return this._train;
    }

    public final Frame valid() {
        return this._valid;
    }

    public Vec response() {
        return this._response;
    }

    public Vec vresponse() {
        return this._vresponse;
    }

    protected double responseMean() {
        if (this.hasWeightCol() || this.hasOffsetCol()) {
            return ((FrameUtils.WeightedMean)new FrameUtils.WeightedMean().doAll(this._response, this.hasWeightCol() ? this._weights : this._response.makeCon(1.0), this.hasOffsetCol() ? this._offset : this._response.makeCon(0.0))).weightedMean();
        }
        return this._response.mean();
    }

    public static void registerModelBuilder(String name, String full_name, Class<? extends ModelBuilder> clz) {
        _builders.put(name, clz);
        Class model_class = ReflectionUtils.findActualClassParameter(clz, 0);
        _model_class_to_algo.put(model_class, name);
        _algo_to_algo_full_name.put(name, full_name);
        _algo_to_model_class.put(name, model_class);
    }

    public static Map<String, Class<? extends ModelBuilder>> getModelBuilders() {
        return _builders;
    }

    public static Class<? extends ModelBuilder> getModelBuilder(String name) {
        return _builders.get(name);
    }

    public static Class<? extends Model> getModelClass(String name) {
        return _algo_to_model_class.get(name);
    }

    public static String getAlgo(Model model) {
        return _model_class_to_algo.get(model.getClass());
    }

    public static String getAlgoFullName(String algo) {
        return _algo_to_algo_full_name.get(algo);
    }

    public String getAlgo() {
        return ModelBuilder.getAlgo(this.getClass());
    }

    public static String getAlgo(Class<? extends ModelBuilder> clz) {
        if (_builders.isEmpty()) {
            return "Unknown algo (should only happen under JUnit)";
        }
        if (!_builders.containsValue(clz)) {
            throw new H2OIllegalArgumentException("Failed to find ModelBuilder class in registry: " + clz, "Failed to find ModelBuilder class in registry: " + clz);
        }
        for (Map.Entry<String, Class<? extends ModelBuilder>> entry : _builders.entrySet()) {
            if (!entry.getValue().equals(clz)) continue;
            return entry.getKey();
        }
        throw new H2OIllegalArgumentException("Failed to find ModelBuilder class in registry: " + clz, "Failed to find ModelBuilder class in registry: " + clz);
    }

    public abstract ModelBuilderSchema schema();

    public ModelBuilder(P ignore) {
        super(Key.make("Failed"), "ModelBuilder constructor needs to be overridden.");
        throw H2O.fail("ModelBuilder subclass failed to override the params constructor: " + this.getClass());
    }

    public ModelBuilder(String desc, P parms) {
        this(parms == null || ((Model.Parameters)parms)._model_id == null ? Key.make(H2O.calcNextUniqueModelId(desc)) : ((Model.Parameters)parms)._model_id, desc, parms);
    }

    public ModelBuilder(Key dest, String desc, P parms) {
        super(dest, desc);
        this._parms = parms;
    }

    public static ModelBuilder createModelBuilder(String algo) {
        ModelBuilder modelBuilder;
        Class<ModelBuilder> clz = null;
        try {
            clz = ModelBuilder.getModelBuilder(algo);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if (clz == null) {
            throw new H2OIllegalArgumentException("algo", "createModelBuilder", "Algo not known (" + algo + ")");
        }
        try {
            if (!(clz.getGenericSuperclass() instanceof ParameterizedType)) {
                throw H2O.fail("Class is not parameterized as expected: " + clz);
            }
            Type[] handler_type_parms = ((ParameterizedType)clz.getGenericSuperclass()).getActualTypeArguments();
            Class pclz = (Class)handler_type_parms[1];
            Constructor<ModelBuilder> constructor = clz.getDeclaredConstructor((Class)handler_type_parms[1]);
            Model.Parameters p = (Model.Parameters)pclz.newInstance();
            modelBuilder = constructor.newInstance(p);
        }
        catch (InvocationTargetException e) {
            throw H2O.fail("Exception when trying to instantiate ModelBuilder for: " + algo + ": " + e.getCause(), e);
        }
        catch (Exception e) {
            throw H2O.fail("Exception when trying to instantiate ModelBuilder for: " + algo + ": " + e.getCause(), e);
        }
        return modelBuilder;
    }

    protected void updateModelOutput() {
        new TAtomic<M>(){

            @Override
            public M atomic(M old) {
                if (old != null) {
                    ((Model.Output)((Model)old)._output)._status = ModelBuilder.this._state;
                    ((Model.Output)((Model)old)._output)._start_time = ModelBuilder.this._start_time;
                    ((Model.Output)((Model)old)._output)._end_time = ModelBuilder.this._end_time;
                    ((Model.Output)((Model)old)._output)._run_time = ModelBuilder.this._end_time - ModelBuilder.this._start_time;
                }
                return old;
            }
        }.invoke(this.dest());
    }

    public final Job<M> trainModel() {
        int work;
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        if (!this.nFoldCV()) {
            return this.trainModelImpl(this.progressUnits(), true);
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            Vec fc = this.train().vec(((Model.Parameters)this._parms)._fold_column);
            work = (int)fc.max() - (int)fc.min() + 1;
        } else {
            work = ((Model.Parameters)this._parms)._nfolds + 1;
        }
        return this.start(new H2O.H2OCountedCompleter(){

            @Override
            protected void compute2() {
                ModelBuilder.this.computeCrossValidation();
                this.tryComplete();
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                ModelBuilder.this.failed(ex);
                return true;
            }
        }, (long)work * this.progressUnits(), true);
    }

    protected abstract Job<M> trainModelImpl(long var1, boolean var3);

    protected abstract long progressUnits();

    @Override
    protected boolean canBeDone() {
        return !this.nFoldCV();
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.cvModelBuilderKeys != null) {
            for (int i = 0; i < this.cvModelBuilderKeys.length; ++i) {
                ModelBuilder mb = (ModelBuilder)DKV.getGet(this.cvModelBuilderKeys[i]);
                if (mb == null) continue;
                assert (mb.cvModelBuilderKeys == null);
                mb.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job<M> computeCrossValidation() {
        Integer N;
        Vec foldAssignment;
        assert (this._state == Job.JobState.RUNNING);
        Frame origTrainFrame = this.train();
        if (((Model.Parameters)this._parms)._fold_column != null) {
            foldAssignment = origTrainFrame.vec(((Model.Parameters)this._parms)._fold_column);
            N = (int)foldAssignment.max() - (int)foldAssignment.min() + 1;
            assert (N > 1);
        } else {
            N = ((Model.Parameters)this._parms)._nfolds;
            long seed = new Random().nextLong();
            for (Field f : this._parms.getClass().getFields()) {
                if (!f.getName().equals("_seed")) continue;
                try {
                    seed = (Long)f.get(this._parms);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            Log.info("Creating " + N + " cross-validation splits with random number seed: " + seed);
            foldAssignment = origTrainFrame.anyVec().makeZero();
            Model.Parameters.FoldAssignmentScheme foldAssignmentScheme = ((Model.Parameters)this._parms)._fold_assignment;
            switch (foldAssignmentScheme) {
                case AUTO: 
                case Random: {
                    foldAssignment = ASTOp.kfoldColumn(foldAssignment, N, seed);
                    break;
                }
                case Modulo: {
                    foldAssignment = ASTOp.moduloKfoldColumn(foldAssignment, N);
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
        }
        Key[] modelKeys = new Key[N.intValue()];
        Key[] predictionKeys = new Key[N.intValue()];
        String origWeightsName = ((Model.Parameters)this._parms)._weights_column;
        Vec[] weights = new Vec[2 * N];
        Vec origWeight = origWeightsName != null ? origTrainFrame.vec(origWeightsName) : origTrainFrame.anyVec().makeCon(1.0);
        Frame[] cvTrain = new Frame[N.intValue()];
        Frame[] cvValid = new Frame[N.intValue()];
        String[] identifier = new String[N.intValue()];
        String weightName = "weights";
        Key origDest = this.dest();
        for (int i = 0; i < N; ++i) {
            weights[2 * i] = origTrainFrame.anyVec().makeZero();
            weights[2 * i + 1] = origTrainFrame.anyVec().makeZero();
            final int whichFold = i;
            new MRTask(){

                @Override
                public void map(Chunk[] chks) {
                    Chunk fold = chks[0];
                    Chunk orig = chks[1];
                    Chunk train = chks[2];
                    Chunk valid = chks[3];
                    for (int i = 0; i < orig._len; ++i) {
                        int foldAssignment = (int)fold.at8(i) % N;
                        assert (foldAssignment >= 0 && foldAssignment < N);
                        boolean holdout = foldAssignment == whichFold;
                        double w = orig.atd(i);
                        train.set(i, holdout ? 0.0 : w);
                        valid.set(i, holdout ? w : 0.0);
                    }
                }
            }.doAll(foldAssignment, origWeight, weights[2 * i], weights[2 * i + 1]);
            if (weights[2 * i].isConst() || weights[2 * i + 1].isConst()) {
                String msg = "Not enough data to create " + N + " random cross-validation splits. Either reduce nfolds, specify a larger dataset (or specify another random number seed, if applicable).";
                throw new H2OIllegalArgumentException(msg);
            }
            identifier[i] = origDest.toString() + "_cv_" + (i + 1);
            modelKeys[i] = Key.make(identifier[i]);
            cvTrain[i] = new Frame(Key.make(identifier[i] + "_" + ((Model.Parameters)this._parms)._train.toString() + "_train"), origTrainFrame.names(), origTrainFrame.vecs());
            cvTrain[i].add("weights", weights[2 * i]);
            DKV.put(cvTrain[i]);
            cvValid[i] = new Frame(Key.make(identifier[i] + "_" + ((Model.Parameters)this._parms)._train.toString() + "_valid"), origTrainFrame.names(), origTrainFrame.vecs());
            cvValid[i].add("weights", weights[2 * i + 1]);
            DKV.put(cvValid[i]);
        }
        if (((Model.Parameters)this._parms)._fold_column == null) {
            foldAssignment.remove();
        }
        if (origWeightsName == null) {
            origWeight.remove();
        }
        ModelMetrics.MetricBuilder[] mb = new ModelMetrics.MetricBuilder[N.intValue()];
        this._deleteProgressKey = false;
        long cs = ((Model.Parameters)this._parms).checksum();
        boolean async = false;
        this.cvModelBuilderKeys = new Key[N.intValue()];
        ModelBuilder[] cvModelBuilders = new ModelBuilder[N.intValue()];
        for (int i = 0; i < N && !this.isCancelledOrCrashed(); ++i) {
            Log.info("Building cross-validation model " + (i + 1) + " / " + N + ".");
            cvModelBuilders[i] = (ModelBuilder)this.clone();
            this.cvModelBuilderKeys[i] = Key.make(this._key.toString() + "_cv" + i);
            cvModelBuilders[i]._key = this.cvModelBuilderKeys[i];
            cvModelBuilders[i].cvModelBuilderKeys = null;
            cvModelBuilders[i]._dest = modelKeys[i];
            cvModelBuilders[i]._state = Job.JobState.CREATED;
            cvModelBuilders[i]._parms = (Model.Parameters)((Iced)this._parms).clone();
            ((Model.Parameters)cvModelBuilders[i]._parms)._weights_column = "weights";
            ((Model.Parameters)cvModelBuilders[i]._parms)._train = cvTrain[i]._key;
            ((Model.Parameters)cvModelBuilders[i]._parms)._valid = cvValid[i]._key;
            ((Model.Parameters)cvModelBuilders[i]._parms)._fold_assignment = Model.Parameters.FoldAssignmentScheme.AUTO;
            cvModelBuilders[i].modifyParmsForCrossValidationSplits(i, N, ((Model.Parameters)this._parms)._model_id);
            cvModelBuilders[i]._start_time = System.currentTimeMillis();
            cvModelBuilders[i].trainModelImpl(-1L, true);
            cvModelBuilders[i].block();
        }
        assert (cs == ((Model.Parameters)this._parms).checksum());
        if (!this.isCancelledOrCrashed()) {
            Log.info("Building main model.");
            assert (DKV.get(this._key).get() == this);
            assert (this._state == Job.JobState.RUNNING);
            assert (((Job)DKV.getGet((Key)this._key))._state == Job.JobState.RUNNING);
            this._state = Job.JobState.CREATED;
            assert (((Job)DKV.getGet((Key)this._key))._state == Job.JobState.CREATED);
            assert (!this._deleteProgressKey);
            this._deleteProgressKey = true;
            this.modifyParmsForCrossValidationMainModel(N);
            this.trainModelImpl(-1L, false);
            this.block();
        } else {
            DKV.remove(this.dest());
        }
        Model[] m = new Model[N.intValue()];
        for (int i = 0; i < N; ++i) {
            Frame adaptFr = null;
            try {
                adaptFr = new Frame(cvValid[i]);
                if (this.isCancelledOrCrashed()) continue;
                cvModelBuilders[i].block();
                cvModelBuilders[i].done(true);
                cvModelBuilders[i].updateModelOutput();
                m[i] = (Model)DKV.getGet(cvModelBuilders[i].dest());
                m[i].adaptTestForTrain(adaptFr, true, !this.isSupervised());
                mb[i] = m[i].scoreMetrics(adaptFr);
                if (!((Model.Parameters)this._parms)._keep_cross_validation_predictions) continue;
                String predName = "prediction_" + modelKeys[i].toString();
                predictionKeys[i] = Key.make(predName);
                m[i].predictScoreImpl(cvValid[i], adaptFr, predName);
                continue;
            }
            finally {
                if (adaptFr != null) {
                    Model.cleanup_adapt(adaptFr, cvValid[i]);
                    DKV.remove(adaptFr._key);
                }
                if (cvTrain[i] != null) {
                    DKV.remove(cvTrain[i]._key);
                }
                if (cvValid[i] != null) {
                    DKV.remove(cvValid[i]._key);
                }
                if (weights[2 * i] != null) {
                    weights[2 * i].remove();
                }
                if (weights[2 * i + 1] != null) {
                    weights[2 * i + 1].remove();
                }
                if (cvModelBuilders[i] != null) {
                    cvModelBuilders[i].remove();
                }
            }
        }
        if (!this.isCancelledOrCrashed()) {
            this.block();
            Model mainModel = (Model)DKV.getGet(this.dest());
            assert (this._state == Job.JobState.RUNNING);
            Log.info("Computing " + N + "-fold cross-validation metrics.");
            ((Model.Output)mainModel._output)._cross_validation_models = new Key[N.intValue()];
            ((Model.Output)mainModel._output)._cross_validation_predictions = ((Model.Parameters)this._parms)._keep_cross_validation_predictions ? new Key[N.intValue()] : null;
            for (int i = 0; i < N; ++i) {
                if (i > 0) {
                    mb[0].reduce(mb[i]);
                }
                ((Model.Output)mainModel._output)._cross_validation_models[i] = modelKeys[i];
                if (!((Model.Parameters)this._parms)._keep_cross_validation_predictions) continue;
                ((Model.Output)mainModel._output)._cross_validation_predictions[i] = predictionKeys[i];
            }
            ((Model.Output)mainModel._output)._cross_validation_metrics = mb[0].makeModelMetrics(mainModel, ((Model.Parameters)this._parms).train());
            ((Model.Output)mainModel._output)._cross_validation_metrics._description = N + "-fold cross-validation on training data";
            Log.info(((Model.Output)mainModel._output)._cross_validation_metrics.toString());
            DKV.put(mainModel);
            assert (!this.isDone());
            this.done(true);
            this.updateModelOutput();
        }
        return this;
    }

    public void modifyParmsForCrossValidationSplits(int i, int N, Key<Model> model_id) {
        ((Model.Parameters)this._parms)._nfolds = 0;
        if (model_id != null) {
            ((Model.Parameters)this._parms)._model_id = Key.make(model_id.toString());
        }
    }

    public void modifyParmsForCrossValidationMainModel(int N) {
    }

    @Override
    protected boolean deleteProgressKey() {
        return this._deleteProgressKey;
    }

    public boolean nFoldCV() {
        return ((Model.Parameters)this._parms)._fold_column != null || ((Model.Parameters)this._parms)._nfolds != 0;
    }

    public abstract ModelCategory[] can_build();

    public abstract BuilderVisibility builderVisibility();

    public void clearInitState() {
        this.clearValidationErrors();
    }

    public boolean isSupervised() {
        return false;
    }

    public boolean hasOffsetCol() {
        return ((Model.Parameters)this._parms)._offset_column != null;
    }

    public boolean hasWeightCol() {
        return ((Model.Parameters)this._parms)._weights_column != null;
    }

    public boolean hasFoldCol() {
        return ((Model.Parameters)this._parms)._fold_column != null;
    }

    public int numSpecialCols() {
        return (this.hasOffsetCol() ? 1 : 0) + (this.hasWeightCol() ? 1 : 0) + (this.hasFoldCol() ? 1 : 0);
    }

    public int nclasses() {
        return this._nclass;
    }

    public final boolean isClassifier() {
        return this._nclass > 1;
    }

    protected int separateFeatureVecs() {
        int res = 0;
        if (((Model.Parameters)this._parms)._weights_column != null) {
            Vec w = this._train.remove(((Model.Parameters)this._parms)._weights_column);
            if (w == null) {
                this.error("_weights_column", "Weights column '" + ((Model.Parameters)this._parms)._weights_column + "' not found in the training frame");
            } else {
                if (!w.isNumeric()) {
                    this.error("_weights_column", "Invalid weights column '" + ((Model.Parameters)this._parms)._weights_column + "', weights must be numeric");
                }
                this._weights = w;
                if (w.naCnt() > 0L) {
                    this.error("_weights_columns", "Weights cannot have missing values.");
                }
                if (w.min() < 0.0) {
                    this.error("_weights_columns", "Weights must be >= 0");
                }
                if (w.max() == 0.0) {
                    this.error("_weights_columns", "Max. weight must be > 0");
                }
                this._train.add(((Model.Parameters)this._parms)._weights_column, w);
                ++res;
            }
        } else {
            this._weights = null;
            assert (!this.hasWeightCol());
        }
        if (((Model.Parameters)this._parms)._offset_column != null) {
            Vec o = this._train.remove(((Model.Parameters)this._parms)._offset_column);
            if (o == null) {
                this.error("_offset_column", "Offset column '" + ((Model.Parameters)this._parms)._offset_column + "' not found in the training frame");
            } else {
                if (!o.isNumeric()) {
                    this.error("_offset_column", "Invalid offset column '" + ((Model.Parameters)this._parms)._offset_column + "', offset must be numeric");
                }
                this._offset = o;
                if (o.naCnt() > 0L) {
                    this.error("_offset_column", "Offset cannot have missing values.");
                }
                if (this._weights == this._offset) {
                    this.error("_offset_column", "Offset must be different from weights");
                }
                this._train.add(((Model.Parameters)this._parms)._offset_column, o);
                ++res;
            }
        } else {
            this._offset = null;
            assert (!this.hasOffsetCol());
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            Vec f = this._train.remove(((Model.Parameters)this._parms)._fold_column);
            if (f == null) {
                this.error("_fold_column", "Fold column '" + ((Model.Parameters)this._parms)._fold_column + "' not found in the training frame");
            } else {
                if (!f.isInt()) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold must be integer");
                }
                if (f.min() < 0.0) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold must be non-negative");
                }
                if (f.isConst()) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold cannot be constant");
                }
                this._fold = f;
                if (f.naCnt() > 0L) {
                    this.error("_fold_column", "Fold cannot have missing values.");
                }
                if (this._fold == this._weights) {
                    this.error("_fold_column", "Fold must be different from weights");
                }
                if (this._fold == this._offset) {
                    this.error("_fold_column", "Fold must be different from offset");
                }
                this._train.add(((Model.Parameters)this._parms)._fold_column, f);
                ++res;
            }
        } else {
            this._fold = null;
            assert (!this.hasFoldCol());
        }
        if (this.isSupervised() && ((Model.Parameters)this._parms)._response_column != null) {
            this._response = this._train.remove(((Model.Parameters)this._parms)._response_column);
            if (this._response == null) {
                if (this.isSupervised()) {
                    this.error("_response_column", "Response column '" + ((Model.Parameters)this._parms)._response_column + "' not found in the training frame");
                }
            } else {
                if (this._response == this._offset) {
                    this.error("_response", "Response must be different from offset_column");
                }
                if (this._response == this._weights) {
                    this.error("_response", "Response must be different from weights_column");
                }
                if (this._response == this._fold) {
                    this.error("_response", "Response must be different from fold_column");
                }
                this._train.add(((Model.Parameters)this._parms)._response_column, this._response);
                ++res;
            }
        } else {
            this._response = null;
        }
        return res;
    }

    protected boolean ignoreStringColumns() {
        return true;
    }

    protected void ignoreBadColumns(int npredictors, boolean expensive) {
        if (((Model.Parameters)this._parms)._ignore_const_cols) {
            new FilterCols(npredictors){

                @Override
                protected boolean filter(Vec v) {
                    return v.isConst() || v.isBad() || ModelBuilder.this.ignoreStringColumns() && v.isString();
                }
            }.doIt(this._train, "Dropping constant columns: ", expensive);
        }
    }

    protected void checkMemoryFootPrint() {
    }

    protected boolean computePriorClassDistribution() {
        return this.isClassifier();
    }

    @Override
    public int error_count() {
        assert (this.error_count_or_uninitialized() >= 0) : "init() not run yet";
        return super.error_count();
    }

    public void init(boolean expensive) {
        Frame va;
        if (expensive) {
            Log.info("Building H2O " + this.getClass().getSimpleName().toString() + " model with these parameters:");
            Log.info(new String(((Iced)this._parms).writeJSON(new AutoBuffer()).buf()));
        }
        this.clearInitState();
        assert (this._parms != null);
        if (((Model.Parameters)this._parms)._train == null) {
            if (expensive) {
                this.error("_train", "Missing training frame");
            }
            return;
        }
        Frame tr = ((Model.Parameters)this._parms).train();
        if (tr == null) {
            this.error("_train", "Missing training frame: " + ((Model.Parameters)this._parms)._train);
            return;
        }
        this._train = new Frame(null, (String[])tr._names.clone(), (Vec[])tr.vecs().clone());
        if (((Model.Parameters)this._parms)._nfolds < 0 || ((Model.Parameters)this._parms)._nfolds == 1) {
            this.error("_nfolds", "nfolds must be either 0 or >1.");
        }
        if (((Model.Parameters)this._parms)._nfolds > 1 && (long)((Model.Parameters)this._parms)._nfolds > this.train().numRows()) {
            this.error("_nfolds", "nfolds cannot be larger than the number of rows (" + this.train().numRows() + ").");
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            this.hide("_fold_assignment", "Fold assignment is ignored when a fold column is specified.");
            if (((Model.Parameters)this._parms)._nfolds > 1) {
                this.error("_nfolds", "nfolds cannot be specified at the same time as a fold column.");
            } else {
                this.hide("_nfolds", "nfolds is ignored when a fold column is specified.");
            }
            if (((Model.Parameters)this._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO) {
                this.error("_fold_assignment", "Fold assignment is not allowed in conjunction with a fold column.");
            }
        }
        if (((Model.Parameters)this._parms)._nfolds > 1) {
            this.hide("_fold_column", "Fold column is ignored when nfolds > 1.");
        }
        if (!this.nFoldCV()) {
            this.hide("_keep_cross_validation_predictions", "Only for cross-validation.");
            this.hide("_fold_assignment", "Only for cross-validation.");
            if (((Model.Parameters)this._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO) {
                this.error("_fold_assignment", "Fold assignment is only allowed for cross-validation.");
            }
        }
        if (((Model.Parameters)this._parms)._distribution != Distribution.Family.tweedie) {
            this.hide("_tweedie_power", "Only for Tweedie Distribution.");
        }
        if (((Model.Parameters)this._parms)._tweedie_power <= 1.0 || ((Model.Parameters)this._parms)._tweedie_power >= 2.0) {
            this.error("_tweedie_power", "Tweedie power must be between 1 and 2 (exclusive).");
        }
        if (expensive) {
            this.checkDistributions();
        }
        if (((Model.Parameters)this._parms)._ignored_columns != null) {
            this._train.remove(((Model.Parameters)this._parms)._ignored_columns);
            if (expensive) {
                Log.info("Dropping ignored columns: " + Arrays.toString(((Model.Parameters)this._parms)._ignored_columns));
            }
        }
        this.ignoreBadColumns(this.separateFeatureVecs(), expensive);
        if (this._train.numCols() == 0) {
            this.error("_train", "There are no usable columns to generate model");
        }
        if (this.isSupervised()) {
            if (this._response != null) {
                int n = this._nclass = this._response.isEnum() ? this._response.cardinality() : 1;
                if (this._response.isConst()) {
                    this.error("_response", "Response cannot be constant.");
                }
            }
            if (!((Model.Parameters)this._parms)._balance_classes) {
                this.hide("_max_after_balance_size", "Balance classes is false, hide max_after_balance_size");
            } else if (((Model.Parameters)this._parms)._weights_column != null && this._weights != null && !this._weights.isBinary()) {
                this.error("_balance_classes", "Balance classes and observation weights are not currently supported together.");
            }
            if ((double)((Model.Parameters)this._parms)._max_after_balance_size <= 0.0) {
                this.error("_max_after_balance_size", "Max size after balancing needs to be positive, suggest 1.0f");
            }
            if (this._train != null) {
                if (this._train.numCols() <= 1) {
                    this.error("_train", "Training data must have at least 2 features (incl. response).");
                }
                if (null == ((Model.Parameters)this._parms)._response_column) {
                    this.error("_response_column", "Response column parameter not set.");
                    return;
                }
                if (this._response != null && this.computePriorClassDistribution()) {
                    if (this.isClassifier() && this.isSupervised()) {
                        MRUtils.ClassDist cdmt = this._weights != null ? (MRUtils.ClassDist)new MRUtils.ClassDist(this.nclasses()).doAll(this._response, this._weights) : (MRUtils.ClassDist)new MRUtils.ClassDist(this.nclasses()).doAll(this._response);
                        this._distribution = cdmt.dist();
                        this._priorClassDist = cdmt.rel_dist();
                    } else {
                        this._distribution = new double[]{(this._weights != null ? this._weights.mean() : 1.0) * (double)this.train().numRows()};
                        this._priorClassDist = new double[]{1.0};
                    }
                }
            }
            if (!this.isClassifier()) {
                this.hide("_balance_classes", "Balance classes is only applicable to classification problems.");
                this.hide("_class_sampling_factors", "Class sampling factors is only applicable to classification problems.");
                this.hide("_max_after_balance_size", "Max after balance size is only applicable to classification problems.");
                this.hide("_max_confusion_matrix_size", "Max confusion matrix size is only applicable to classification problems.");
            }
            if (this._nclass <= 2) {
                this.hide("_max_hit_ratio_k", "Max K-value for hit ratio is only applicable to multi-class classification problems.");
                this.hide("_max_confusion_matrix_size", "Only for multi-class classification problems.");
            }
            if (!((Model.Parameters)this._parms)._balance_classes) {
                this.hide("_max_after_balance_size", "Only used with balanced classes");
                this.hide("_class_sampling_factors", "Class sampling factors is only applicable if balancing classes.");
            }
        } else {
            this.hide("_response_column", "Ignored for unsupervised methods.");
            this.hide("_balance_classes", "Ignored for unsupervised methods.");
            this.hide("_class_sampling_factors", "Ignored for unsupervised methods.");
            this.hide("_max_after_balance_size", "Ignored for unsupervised methods.");
            this.hide("_max_confusion_matrix_size", "Ignored for unsupervised methods.");
            this._response = null;
            this._vresponse = null;
            this._nclass = 1;
        }
        if (this._nclass > 1000) {
            this.error("_nclass", "Too many levels in response column: " + this._nclass + ", maximum supported number of classes is " + 1000 + ".");
        }
        if ((va = ((Model.Parameters)this._parms).valid()) != null) {
            this._valid = new Frame(null, (String[])va._names.clone(), (Vec[])va.vecs().clone());
            try {
                String[] msgs = Model.adaptTestForTrain(this._train._names, ((Model.Parameters)this._parms)._weights_column, ((Model.Parameters)this._parms)._offset_column, ((Model.Parameters)this._parms)._fold_column, null, this._train.domains(), this._valid, ((Model.Parameters)this._parms).missingColumnsType(), expensive, true);
                this._vresponse = this._valid.vec(((Model.Parameters)this._parms)._response_column);
                if (this._vresponse == null && ((Model.Parameters)this._parms)._response_column != null) {
                    this.error("_validation_frame", "Validation frame must have a response column '" + ((Model.Parameters)this._parms)._response_column + "'.");
                }
                if (expensive) {
                    for (String s : msgs) {
                        Log.info(s);
                        this.warn("_valid", s);
                    }
                }
                assert (!expensive || this._valid == null || Arrays.equals(this._train._names, this._valid._names));
            }
            catch (IllegalArgumentException iae) {
                this.error("_valid", iae.getMessage());
            }
        } else {
            this._valid = null;
            this._vresponse = null;
        }
        if (((Model.Parameters)this._parms)._checkpoint != null && DKV.get(((Model.Parameters)this._parms)._checkpoint) == null) {
            this.error("_checkpoint", "Checkpoint has to point to existing model!");
        }
        assert (this._weights != null == this.hasWeightCol());
        assert (((Model.Parameters)this._parms)._weights_column != null == this.hasWeightCol());
        assert (this._offset != null == this.hasOffsetCol());
        assert (((Model.Parameters)this._parms)._offset_column != null == this.hasOffsetCol());
        assert (this._fold != null == this.hasFoldCol());
        assert (((Model.Parameters)this._parms)._fold_column != null == this.hasFoldCol());
    }

    public void checkDistributions() {
        if (((Model.Parameters)this._parms)._distribution == Distribution.Family.poisson) {
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Poisson distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == Distribution.Family.gamma) {
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Gamma distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == Distribution.Family.tweedie) {
            if (((Model.Parameters)this._parms)._tweedie_power >= 2.0 || ((Model.Parameters)this._parms)._tweedie_power <= 1.0) {
                this.error("_tweedie_power", "Tweedie power must be between 1 and 2.");
            }
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Tweedie distribution.");
            }
        }
    }

    abstract class FilterCols {
        final int _specialVecs;

        public FilterCols(int n) {
            this._specialVecs = n;
        }

        protected abstract boolean filter(Vec var1);

        void doIt(Frame f, String msg, boolean expensive) {
            boolean any = false;
            for (int i = 0; i < f.vecs().length - this._specialVecs; ++i) {
                if (!this.filter(f.vecs()[i])) continue;
                if (any) {
                    msg = msg + ", ";
                }
                any = true;
                msg = msg + f._names[i];
                f.remove(i);
                --i;
            }
            if (any) {
                ModelBuilder.this.warn("_train", msg);
                if (expensive) {
                    Log.info(msg);
                }
            }
        }
    }

    public static enum BuilderVisibility {
        Experimental,
        Beta,
        Stable;

    }
}

