/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUC2;
import hex.ConfusionMatrix;
import hex.Model;
import hex.ModelCategory;
import hex.VarImp;
import java.util.Arrays;
import java.util.Comparator;
import water.DKV;
import water.Iced;
import water.Key;
import water.Keyed;
import water.Value;
import water.fvec.Frame;
import water.util.TwoDimTable;

public class ModelMetrics
extends Keyed<ModelMetrics> {
    public String _description;
    final Key _modelKey;
    final Key _frameKey;
    final ModelCategory _model_category;
    final long _model_checksum;
    final long _frame_checksum;
    public final long _scoring_time;
    private transient Model _model;
    private transient Frame _frame;
    public final double _MSE;

    public ModelMetrics(Model model, Frame frame, double MSE, String desc) {
        super(ModelMetrics.buildKey(model, frame));
        this._description = desc;
        this._modelKey = model._key;
        this._frameKey = frame._key;
        this._model_category = ((Model.Output)model._output).getModelCategory();
        this._model_checksum = model.checksum();
        this._frame_checksum = frame.checksum();
        this._MSE = MSE;
        this._scoring_time = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Model Metrics Type: " + this.getClass().getSimpleName().substring(12) + "\n");
        sb.append(" Description: " + (this._description == null ? "N/A" : this._description) + "\n");
        sb.append(" model id: " + this._modelKey + "\n");
        sb.append(" frame id: " + this._frameKey + "\n");
        sb.append(" MSE: " + (float)this._MSE + "\n");
        return sb.toString();
    }

    public Model model() {
        return this._model == null ? (this._model = (Model)DKV.getGet(this._modelKey)) : this._model;
    }

    public Frame frame() {
        return this._frame == null ? (this._frame = (Frame)DKV.getGet(this._frameKey)) : this._frame;
    }

    public double mse() {
        return this._MSE;
    }

    public ConfusionMatrix cm() {
        return null;
    }

    public float[] hr() {
        return null;
    }

    public AUC2 auc() {
        return null;
    }

    public static TwoDimTable calcVarImp(VarImp vi) {
        if (vi == null) {
            return null;
        }
        double[] dbl_rel_imp = new double[vi._varimp.length];
        for (int i = 0; i < dbl_rel_imp.length; ++i) {
            dbl_rel_imp[i] = vi._varimp[i];
        }
        return ModelMetrics.calcVarImp(dbl_rel_imp, vi._names);
    }

    public static TwoDimTable calcVarImp(float[] rel_imp, String[] coef_names) {
        double[] dbl_rel_imp = new double[rel_imp.length];
        for (int i = 0; i < dbl_rel_imp.length; ++i) {
            dbl_rel_imp[i] = rel_imp[i];
        }
        return ModelMetrics.calcVarImp(dbl_rel_imp, coef_names);
    }

    public static TwoDimTable calcVarImp(double[] rel_imp, String[] coef_names) {
        return ModelMetrics.calcVarImp(rel_imp, coef_names, "Variable Importances", new String[]{"Relative Importance", "Scaled Importance", "Percentage"});
    }

    public static TwoDimTable calcVarImp(final double[] rel_imp, String[] coef_names, String table_header, String[] col_headers) {
        int i;
        int i$;
        if (rel_imp == null) {
            return null;
        }
        if (coef_names == null) {
            coef_names = new String[rel_imp.length];
            for (int i2 = 0; i2 < coef_names.length; ++i2) {
                coef_names[i2] = "C" + String.valueOf(i2 + 1);
            }
        }
        Integer[] sorted_idx = new Integer[rel_imp.length];
        for (int i3 = 0; i3 < sorted_idx.length; ++i3) {
            sorted_idx[i3] = i3;
        }
        Arrays.sort(sorted_idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer idx1, Integer idx2) {
                return Double.compare(-rel_imp[idx1], -rel_imp[idx2]);
            }
        });
        double total = 0.0;
        double max = rel_imp[sorted_idx[0]];
        String[] sorted_names = new String[rel_imp.length];
        double[][] sorted_imp = new double[rel_imp.length][3];
        int j = 0;
        Integer[] arr$ = sorted_idx;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            total += rel_imp[i];
            sorted_names[j] = coef_names[i];
            sorted_imp[j][0] = rel_imp[i];
            sorted_imp[j++][1] = rel_imp[i] / max;
        }
        j = 0;
        arr$ = sorted_idx;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            i = arr$[i$];
            sorted_imp[j++][2] = rel_imp[i] / total;
        }
        Object[] col_types = new String[3];
        Object[] col_formats = new String[3];
        Arrays.fill(col_types, "double");
        Arrays.fill(col_formats, "%5f");
        return new TwoDimTable(table_header, null, sorted_names, col_headers, (String[])col_types, (String[])col_formats, "Variable", new String[rel_imp.length][], sorted_imp);
    }

    private static Key<ModelMetrics> buildKey(Key model_key, long model_checksum, Key frame_key, long frame_checksum) {
        return Key.make("modelmetrics_" + model_key + "@" + model_checksum + "_on_" + frame_key + "@" + frame_checksum);
    }

    public static Key<ModelMetrics> buildKey(Model model, Frame frame) {
        return frame == null ? null : ModelMetrics.buildKey(model._key, model.checksum(), frame._key, frame.checksum());
    }

    public boolean isForModel(Model m) {
        return this._model_checksum == m.checksum();
    }

    public boolean isForFrame(Frame f) {
        return this._frame_checksum == f.checksum();
    }

    public static ModelMetrics getFromDKV(Model model, Frame frame) {
        Value v = DKV.get(ModelMetrics.buildKey(model, frame));
        return null == v ? null : (ModelMetrics)v.get();
    }

    @Override
    protected long checksum_impl() {
        return this._frame_checksum * 13L + this._model_checksum * 17L;
    }

    public static abstract class MetricBuilder<T extends MetricBuilder<T>>
    extends Iced {
        public transient double[] _work;
        public double _sumsqe;
        public long _count;
        public double _wcount;
        public double _wY;
        public double _wYY;

        public double weightedSigma() {
            double sampleCorrection = 1.0;
            return this._count <= 1L ? 0.0 : Math.sqrt(sampleCorrection * (this._wYY / this._wcount - this._wY * this._wY / (this._wcount * this._wcount)));
        }

        public abstract double[] perRow(double[] var1, float[] var2, Model var3);

        public double[] perRow(double[] ds, float[] yact, double weight, double offset, Model m) {
            assert (weight == 1.0 && offset == 0.0);
            return this.perRow(ds, yact, m);
        }

        public void reduce(T mb) {
            this._sumsqe += ((MetricBuilder)mb)._sumsqe;
            this._count += ((MetricBuilder)mb)._count;
            this._wcount += ((MetricBuilder)mb)._wcount;
            this._wY += ((MetricBuilder)mb)._wY;
            this._wYY += ((MetricBuilder)mb)._wYY;
        }

        public void postGlobal() {
        }

        public abstract ModelMetrics makeModelMetrics(Model var1, Frame var2);
    }
}

