/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.FrameSplitter;
import hex.Transformer;
import jsr166y.CountedCompleter;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.util.ArrayUtils;
import water.util.FrameUtils;

public class SplitFrame
extends Transformer<SplitFrame> {
    public Frame dataset;
    public double[] ratios;
    public Key<Frame>[] destination_frames;

    public SplitFrame() {
        this(Key.make());
    }

    public SplitFrame(Key<SplitFrame> dest) {
        this(dest, "SplitFrame job");
    }

    public SplitFrame(Key<SplitFrame> dest, String desc) {
        super(dest, desc);
    }

    @Override
    public SplitFrame execImpl() {
        double[] computedRatios;
        if (this.ratios.length < 0) {
            throw new IllegalArgumentException("No ratio specified!");
        }
        if (this.ratios.length > 100) {
            throw new IllegalArgumentException("Too many frame splits demanded!");
        }
        for (double r : this.ratios) {
            if (!(r <= 0.0)) continue;
            new IllegalArgumentException("Ratio must be > 0!");
        }
        if (this.ratios.length == 1 && (this.ratios[0] < 0.0 || this.ratios[0] > 1.0)) {
            throw new IllegalArgumentException("Ratio must be between 0 and 1!");
        }
        if (this.destination_frames != null && (this.ratios.length != 1 || this.destination_frames.length != 2) && this.ratios.length != this.destination_frames.length) {
            throw new IllegalArgumentException("Number of destination keys has to match to a number of split ratios!");
        }
        if (this.ratios.length > 1) {
            double sum = ArrayUtils.sum(this.ratios);
            if (sum <= 0.0) {
                throw new IllegalArgumentException("Ratios sum has to be > 0!");
            }
            if (sum < 1.0) {
                computedRatios = this.ratios;
            } else {
                computedRatios = new double[this.ratios.length - 1];
                for (int i = 0; i < this.ratios.length - 1; ++i) {
                    computedRatios[i] = this.ratios[i] / sum;
                }
            }
        } else {
            computedRatios = this.ratios;
        }
        if (this.destination_frames == null) {
            this.destination_frames = FrameUtils.generateNumKeys(this.dataset._key, computedRatios.length + 1);
        }
        H2O.H2OCountedCompleter hcc = new H2O.H2OCountedCompleter(){

            @Override
            protected void compute2() {
                FrameSplitter fs = new FrameSplitter(this, SplitFrame.this.dataset, computedRatios, SplitFrame.this.destination_frames, SplitFrame.this._key);
                H2O.submitTask(fs);
            }

            @Override
            public void onCompletion(CountedCompleter caller) {
                FrameSplitter fs = (FrameSplitter)caller;
                Job j = (Job)DKV.getGet(SplitFrame.this._key);
                if (fs.getErrors() != null) {
                    j.failed(fs.getErrors()[0]);
                } else {
                    j.done();
                }
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                ((Job)DKV.getGet(SplitFrame.this._key)).failed(ex);
                return false;
            }
        };
        return (SplitFrame)this.start(hcc, computedRatios.length + 1, true);
    }
}

