/*
 * Decompiled with CFR 0.152.
 */
package water;

import jsr166y.CountedCompleter;
import water.AutoBuffer;
import water.H2O;
import water.RPC;
import water.UDP;
import water.util.Log;

class FJPacket
extends H2O.H2OCountedCompleter {
    final AutoBuffer _ab;
    final int _ctrl;

    FJPacket(AutoBuffer ab, int ctrl) {
        this._ab = ab;
        this._ctrl = ctrl;
        assert (0 < this._ctrl && this._ctrl < UDP.udp.UDPS.length);
        assert (UDP.udp.UDPS[this._ctrl]._udp != null) : "missing udp " + this._ctrl;
    }

    @Override
    protected void compute2() {
        this._ab.getPort();
        if (this._ctrl <= UDP.udp.nack.ordinal()) {
            AutoBuffer ab = UDP.udp.UDPS[this._ctrl]._udp.call(this._ab);
            if (ab != null && !ab.isClosed()) {
                ab.close();
            }
        } else {
            RPC.remote_exec(this._ab);
        }
        this.tryComplete();
    }

    @Override
    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
        System.err.println("onExCompletion for " + this);
        ex.printStackTrace();
        Log.err(ex);
        return true;
    }

    @Override
    protected byte priority() {
        return UDP.udp.UDPS[this._ctrl]._prior;
    }
}

