/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Key;
import water.Keyed;
import water.TAtomic;
import water.Value;
import water.util.Log;

public abstract class Lockable<T extends Lockable<T>>
extends Keyed<T> {
    public transient Key[] _lockers;

    public Lockable(Key key) {
        super(key);
    }

    public Lockable write_lock(Key job_key) {
        Log.debug("write-lock " + this._key + " by job " + job_key);
        return ((PriorWriteLock)new PriorWriteLock(job_key).invoke(this._key))._old;
    }

    public T delete_and_lock(Key job_key) {
        Lockable old = this.write_lock(job_key);
        if (old != null) {
            Log.debug("lock-then-clear " + this._key + " by job " + job_key);
            old.remove_impl(new Futures()).blockForPending();
        }
        return (T)this;
    }

    public static void delete(Key key) {
        Value val = DKV.get(key);
        if (val == null) {
            return;
        }
        ((Lockable)val.get()).delete();
    }

    public void delete() {
        this.delete(null, new Futures()).blockForPending();
    }

    public Futures delete(Key job_key, Futures fs) {
        if (this._key != null) {
            Log.debug("lock-then-delete " + this._key + " by job " + job_key);
            new PriorWriteLock(job_key).invoke(this._key);
        }
        return this.remove(fs);
    }

    public static void read_lock(Key k, Key job_key) {
        Value val = DKV.get(k);
        if (val.isLockable()) {
            ((Lockable)val.get()).read_lock(job_key);
        }
    }

    public void read_lock(Key job_key) {
        if (this._key != null) {
            Log.debug("shared-read-lock " + this._key + " by job " + job_key);
            new ReadLock(job_key).invoke(this._key);
        }
    }

    public T update(Key job_key) {
        Log.debug("update write-locked " + this._key + " by job " + job_key);
        new Update(job_key).invoke(this._key);
        return (T)this;
    }

    public void unlock(Key job_key) {
        if (this._key != null) {
            Log.debug("unlock " + this._key + " by job " + job_key);
            new Unlock(job_key).invoke(this._key);
        }
    }

    private boolean is_locked(Key job_key) {
        int i;
        if (this._lockers == null) {
            return false;
        }
        int n = i = this._lockers.length == 1 ? 0 : 1;
        while (i < this._lockers.length) {
            Key k = this._lockers[i];
            if (job_key == k || job_key != null && k != null && job_key.equals(k)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean is_wlocked() {
        return this._lockers != null && this._lockers.length == 1;
    }

    private boolean is_wlocked(Key job_key) {
        return this.is_wlocked() && (this._lockers[0] == job_key || this._lockers[0] != null && this._lockers[0].equals(job_key));
    }

    private boolean is_unlocked() {
        return this._lockers == null;
    }

    private void set_write_lock(Key job_key) {
        this._lockers = new Key[]{job_key};
        assert (this.is_locked(job_key));
    }

    private void set_read_lock(Key job_key) {
        assert (!this.is_locked(job_key));
        assert (!this.is_wlocked());
        this._lockers = this._lockers == null ? new Key[2] : Arrays.copyOf(this._lockers, this._lockers.length + 1);
        this._lockers[this._lockers.length - 1] = job_key;
        assert (this.is_locked(job_key));
    }

    private void set_unlocked(Key[] lks, Key job_key) {
        if (lks.length == 1) {
            assert (job_key == lks[0] || job_key.equals(lks[0]));
            this._lockers = null;
        } else if (lks.length == 2) {
            assert (lks[0] == null);
            assert (lks[1] == job_key || job_key != null && job_key.equals(lks[1]));
            this._lockers = null;
        } else {
            assert (lks.length > 2);
            this._lockers = Arrays.copyOf(lks, lks.length - 1);
            int j = 1;
            for (int i = 1; i < lks.length; ++i) {
                if ((job_key == null || job_key.equals(lks[i])) && (job_key != null || lks[i] == null)) continue;
                this._lockers[j++] = lks[i];
            }
            assert (j == lks.length - 1);
        }
        assert (!this.is_locked(job_key));
    }

    public void unlock_all() {
        if (this._key != null) {
            for (Key k : this._lockers) {
                new UnlockSafe(k).invoke(this._key);
            }
        }
    }

    private class UnlockSafe
    extends TAtomic<Lockable> {
        final Key _job_key;

        UnlockSafe(Key job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            if (old.is_locked(this._job_key)) {
                Lockable.this.set_unlocked(old._lockers, this._job_key);
            }
            return Lockable.this;
        }
    }

    private class Unlock
    extends TAtomic<Lockable> {
        final Key _job_key;

        Unlock(Key job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            assert (old != null) : "Trying to unlock null!";
            assert (old.is_locked(this._job_key)) : "Can't unlock: Not locked!";
            Lockable.this.set_unlocked(old._lockers, this._job_key);
            return Lockable.this;
        }
    }

    private class Update
    extends TAtomic<Lockable> {
        final Key _job_key;

        Update(Key job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            assert (old != null) : "Cannot update - Lockable is null!";
            assert (old.is_wlocked()) : "Cannot update - Lockable is not write-locked!";
            Lockable.this._lockers = old._lockers;
            return Lockable.this;
        }
    }

    private static class ReadLock
    extends TAtomic<Lockable> {
        final Key _job_key;

        ReadLock(Key job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            if (old == null) {
                throw new IllegalArgumentException("Nothing to lock!");
            }
            if (old.is_wlocked()) {
                throw new IllegalArgumentException(old.getClass() + " " + this._key + " is being created;  Unable to read it now.");
            }
            old.set_read_lock(this._job_key);
            return old;
        }
    }

    private class PriorWriteLock
    extends TAtomic<Lockable> {
        private final Key _job_key;
        private Lockable _old;

        private PriorWriteLock(Key job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            this._old = old;
            if (old != null) {
                assert (!old.is_wlocked(this._job_key)) : "Key " + this._key + " already locked; lks=" + Arrays.toString(old._lockers);
                if (old.is_locked(this._job_key)) {
                    old.set_unlocked(old._lockers, this._job_key);
                }
                if (!old.is_unlocked()) {
                    throw new IllegalArgumentException(old.getClass() + " " + this._key + " is already in use.  Unable to use it now.  Consider using a different destination name.");
                }
            }
            Lockable.this.set_write_lock(this._job_key);
            return Lockable.this;
        }
    }
}

