/*
 * Decompiled with CFR 0.152.
 */
package water;

import hex.schemas.ModelBuilderSchema;
import java.util.Arrays;
import water.DException;
import water.DTask;
import water.FetchClazz;
import water.FetchId;
import water.Freezable;
import water.H2O;
import water.H2OError;
import water.H2ONode;
import water.HeartBeat;
import water.Iced;
import water.Icer;
import water.Key;
import water.Paxos;
import water.UDPRebooted;
import water.Weaver;
import water.api.AboutHandler;
import water.api.CloudV3;
import water.api.H2OErrorV3;
import water.api.MetadataBase;
import water.api.MetadataV3;
import water.api.NodePersistentStorageV3;
import water.api.RouteBase;
import water.api.RouteV3;
import water.api.Schema;
import water.api.TypeaheadV3;
import water.fvec.C1NChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.nbhm.NonBlockingHashMap;
import water.util.IcedHashMap;
import water.util.IcedHashMapBase;
import water.util.IcedSortedHashMap;
import water.util.Log;

public class TypeMap {
    public static final short NULL;
    public static final short PRIM_B;
    public static final short ICED;
    public static final short H2OCC;
    public static final short C1NCHUNK;
    public static final short FRAME;
    public static final short VECGROUP;
    public static final short KEY;
    static final String[] BOOTSTRAP_CLASSES;
    private static final NonBlockingHashMap<String, Integer> MAP;
    static String[] CLAZZES;
    private static Icer[] GOLD;
    private static int IDS;
    public static volatile boolean _check_no_locking;

    static int onIce(Iced ice) {
        return TypeMap.onIce(ice.getClass().getName());
    }

    static int onIce(Freezable ice) {
        return TypeMap.onIce(ice.getClass().getName());
    }

    public static int onIce(String className) {
        Integer I = MAP.get(className);
        if (I != null) {
            return I;
        }
        assert (H2O.CLOUD.size() > 0) : "No cloud when getting type id for " + className;
        Paxos.lockCloud(className);
        int id = H2O.CLOUD.leader() == H2O.SELF ? -1 : FetchId.fetchId(className);
        return TypeMap.install(className, id);
    }

    private static Icer goForGold(int id) {
        Icer[] gold = GOLD;
        return id < gold.length ? gold[id] : null;
    }

    public static String className(int id) {
        String s;
        if (id == PRIM_B) {
            return "[B";
        }
        Icer f = TypeMap.goForGold(id);
        if (f != null) {
            return f.className();
        }
        if (id < CLAZZES.length && (s = CLAZZES[id]) != null) {
            return s;
        }
        assert (H2O.CLOUD.leader() != H2O.SELF) : "Leader has no mapping for id " + id;
        s = FetchClazz.fetchClazz(id);
        Paxos.lockCloud(s);
        TypeMap.install(s, id);
        return s;
    }

    private static synchronized int install(String className, int id) {
        assert (!_check_no_locking) : "Locking cloud to assign typeid to " + className;
        if (id == -1) {
            assert (H2O.CLOUD.leader() == H2O.SELF);
            Integer i = MAP.get(className);
            if (i != null) {
                return i;
            }
            id = IDS++;
        }
        MAP.put(className, id);
        if (id >= CLAZZES.length) {
            CLAZZES = Arrays.copyOf(CLAZZES, Math.max(CLAZZES.length << 1, id + 1));
        }
        if (id >= GOLD.length) {
            GOLD = Arrays.copyOf(GOLD, Math.max(CLAZZES.length << 1, id + 1));
        }
        TypeMap.CLAZZES[id] = className;
        return id;
    }

    static Icer getIcer(int id, Iced ice) {
        return TypeMap.getIcer(id, ice.getClass());
    }

    static Icer getIcer(int id, Freezable ice) {
        return TypeMap.getIcer(id, ice.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Icer getIcer(int id, Class ice_clz) {
        Icer f = TypeMap.goForGold(id);
        if (f != null) {
            return f;
        }
        Class clazz = ice_clz;
        synchronized (clazz) {
            f = TypeMap.goForGold(id);
            if (f != null) {
                return f;
            }
            try {
                f = Weaver.genDelegate(id, ice_clz);
            }
            catch (Exception e) {
                Log.err("Weaver generally only throws if classfiles are not found, e.g. IDE setups running test code from a remote node that is not in the classpath on this node.");
                Log.throwErr(e);
            }
            Class<TypeMap> clazz2 = TypeMap.class;
            synchronized (TypeMap.class) {
                TypeMap.GOLD[id] = f;
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return TypeMap.GOLD[id];
            }
        }
    }

    static Iced newInstance(int id) {
        return (Iced)TypeMap.newFreezable(id);
    }

    public static Freezable newFreezable(int id) {
        Freezable iced = TypeMap.theFreezable(id);
        assert (iced != null) : "No instance of id " + id + ", class=" + CLAZZES[id];
        return (Freezable)iced.clone();
    }

    static Freezable theFreezable(int id) {
        try {
            Icer f = TypeMap.goForGold(id);
            return (f == null ? TypeMap.getIcer(id, Class.forName(TypeMap.className(id))) : f).theFreezable();
        }
        catch (ClassNotFoundException e) {
            throw Log.throwErr(e);
        }
    }

    static {
        BOOTSTRAP_CLASSES = new String[]{" BAD", "[B", Iced.class.getName(), H2O.H2OCountedCompleter.class.getName(), HeartBeat.class.getName(), H2ONode.class.getName(), FetchClazz.class.getName(), FetchId.class.getName(), DTask.class.getName(), DException.class.getName(), Chunk.class.getName(), C1NChunk.class.getName(), Frame.class.getName(), Vec.VectorGroup.class.getName(), CloudV3.class.getName(), CloudV3.NodeV3.class.getName(), H2OError.class.getName(), H2OErrorV3.class.getName(), IcedHashMap.class.getName(), IcedSortedHashMap.class.getName(), IcedHashMapBase.class.getName(), IcedHashMap.IcedHashMapStringString.class.getName(), IcedHashMap.IcedHashMapStringObject.class.getName(), ModelBuilderSchema.IcedHashMapStringModelBuilderSchema.class.getName(), Schema.class.getName(), Schema.Meta.class.getName(), TypeaheadV3.class.getName(), Key.class.getName(), AboutHandler.AboutV3.class.getName(), AboutHandler.AboutEntryV3.class.getName(), NodePersistentStorageV3.class.getName(), NodePersistentStorageV3.NodePersistentStorageEntryV3.class.getName(), MetadataV3.class.getName(), MetadataBase.class.getName(), RouteV3.class.getName(), RouteBase.class.getName(), UDPRebooted.ShutdownTsk.class.getName()};
        MAP = new NonBlockingHashMap();
        CLAZZES = BOOTSTRAP_CLASSES;
        GOLD = new Icer[BOOTSTRAP_CLASSES.length];
        int id = 0;
        for (String s : CLAZZES) {
            MAP.put(s, id++);
        }
        IDS = id;
        NULL = (short)-1;
        PRIM_B = (short)TypeMap.onIce("[B");
        ICED = (short)TypeMap.onIce("water.Iced");
        assert (ICED == 2);
        H2OCC = (short)TypeMap.onIce("water.H2O$H2OCountedCompleter");
        assert (H2OCC == 3);
        C1NCHUNK = (short)TypeMap.onIce("water.fvec.C1NChunk");
        FRAME = (short)TypeMap.onIce("water.fvec.Frame");
        VECGROUP = (short)TypeMap.onIce("water.fvec.Vec$VectorGroup");
        KEY = (short)TypeMap.onIce("water.Key");
        TypeMap.GOLD[TypeMap.ICED] = Icer.ICER;
    }
}

