/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.InputStream;
import java.util.Scanner;
import water.DKV;
import water.H2O;
import water.api.DownloadDataV3;
import water.api.Handler;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.fvec.Frame;

public class DownloadDataHandler
extends Handler {
    public DownloadDataV3 fetch(int version, DownloadDataV3 server) {
        String suggested_fname;
        int x;
        if (DKV.get(server.frame_id.key()) == null) {
            throw new H2OKeyNotFoundArgumentException("key", server.frame_id.key());
        }
        Frame value = (Frame)server.frame_id.key().get();
        InputStream is = value.toCSV(true, server.hex_string);
        Scanner scanner = new Scanner(is).useDelimiter("\\A");
        server.csv = scanner.hasNext() ? scanner.next() : "";
        String s = server.frame_id.toString();
        boolean dot = false;
        for (x = s.length() - 1; x >= 0; --x) {
            if (Character.isLetterOrDigit(s.charAt(x)) || s.charAt(x) == '_') continue;
            if (s.charAt(x) != '.' || dot) break;
            dot = true;
        }
        if (!(suggested_fname = s.substring(x + 1).replace(".hex", ".csv")).endsWith(".csv")) {
            suggested_fname = suggested_fname + ".csv";
        }
        server.filename = suggested_fname;
        return server;
    }

    public DownloadDataV3 fetchStreaming(int version, DownloadDataV3 server) {
        throw H2O.fail("Function fetchStreaming should never be called.");
    }
}

