/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.grid.Grid;
import hex.schemas.GridSchemaV99;
import water.H2O;
import water.Key;
import water.api.Handler;
import water.api.KeyV3;
import water.api.ModelParametersSchema;
import water.api.Schema;

public class GridsHandler
extends Handler {
    public GridSchemaV99 list(int version, GridSchemaV99 s) {
        throw H2O.unimpl();
    }

    public GridSchemaV99 fetch(int version, GridSchemaV99 s) {
        Grid grid = GridsHandler.getFromDKV("grid_id", s.grid_id.key(), Grid.class);
        Key<Model>[] models = grid.getModelKeys();
        KeyV3.ModelKeyV3[] modelIds = new KeyV3.ModelKeyV3[models.length];
        for (int i = 0; i < modelIds.length; ++i) {
            modelIds[i] = new KeyV3.ModelKeyV3(models[i]);
        }
        s.model_ids = modelIds;
        s.hyper_names = grid.getHyperNames();
        s.failed_params = this.toModelParametersSchema(grid.getFailedParameters());
        s.failure_details = grid.getFailureDetails();
        s.failure_stack_traces = grid.getFailureStackTraces();
        s.failed_raw_params = grid.getFailedRawParameters();
        return s;
    }

    private ModelParametersSchema[] toModelParametersSchema(Model.Parameters[] modelParameters) {
        ModelParametersSchema[] result = new ModelParametersSchema[modelParameters.length];
        for (int i = 0; i < modelParameters.length; ++i) {
            result[i] = modelParameters[i] != null ? (ModelParametersSchema)Schema.schema(Schema.getLatestVersion(), modelParameters[i]).fillFromImpl(modelParameters[i]) : null;
        }
        return result;
    }
}

