/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.Value;
import water.api.Handler;
import water.api.JobV3;
import water.api.JobsV3;
import water.api.ModelBuilderJobV3;
import water.api.Schema;
import water.exceptions.H2ONotFoundArgumentException;

public class JobsHandler
extends Handler {
    public JobsV3 list(int version, JobsV3 s) {
        Job[] jobs = Job.jobs();
        s.jobs = new JobV3[jobs.length];
        int i = 0;
        for (Job j : jobs) {
            if (j instanceof ModelBuilder) {
                s.jobs[i] = new ModelBuilderJobV3().fillFromImpl((ModelBuilder)j);
            } else {
                try {
                    s.jobs[i] = (JobV3)Schema.schema(version, j).fillFromImpl(j);
                }
                catch (H2ONotFoundArgumentException e) {
                    s.jobs[i] = new JobV3().fillFromImpl(j);
                }
            }
            ++i;
        }
        return s;
    }

    public JobsV3 fetch(int version, JobsV3 s) {
        Key key = s.job_id.key();
        Value val = DKV.get(key);
        if (null == val) {
            throw new IllegalArgumentException("Job is missing");
        }
        Object ice = val.get();
        if (!(ice instanceof Job)) {
            throw new IllegalArgumentException("Must be a Job not a " + ice.getClass());
        }
        Job j = (Job)ice;
        Jobs jobs = new Jobs();
        jobs._jobs = new Job[1];
        jobs._jobs[0] = (Job)ice;
        s.jobs = new JobV3[1];
        if (j instanceof ModelBuilder) {
            s.jobs[0] = new ModelBuilderJobV3().fillFromImpl(j);
        } else {
            try {
                s.jobs[0] = (JobV3)Schema.schema(version, j).fillFromImpl(j);
            }
            catch (H2ONotFoundArgumentException e) {
                s.jobs[0] = new JobV3().fillFromImpl(j);
            }
        }
        return s;
    }

    public JobsV3 cancel(int version, JobsV3 c) {
        Job j = (Job)DKV.getGet(c.job_id.key());
        if (j == null) {
            throw new IllegalArgumentException("No job with key " + c.job_id.key());
        }
        j.cancel();
        return c;
    }

    public static final class Jobs
    extends Iced {
        public Key _job_id;
        public Job[] _jobs;

        public Jobs() {
        }

        public Jobs(Job j) {
            this._jobs = new Job[1];
            this._jobs[0] = j;
        }
    }
}

