/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.ArrayList;
import water.AutoBuffer;
import water.Iced;
import water.IcedWrapper;
import water.api.API;
import water.api.FieldMetadataV3;
import water.api.Schema;
import water.api.SchemaMetadata;
import water.util.PojoUtils;

public class SchemaMetadataBase<I extends SchemaMetadata, S extends SchemaMetadataBase<I, S>>
extends Schema<I, SchemaMetadataBase<I, S>> {
    @API(help="Version number of the Schema.")
    public int version;
    @API(help="Simple name of the Schema.  NOTE: the schema_names form a single namespace.")
    public String name;
    @API(help="Simple name of the superclass of the Schema.  NOTE: the schema_names form a single namespace.")
    public String superclass;
    @API(help="Simple name of H2O type that this Schema represents.  Must not be changed after creation (treat as final).")
    public String type;
    @API(help="All the public fields of the schema", direction=API.Direction.OUTPUT)
    public FieldMetadataBase[] fields;
    @API(help="Documentation for the schema in Markdown format with GitHub extensions", direction=API.Direction.OUTPUT)
    String markdown;

    @Override
    public I createImpl() {
        SchemaMetadata impl = new SchemaMetadata();
        return (I)impl;
    }

    @Override
    public I fillImpl(I impl) {
        ((SchemaMetadata)impl).fields = new ArrayList<SchemaMetadata.FieldMetadata>(this.fields.length);
        boolean i = false;
        for (FieldMetadataBase s : this.fields) {
            ((SchemaMetadata)impl).fields.add((SchemaMetadata.FieldMetadata)s.createImpl());
        }
        return impl;
    }

    @Override
    public SchemaMetadataBase fillFromImpl(SchemaMetadata impl) {
        PojoUtils.copyProperties(this, impl, PojoUtils.FieldNaming.CONSISTENT, new String[]{"fields"});
        this.fields = new FieldMetadataBase[impl.fields.size()];
        int i = 0;
        for (SchemaMetadata.FieldMetadata f : impl.fields) {
            this.fields[i++] = (FieldMetadataBase)new FieldMetadataV3().fillFromImpl(f);
        }
        return this;
    }

    public static class FieldMetadataBase<I extends SchemaMetadata.FieldMetadata, S extends FieldMetadataBase<I, S>>
    extends Schema<I, S> {
        @API(help="Field name in the Schema", direction=API.Direction.OUTPUT)
        public String name;
        @API(help="Type for this field", direction=API.Direction.OUTPUT)
        public String type;
        @API(help="Type for this field is itself a Schema.", direction=API.Direction.OUTPUT)
        public boolean is_schema;
        @API(help="Schema name for this field, if it is_schema, or the name of the enum, if it's an enum.")
        public String schema_name;
        @API(help="Value for this field", direction=API.Direction.OUTPUT)
        public Iced value;
        @API(help="A short help description to appear alongside the field in a UI", direction=API.Direction.OUTPUT)
        public String help;
        @API(help="The label that should be displayed for the field if the name is insufficient", direction=API.Direction.OUTPUT)
        public String label;
        @API(help="Is this field required, or is the default value generally sufficient?", direction=API.Direction.OUTPUT)
        public boolean required;
        @API(help="How important is this field?  The web UI uses the level to do a slow reveal of the parameters", values={"critical", "secondary", "expert"}, direction=API.Direction.OUTPUT)
        public API.Level level;
        @API(help="Is this field an input, output or inout?", values={"INPUT", "OUTPUT", "INOUT"}, direction=API.Direction.OUTPUT)
        public API.Direction direction;
        @API(help="Is the field gridable (i.e., it can be used in grid call)", direction=API.Direction.OUTPUT)
        public boolean is_gridable;
        @API(help="For enum-type fields the allowed values are specified using the values annotation;  this is used in UIs to tell the user the allowed values, and for validation", direction=API.Direction.OUTPUT)
        String[] values;
        @API(help="Should this field be rendered in the JSON representation?", direction=API.Direction.OUTPUT)
        boolean json;
        @API(help="For Vec-type fields this is the set of other Vec-type fields which must contain mutually exclusive values; for example, for a SupervisedModel the response_column must be mutually exclusive with the weights_column", direction=API.Direction.OUTPUT)
        String[] is_member_of_frames;
        @API(help="For Vec-type fields this is the set of Frame-type fields which must contain the named column; for example, for a SupervisedModel the response_column must be in both the training_frame and (if it's set) the validation_frame", direction=API.Direction.OUTPUT)
        String[] is_mutually_exclusive_with;

        @Override
        public AutoBuffer writeJSON_impl(AutoBuffer ab) {
            ab.put1(44);
            ab.putJSONStr("name", this.name);
            ab.put1(44);
            ab.putJSONStr("type", this.type);
            ab.put1(44);
            ab.putJSONStrUnquoted("is_schema", this.is_schema ? "true" : "false");
            ab.put1(44);
            ab.putJSONStr("schema_name", this.schema_name);
            ab.put1(44);
            if (this.value instanceof IcedWrapper) {
                ab.putJSONStr("value").put1(58);
                ((IcedWrapper)this.value).writeUnwrappedJSON(ab);
                ab.put1(44);
            } else {
                ab.putJSONStr("value").put1(58).putJSON(this.value);
                ab.put1(44);
            }
            ab.putJSONStr("help", this.help);
            ab.put1(44);
            ab.putJSONStr("label", this.label);
            ab.put1(44);
            ab.putJSONStrUnquoted("required", this.required ? "true" : "false");
            ab.put1(44);
            ab.putJSONStr("level", this.level.toString());
            ab.put1(44);
            ab.putJSONStr("direction", this.direction.toString());
            ab.put1(44);
            ab.putJSONStrUnquoted("is_gridable", this.is_gridable ? "true" : "false");
            ab.put1(44);
            ab.putJSONAStr("values", this.values);
            ab.put1(44);
            ab.putJSONStrUnquoted("json", this.json ? "true" : "false");
            ab.put1(44);
            ab.putJSONAStr("is_member_of_frames", this.is_member_of_frames);
            ab.put1(44);
            ab.putJSONAStr("is_mutually_exclusive_with", this.is_mutually_exclusive_with);
            return ab;
        }
    }
}

