/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Value;
import water.fvec.C0DChunk;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class AppendableVec
extends Vec {
    public long[] _tmp_espc;
    public static final byte NA = 1;
    public static final byte ENUM = 2;
    public static final byte NUMBER = 3;
    public static final byte TIME = 4;
    public static final byte UUID = 5;
    public static final byte STRING = 6;
    private byte[] _chunkTypes;
    long _naCnt;
    long _enumCnt;
    long _strCnt;
    long _timCnt;
    long _totalCnt;
    public int _chunkOff;

    public void setTypes(byte[] ts) {
        this._chunkTypes = ts;
    }

    public void setPrecedingChunkTypes(int cidx, byte type) {
        if (this._chunkTypes.length < cidx) {
            this._chunkTypes = Arrays.copyOf(this._chunkTypes, cidx << 1);
        }
        for (int i = 0; i < cidx; ++i) {
            this._chunkTypes[i] = type;
        }
    }

    public AppendableVec(Key key) {
        this(key, new long[4], 0);
    }

    public AppendableVec(Key key, long[] espc, int chunkOff) {
        super(key, null);
        this._tmp_espc = espc;
        this._chunkTypes = new byte[4];
        this._chunkOff = chunkOff;
    }

    synchronized void closeChunk(NewChunk chk) {
        int cidx = chk._cidx - this._chunkOff;
        while (cidx >= this._chunkTypes.length) {
            this._chunkTypes = Arrays.copyOf(this._chunkTypes, this._chunkTypes.length << 1);
        }
        while (cidx >= this._tmp_espc.length) {
            this._tmp_espc = Arrays.copyOf(this._tmp_espc, this._tmp_espc.length << 1);
        }
        this._tmp_espc[cidx] = chk._len;
        this._chunkTypes[cidx] = chk.type();
        this._naCnt += (long)chk.naCnt();
        this._enumCnt += (long)chk.enumCnt();
        this._strCnt += (long)chk.strCnt();
        this._timCnt += (long)chk._timCnt;
        this._totalCnt += (long)chk._len;
    }

    public static Vec[] closeAll(AppendableVec[] avs) {
        Futures fs = new Futures();
        Vec[] res = AppendableVec.closeAll(avs, fs);
        fs.blockForPending();
        return res;
    }

    public static Vec[] closeAll(AppendableVec[] avs, Futures fs) {
        Vec[] res = new Vec[avs.length];
        for (int i = 0; i < avs.length; ++i) {
            res[i] = avs[i].close(fs);
        }
        return res;
    }

    public void setSubRange(AppendableVec av) {
        assert (this._key.equals(av._key)) : "mismatched keys " + this._key + ", " + av._key;
        System.arraycopy(av._tmp_espc, 0, this._tmp_espc, av._chunkOff, av._tmp_espc.length);
        System.arraycopy(av._chunkTypes, 0, this._chunkTypes, av._chunkOff, av._tmp_espc.length);
        this._strCnt += av._strCnt;
        this._naCnt += av._naCnt;
        this._enumCnt += av._enumCnt;
        this._timCnt += av._timCnt;
        this._totalCnt += av._totalCnt;
    }

    public boolean shouldBeEnum() {
        long numCnt = this._totalCnt - this._strCnt - this._naCnt - this._enumCnt;
        return this._enumCnt > numCnt;
    }

    public void reduce(AppendableVec nv) {
        byte[] t1;
        int i;
        if (this == nv) {
            return;
        }
        if (this._tmp_espc != nv._tmp_espc) {
            long[] e1 = nv._tmp_espc;
            if (e1.length > this._tmp_espc.length) {
                e1 = this._tmp_espc;
                this._tmp_espc = nv._tmp_espc;
            }
            for (i = 0; i < e1.length; ++i) {
                int n = i;
                this._tmp_espc[n] = this._tmp_espc[n] | e1[i];
            }
        }
        if ((t1 = nv._chunkTypes).length > this._chunkTypes.length) {
            t1 = this._chunkTypes;
            this._chunkTypes = nv._chunkTypes;
        }
        for (i = 0; i < t1.length; ++i) {
            int n = i;
            this._chunkTypes[n] = (byte)(this._chunkTypes[n] | t1[i]);
        }
        this._naCnt += nv._naCnt;
        this._enumCnt += nv._enumCnt;
        this._strCnt += nv._strCnt;
        this._timCnt += nv._timCnt;
        this._totalCnt += nv._totalCnt;
    }

    public Vec close(Futures fs) {
        byte type;
        int i;
        int nchunk = this._tmp_espc.length;
        DKV.remove(this.chunkKey(nchunk), fs);
        while (nchunk > 1 && this._tmp_espc[nchunk - 1] == 0L) {
            DKV.remove(this.chunkKey(--nchunk), fs);
        }
        int[] ctypes = new int[7];
        for (int i2 = 0; i2 < nchunk; ++i2) {
            byte by = this._chunkTypes[i2];
            ctypes[by] = ctypes[by] + 1;
        }
        boolean genEnumCol = false;
        if (ctypes[2] == 0 && ctypes[4] == 0 && ctypes[5] == 0 && ctypes[6] == 0) {
            genEnumCol = true;
        }
        if (this.domain() != null && (genEnumCol || ctypes[2] > ctypes[3])) {
            ctypes[2] = ctypes[2] + ctypes[3];
            ctypes[3] = 0;
            ctypes[2] = ctypes[2] + ctypes[1];
            ctypes[1] = 0;
            if (nchunk == 0) {
                ctypes[2] = ctypes[2] + 1;
            }
        }
        int idx = 0;
        for (i = 0; i < ctypes.length; ++i) {
            if (i == 1 || ctypes[i] <= ctypes[idx]) continue;
            idx = i;
        }
        if (idx != 2) {
            this.setDomain(null);
        }
        for (i = 0; i < nchunk; ++i) {
            if (this._chunkTypes[i] == idx || idx == 2 && this._chunkTypes[i] == 3 && genEnumCol) continue;
            DKV.put(this.chunkKey(i), new C0DChunk(Double.NaN, (int)this._tmp_espc[i]), fs);
        }
        switch (idx) {
            case 2: {
                type = 4;
                break;
            }
            case 3: {
                type = 3;
                break;
            }
            case 4: {
                type = 5;
                break;
            }
            case 5: {
                type = 1;
                break;
            }
            case 6: {
                type = 2;
                break;
            }
            default: {
                type = 0;
            }
        }
        long[] espc = new long[nchunk + 1];
        long x = 0L;
        for (int i3 = 0; i3 < nchunk; ++i3) {
            espc[i3] = x;
            x += this._tmp_espc[i3];
        }
        espc[nchunk] = x;
        Vec vec = new Vec(this._key, espc, this.domain(), type);
        DKV.put(this._key, vec, fs);
        return vec;
    }

    @Override
    protected boolean readable() {
        return false;
    }

    @Override
    protected boolean writable() {
        return true;
    }

    @Override
    public NewChunk chunkForChunkIdx(int cidx) {
        return new NewChunk(this, cidx);
    }

    @Override
    public Value chunkIdx(int cidx) {
        throw H2O.fail();
    }

    @Override
    public long length() {
        throw H2O.fail();
    }

    @Override
    public int nChunks() {
        throw H2O.fail();
    }

    @Override
    int elem2ChunkIdx(long i) {
        throw H2O.fail();
    }

    @Override
    protected long chunk2StartElem(int cidx) {
        throw H2O.fail();
    }

    @Override
    public long byteSize() {
        return 0L;
    }

    @Override
    public String toString() {
        return "[AppendableVec, unknown size]";
    }
}

