/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class C1Chunk
extends Chunk {
    protected static final int _OFF = 0;
    protected static final long _NA = 255L;

    C1Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length);
    }

    @Override
    protected final long at8_impl(int i) {
        long res = 0xFF & this._mem[i + 0];
        if (res == 255L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        long res = 0xFF & this._mem[i + 0];
        return res == 255L ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (long)(0xFF & this._mem[i + 0]) == 255L;
    }

    @Override
    boolean set_impl(int i, long l) {
        if (0L > l || l >= 255L) {
            return false;
        }
        this._mem[i + 0] = (byte)l;
        return true;
    }

    @Override
    boolean set_impl(int i, double d) {
        return false;
    }

    @Override
    boolean set_impl(int i, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 0] = -1;
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(0);
        nc.set_len(0);
        int len = this._len;
        for (int i = 0; i < len; ++i) {
            int res = 0xFF & this._mem[i + 0];
            if ((long)res == 255L) {
                nc.addNA();
                continue;
            }
            nc.addNum(res, 0);
        }
        return nc;
    }

    @Override
    public final C1Chunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length);
        return this;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

