/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C2Chunk
extends Chunk {
    protected static final long _NA = -32768L;
    protected static final int _OFF = 0;

    C2Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 1);
    }

    @Override
    protected final long at8_impl(int i) {
        int res = UnsafeUtils.get2(this._mem, (i << 1) + 0);
        if ((long)res == -32768L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i) {
        int res = UnsafeUtils.get2(this._mem, (i << 1) + 0);
        return (long)res == -32768L ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return (long)UnsafeUtils.get2(this._mem, (i << 1) + 0) == -32768L;
    }

    @Override
    boolean set_impl(int idx, long l) {
        if (-32768L >= l || l > 32767L) {
            return false;
        }
        UnsafeUtils.set2(this._mem, (idx << 1) + 0, (short)l);
        return true;
    }

    @Override
    boolean set_impl(int idx, double d) {
        if (Double.isNaN(d)) {
            return this.setNA_impl(idx);
        }
        long l = (long)d;
        return (double)l == d && this.set_impl(idx, l);
    }

    @Override
    boolean set_impl(int i, float f) {
        return this.set_impl(i, (double)f);
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set2(this._mem, (idx << 1) + 0, (short)Short.MIN_VALUE);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(0);
        nc.set_len(0);
        int len = this._len;
        for (int i = 0; i < len; ++i) {
            int res = UnsafeUtils.get2(this._mem, (i << 1) + 0);
            if ((long)res == -32768L) {
                nc.addNA();
                continue;
            }
            nc.addNum(res, 0);
        }
        return nc;
    }

    @Override
    public C2Chunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 1);
        assert (this._mem.length == this._len << 1);
        return this;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

