/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.util.UnsafeUtils;

public class C8DChunk
extends Chunk {
    C8DChunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 3);
    }

    @Override
    protected final long at8_impl(int i) {
        double res = UnsafeUtils.get8d(this._mem, i << 3);
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i) {
        return UnsafeUtils.get8d(this._mem, i << 3);
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return Double.isNaN(UnsafeUtils.get8d(this._mem, i << 3));
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int i, double d) {
        UnsafeUtils.set8d(this._mem, i << 3, d);
        return true;
    }

    @Override
    boolean set_impl(int i, float f) {
        UnsafeUtils.set8d(this._mem, i << 3, f);
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8d(this._mem, idx << 3, Double.NaN);
        return true;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.alloc_doubles(this._len);
        for (int i = 0; i < this._len; ++i) {
            nc.doubles()[i] = UnsafeUtils.get8d(this._mem, i << 3);
        }
        nc.set_sparseLen(nc.set_len(this._len));
        return nc;
    }

    @Override
    public C8DChunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 3);
        assert (this._mem.length == this._len << 3);
        return this;
    }
}

