/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.H2O;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class CBSChunk
extends Chunk {
    protected static final byte _NA = 2;
    protected static final int _OFF = 2;
    private byte _bpv;
    private byte _gap;

    public byte bpv() {
        return this._bpv;
    }

    public byte gap() {
        return this._gap;
    }

    public CBSChunk(boolean[] vals) {
        int gap = 8 - vals.length % 8;
        int n = (vals.length >> 3) + (gap == 0 ? 0 : 1);
        byte[] bytes = MemoryManager.malloc1(2 + n);
        bytes[0] = this._gap = (byte)gap;
        this._bpv = 1;
        bytes[1] = 1;
        for (int i = 0; i < vals.length; ++i) {
            if (!vals[i]) continue;
            int j = 2 + i / 8;
            int k = 8 - i % 8 - 1;
            bytes[j] = (byte)(bytes[j] | 1 << k);
        }
        this._mem = bytes;
        this._start = -1L;
        this.set_len(((this._mem.length - 2) * 8 - this._gap) / this._bpv);
    }

    public CBSChunk(byte[] bs, byte gap, byte bpv) {
        assert (gap < 8);
        assert (bpv == 1 || bpv == 2);
        this._mem = bs;
        this._start = -1L;
        this._gap = gap;
        this._bpv = bpv;
        this.set_len(((this._mem.length - 2) * 8 - this._gap) / this._bpv);
    }

    @Override
    protected long at8_impl(int idx) {
        byte b = this.atb(idx);
        if (b == 2) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return b;
    }

    @Override
    protected double atd_impl(int idx) {
        byte b = this.atb(idx);
        return b == 2 ? Double.NaN : (double)b;
    }

    @Override
    protected final boolean isNA_impl(int i) {
        return this.atb(i) == 2;
    }

    protected byte atb(int idx) {
        int vpb = 8 / this._bpv;
        int bix = 2 + idx / vpb;
        int off = this._bpv * (idx % vpb);
        byte b = this._mem[bix];
        switch (this._bpv) {
            case 1: {
                return CBSChunk.read1b(b, off);
            }
            case 2: {
                return CBSChunk.read2b(b, off);
            }
        }
        H2O.fail();
        return -1;
    }

    @Override
    boolean set_impl(int idx, long l) {
        return false;
    }

    @Override
    boolean set_impl(int idx, double d) {
        return false;
    }

    @Override
    boolean set_impl(int idx, float f) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        return false;
    }

    @Override
    public NewChunk inflate_impl(NewChunk nc) {
        nc.set_sparseLen(nc.set_len(0));
        for (int i = 0; i < this._len; ++i) {
            byte res = this.atb(i);
            if (res == 2) {
                nc.addNA();
                continue;
            }
            nc.addNum(res, 0);
        }
        return nc;
    }

    public static byte write1b(byte b, byte val, int off) {
        val = (byte)((val & 1) << 7 - off);
        return (byte)(b | val);
    }

    public static byte write2b(byte b, byte val, int off) {
        val = (byte)((val & 3) << 6 - off);
        return (byte)(b | val);
    }

    public static byte read1b(byte b, int off) {
        return (byte)(b >> 7 - off & 1);
    }

    public static byte read2b(byte b, int off) {
        return (byte)(b >> 6 - off & 3);
    }

    public static int clen(int values, int bpv) {
        int len = values * bpv >> 3;
        return values * bpv % 8 == 0 ? len : len + 1;
    }

    @Override
    double min() {
        return 0.0;
    }

    @Override
    double max() {
        return 1.0;
    }

    @Override
    public CBSChunk read_impl(AutoBuffer bb) {
        this._mem = bb.bufClose();
        this._start = -1L;
        this._cidx = -1;
        this._gap = this._mem[0];
        this._bpv = this._mem[1];
        this.set_len(((this._mem.length - 2) * 8 - this._gap) / this._bpv);
        return this;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

