/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.AutoBuffer;
import water.DKV;
import water.H2O;
import water.Key;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.fvec.WrappedVec;
import water.parser.ValueString;

public class StrWrappedVec
extends WrappedVec {
    public StrWrappedVec(Key key, long[] espc, Key masterVecKey) {
        super(key, espc, masterVecKey);
        this._type = (byte)2;
        DKV.put(this);
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        return new StrWrappedChunk(this.masterVec().chunkForChunkIdx(cidx), this);
    }

    static class StrWrappedChunk
    extends Chunk {
        final Chunk _c;

        StrWrappedChunk(Chunk c, StrWrappedVec vec) {
            this._c = c;
            this.set_len(this._c._len);
            this._start = this._c._start;
            this._vec = vec;
            this._cidx = this._c._cidx;
        }

        @Override
        public double atd_impl(int idx) {
            throw new IllegalArgumentException("Operation not allowed on string vector.");
        }

        @Override
        public long at8_impl(int idx) {
            throw new IllegalArgumentException("Operation not allowed on string vector.");
        }

        @Override
        public ValueString atStr_impl(ValueString vstr, int idx) {
            return this.isNA_impl(idx) ? null : vstr.setTo(((StrWrappedVec)this._vec).masterVec().factor(this._c.at8_impl(idx)));
        }

        @Override
        protected boolean isNA_impl(int idx) {
            return this._c.isNA_impl(idx);
        }

        @Override
        boolean setNA_impl(int idx) {
            throw new IllegalArgumentException("Operation not allowed on string vector.");
        }

        @Override
        boolean set_impl(int idx, long l) {
            throw new IllegalArgumentException("Operation not allowed on string vector.");
        }

        @Override
        boolean set_impl(int idx, double d) {
            throw new IllegalArgumentException("Operation not allowed on string vector.");
        }

        @Override
        boolean set_impl(int idx, float f) {
            throw new IllegalArgumentException("Operation not allowed on string vector.");
        }

        @Override
        boolean set_impl(int idx, String str) {
            return false;
        }

        @Override
        public NewChunk inflate_impl(NewChunk nc) {
            nc.set_sparseLen(nc.set_len(0));
            for (int i = 0; i < this._len; ++i) {
                if (this.isNA(i)) {
                    nc.addNA();
                    continue;
                }
                nc.addNum(this.at8(i), 0);
            }
            return nc;
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer bb) {
            throw H2O.fail();
        }

        @Override
        public Chunk read_impl(AutoBuffer bb) {
            throw H2O.fail();
        }
    }
}

