/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Future;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.MemoryManager;
import water.TAtomic;
import water.Value;
import water.fvec.AppendableVec;
import water.fvec.C0DChunk;
import water.fvec.C0LChunk;
import water.fvec.Chunk;
import water.fvec.EnumWrappedVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.RollupStats;
import water.fvec.StrWrappedVec;
import water.nbhm.NonBlockingHashMapLong;
import water.parser.ValueString;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.RandomUtils;
import water.util.UnsafeUtils;

public class Vec
extends Keyed<Vec> {
    public final long[] _espc;
    private String[] _domain;
    public static final byte T_BAD = 0;
    public static final byte T_UUID = 1;
    public static final byte T_STR = 2;
    public static final byte T_NUM = 3;
    public static final byte T_ENUM = 4;
    public static final byte T_TIME = 5;
    byte _type;
    public static final String[] TYPE_STR = new String[]{"BAD", "UUID", "String", "Numeric", "Enum", "Time", "Time", "Time"};
    public static final boolean DO_HISTOGRAMS = true;
    private final Key _rollupStatsKey;
    public static final double[] PERCENTILES = new double[]{0.001, 0.01, 0.1, 0.25, 0.3333333333333333, 0.5, 0.6666666666666666, 0.75, 0.9, 0.99, 0.999};
    public static final int KEY_PREFIX_LEN = 10;

    public final String[] domain() {
        return this._domain;
    }

    public final String factor(long i) {
        return this._domain[(int)i];
    }

    public final void setDomain(String[] domain) {
        this._domain = domain;
        if (domain != null) {
            this._type = (byte)4;
        }
    }

    public final int cardinality() {
        return this.isEnum() ? this._domain.length : -1;
    }

    public final boolean isEnum() {
        assert (this._type == 4 && this._domain != null || this._type != 4 && this._domain == null);
        return this._type == 4;
    }

    public final double sparseRatio() {
        return (double)this.rollupStats()._nzCnt / (double)this.length();
    }

    public final boolean isUUID() {
        return this._type == 1;
    }

    public final boolean isString() {
        return this._type == 2;
    }

    public final boolean isNumeric() {
        return this._type == 3;
    }

    public final boolean isTime() {
        return this._type == 5;
    }

    public Vec(Key<Vec> key, long[] espc) {
        this(key, espc, null, 3);
    }

    Vec(Key<Vec> key, long[] espc, String[] domain) {
        this(key, espc, domain, domain == null ? (byte)3 : 4);
    }

    public Vec(Key<Vec> key, long[] espc, String[] domain, byte type) {
        super(key);
        assert (key._kb[0] == 4);
        assert (domain == null || type == 4);
        assert (0 <= type && type <= 5);
        this._type = type;
        this._espc = espc;
        this._domain = domain;
        this._rollupStatsKey = this.chunkKey(-2);
    }

    public long length() {
        return this._espc[this._espc.length - 1];
    }

    public int nChunks() {
        return this._espc.length - 1;
    }

    long chunk2StartElem(int cidx) {
        return this._espc[cidx];
    }

    private int chunkLen(int cidx) {
        return (int)(this._espc[cidx + 1] - this._espc[cidx]);
    }

    boolean checkCompatible(Vec v) {
        return !(this._espc != v._espc && !Arrays.equals(this._espc, v._espc) || !VectorGroup.sameGroup(this, v) && !((double)this.length() < 100000.0));
    }

    boolean readable() {
        return true;
    }

    boolean writable() {
        return true;
    }

    public long[] get_espc() {
        return this._espc;
    }

    public byte get_type() {
        return this._type;
    }

    public String get_type_str() {
        return TYPE_STR[this._type];
    }

    public boolean isBinary() {
        RollupStats rs = this.rollupStats();
        return rs._isInt && rs._mins[0] == 0.0 && rs._maxs[0] == 1.0;
    }

    public static Vec makeZero(long len, boolean redistribute) {
        return Vec.makeCon(0.0, len, redistribute);
    }

    public static Vec makeZero(long len) {
        return Vec.makeCon(0.0, len);
    }

    public static Vec makeCon(double x, long len) {
        return Vec.makeCon(x, len, true);
    }

    public static Vec makeCon(double x, long len, boolean redistribute) {
        int log_rows_per_chunk = 22;
        return Vec.makeCon(x, len, log_rows_per_chunk, redistribute);
    }

    public static Vec makeCon(double x, long len, int log_rows_per_chunk) {
        return Vec.makeCon(x, len, log_rows_per_chunk, true);
    }

    public static Vec makeCon(double x, long len, int log_rows_per_chunk, boolean redistribute) {
        int nchunks = (int)Math.max(1L, len >> log_rows_per_chunk);
        long[] espc = new long[nchunks + 1];
        for (int i = 0; i < nchunks; ++i) {
            espc[i] = (long)i << log_rows_per_chunk;
        }
        espc[nchunks] = len;
        Vec v0 = Vec.makeCon(x, VectorGroup.VG_LEN1, espc);
        int chunks = (int)Math.min((long)(4 * H2O.NUMCPUS * H2O.CLOUD.size()), v0.length());
        if (redistribute && v0.nChunks() < chunks && v0.length() > (long)(10 * chunks)) {
            Key newKey = Key.make(Key.rand() + ".makeConRebalance" + chunks);
            Frame f = new Frame(v0);
            RebalanceDataSet rb = new RebalanceDataSet(f, newKey, chunks);
            H2O.submitTask(rb);
            rb.join();
            Keyed.remove(v0._key);
            v0 = ((Frame)DKV.getGet(newKey)).anyVec().makeCopy(null);
            Keyed.remove(newKey);
        }
        return v0;
    }

    public Vec makeZero() {
        return Vec.makeCon(0L, null, this.group(), this._espc);
    }

    public Vec makeZero(String[] domain) {
        return Vec.makeCon(0L, domain, this.group(), this._espc);
    }

    public Vec makeCopy(String[] domain) {
        Vec v = this.doCopy();
        v._domain = domain;
        v._type = this._type;
        DKV.put(v._key, v);
        return v;
    }

    public Vec makeCopy(String[] domain, byte type) {
        Vec v = this.doCopy();
        v._domain = domain;
        v._type = type;
        DKV.put(v._key, v);
        return v;
    }

    private Vec doCopy() {
        final Vec v = new Vec(this.group().addVec(), (long[])this._espc.clone());
        new MRTask(){

            @Override
            public void map(Chunk c) {
                Chunk c2 = (Chunk)c.clone();
                c2._vec = null;
                c2._start = -1L;
                c2._cidx = -1;
                c2._mem = (byte[])c2._mem.clone();
                DKV.put(v.chunkKey(c.cidx()), c2, this._fs);
            }
        }.doAll(this);
        return v;
    }

    private static Vec makeCon(final long l, String[] domain, VectorGroup group, long[] espc) {
        final int nchunks = espc.length - 1;
        final Vec v0 = new Vec(group.addVec(), espc, domain);
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i = 0; i < nchunks; ++i) {
                    Key k = v0.chunkKey(i);
                    if (!k.home()) continue;
                    DKV.put(k, new C0LChunk(l, v0.chunkLen(i)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public static Vec makeVec(double[] vals, Key<Vec> vecKey) {
        long[] espc = new long[2];
        espc[1] = vals.length;
        Vec v = new Vec(vecKey, espc);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        for (double d : vals) {
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public static Vec makeVec(int[] vals, String[] domain, Key<Vec> vecKey) {
        long[] espc = new long[2];
        espc[1] = vals.length;
        Vec v = new Vec(vecKey, espc, domain);
        NewChunk nc = new NewChunk(v, 0);
        Futures fs = new Futures();
        int[] arr$ = vals;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double d = arr$[i$];
            nc.addNum(d);
        }
        nc.close(fs);
        DKV.put(v._key, v, fs);
        fs.blockForPending();
        return v;
    }

    public Vec makeCon(double d) {
        return Vec.makeCon(d, this.group(), this._espc);
    }

    private static Vec makeCon(final double d, VectorGroup group, long[] espc) {
        if ((double)((long)d) == d) {
            return Vec.makeCon((long)d, null, group, espc);
        }
        final int nchunks = espc.length - 1;
        final Vec v0 = new Vec(group.addVec(), espc, null, 3);
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (int i = 0; i < nchunks; ++i) {
                    Key k = v0.chunkKey(i);
                    if (!k.home()) continue;
                    DKV.put(k, new C0DChunk(d, v0.chunkLen(i)), this._fs);
                }
            }
        }.doAllNodes();
        DKV.put(v0._key, v0);
        return v0;
    }

    public Vec[] makeZeros(int n) {
        return this.makeZeros(n, null, null);
    }

    public Vec[] makeZeros(int n, String[][] domain, byte[] types) {
        return this.makeCons(n, 0L, domain, types);
    }

    public Vec[] makeCons(int n, final long l, String[][] domains, byte[] types) {
        final int nchunks = this.nChunks();
        Key<Vec>[] keys = this.group().addVecs(n);
        final Vec[] vs = new Vec[keys.length];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = new Vec(keys[i], this._espc, domains == null ? null : domains[i], types == null ? (byte)3 : types[i]);
        }
        new MRTask(){

            @Override
            protected void setupLocal() {
                for (Vec v1 : vs) {
                    for (int i = 0; i < nchunks; ++i) {
                        Key k = v1.chunkKey(i);
                        if (!k.home()) continue;
                        DKV.put(k, new C0LChunk(l, Vec.this.chunkLen(i)), this._fs);
                    }
                }
                for (Vec v : vs) {
                    if (!v._key.home()) continue;
                    DKV.put(v._key, v, this._fs);
                }
            }
        }.doAllNodes();
        return vs;
    }

    public static Vec makeCon(Key k, double ... rows) {
        k = k == null ? VectorGroup.VG_LEN1.addVec() : k;
        Futures fs = new Futures();
        AppendableVec avec = new AppendableVec((Key)k);
        NewChunk chunk = new NewChunk(avec, 0);
        for (double r : rows) {
            chunk.addNum(r);
        }
        chunk.close(0, fs);
        Vec vec = avec.close(fs);
        fs.blockForPending();
        return vec;
    }

    public static Vec makeSeq(long len, boolean redistribute) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, (long)(r + 1) + c._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len, (boolean)redistribute)}))._fr.vecs()[0];
    }

    public static Vec makeSeq(final long min, long len) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, (long)r + min + c._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len)}))._fr.vecs()[0];
    }

    public static Vec makeSeq(final long min, long len, boolean redistribute) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, (long)r + min + c._start);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len, (boolean)redistribute)}))._fr.vecs()[0];
    }

    public static Vec makeRepSeq(long len, final long repeat) {
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                for (Chunk c : cs) {
                    for (int r = 0; r < c._len; ++r) {
                        c.set(r, ((long)r + c._start) % repeat);
                    }
                }
            }
        }.doAll((Vec[])new Vec[]{Vec.makeZero((long)len)}))._fr.vecs()[0];
    }

    public Vec makeRand(final long seed) {
        Vec randVec = this.makeZero();
        new MRTask(){

            @Override
            public void map(Chunk c) {
                Random rng = RandomUtils.getRNG(seed * (long)(c.cidx() + 1));
                for (int i = 0; i < c._len; ++i) {
                    c.set(i, rng.nextFloat());
                }
            }
        }.doAll(randVec);
        return randVec;
    }

    public double min() {
        return this.mins()[0];
    }

    public double[] mins() {
        return this.rollupStats()._mins;
    }

    public double max() {
        return this.maxs()[0];
    }

    public double[] maxs() {
        return this.rollupStats()._maxs;
    }

    public final boolean isConst() {
        return this.min() == this.max();
    }

    public final boolean isBad() {
        return this.naCnt() == this.length();
    }

    public double mean() {
        return this.rollupStats()._mean;
    }

    public double sigma() {
        return this.rollupStats()._sigma;
    }

    public int mode() {
        if (!this.isEnum()) {
            throw H2O.unimpl();
        }
        long[] bins = this.bins();
        return ArrayUtils.maxIndex(bins);
    }

    public long naCnt() {
        return this.rollupStats()._naCnt;
    }

    public long nzCnt() {
        return this.rollupStats()._nzCnt;
    }

    public long pinfs() {
        return this.rollupStats()._pinfs;
    }

    public long ninfs() {
        return this.rollupStats()._ninfs;
    }

    public boolean isInt() {
        return this.rollupStats()._isInt;
    }

    public long byteSize() {
        return this.rollupStats()._size;
    }

    public long[] bins() {
        return RollupStats.get((Vec)this, (boolean)true)._bins;
    }

    public long[] lazy_bins() {
        return this.rollupStats()._bins;
    }

    public double base() {
        return RollupStats.get(this, true).h_base();
    }

    public double stride() {
        return RollupStats.get(this, true).h_stride();
    }

    public double[] pctiles() {
        return RollupStats.get((Vec)this, (boolean)true)._pctiles;
    }

    private RollupStats rollupStats() {
        return RollupStats.get(this);
    }

    public void startRollupStats(Futures fs) {
        this.startRollupStats(fs, false);
    }

    public void startRollupStats(Futures fs, boolean doHisto) {
        RollupStats.start(this, fs, doHisto);
    }

    @Override
    protected long checksum_impl() {
        return this.rollupStats()._checksum;
    }

    public void preWriting() {
        RollupStats rs;
        if (!this.writable()) {
            throw new IllegalArgumentException("Vector not writable");
        }
        Key rskey = this.rollupStatsKey();
        Value val = DKV.get(rskey);
        if (val != null && (rs = val.get(RollupStats.class)).isMutating()) {
            return;
        }
        new SetMutating().invoke(rskey);
    }

    public Futures postWrite(Futures fs) {
        RollupStats rs;
        Key rskey = this.rollupStatsKey();
        Value val = DKV.get(this.rollupStatsKey());
        if (val != null && (rs = val.get(RollupStats.class)).isMutating()) {
            DKV.remove(rskey, fs);
        }
        return fs;
    }

    int elem2ChunkIdx(long i) {
        if (0L > i || i >= this.length()) {
            throw new ArrayIndexOutOfBoundsException("0 <= " + i + " < " + this.length());
        }
        int lo = 0;
        int hi = this.nChunks();
        while (lo < hi - 1) {
            int mid = hi + lo >>> 1;
            if (i < this._espc[mid]) {
                hi = mid;
                continue;
            }
            lo = mid;
        }
        while (this._espc[lo + 1] == i) {
            ++lo;
        }
        return lo;
    }

    public static Key getVecKey(Key chk_key) {
        assert (chk_key._kb[0] == 5);
        byte[] bits = (byte[])chk_key._kb.clone();
        bits[0] = 4;
        UnsafeUtils.set4(bits, 6, -1);
        return Key.make(bits);
    }

    public Key chunkKey(int cidx) {
        return Vec.chunkKey(this._key, cidx);
    }

    public static Key chunkKey(Key veckey, int cidx) {
        byte[] bits = (byte[])veckey._kb.clone();
        bits[0] = 5;
        UnsafeUtils.set4(bits, 6, cidx);
        return Key.make(bits);
    }

    Key rollupStatsKey() {
        return this._rollupStatsKey;
    }

    public Value chunkIdx(int cidx) {
        Value val = DKV.get(this.chunkKey(cidx));
        assert (this.checkMissing(cidx, val)) : "Missing chunk " + this.chunkKey(cidx);
        return val;
    }

    private boolean checkMissing(int cidx, Value val) {
        if (val != null) {
            return true;
        }
        Log.err("Error: Missing chunk " + cidx + " for " + this._key);
        return false;
    }

    Chunk nextChunk(Chunk prior) {
        int cidx = this.elem2ChunkIdx(prior._start) + 1;
        return cidx < this.nChunks() ? this.chunkForChunkIdx(cidx) : null;
    }

    public static Key<Vec> newKey() {
        return Vec.newKey(Key.make());
    }

    static Key<Vec> newKey(Key k) {
        byte[] kb = k._kb;
        byte[] bits = MemoryManager.malloc1(kb.length + 10);
        bits[0] = 4;
        bits[1] = -1;
        UnsafeUtils.set4(bits, 2, 0);
        UnsafeUtils.set4(bits, 6, -1);
        System.arraycopy(kb, 0, bits, 10, kb.length);
        return Key.make(bits);
    }

    private Key groupKey() {
        byte[] bits = (byte[])this._key._kb.clone();
        bits[0] = 6;
        UnsafeUtils.set4(bits, 2, -1);
        UnsafeUtils.set4(bits, 6, -1);
        return Key.make(bits);
    }

    public final VectorGroup group() {
        Key gKey = this.groupKey();
        Value v = DKV.get(gKey);
        return v == null ? new VectorGroup(gKey, 1) : (VectorGroup)v.get();
    }

    public Chunk chunkForChunkIdx(int cidx) {
        long start = this.chunk2StartElem(cidx);
        Value dvec = this.chunkIdx(cidx);
        Chunk c = (Chunk)dvec.get();
        long cstart = c._start;
        Vec v = c._vec;
        int tcidx = c._cidx;
        if (cstart == start && v != null && tcidx == cidx) {
            return c;
        }
        assert (cstart == -1L || v == null || tcidx == -1);
        c._vec = this;
        c._start = start;
        c._cidx = cidx;
        return c;
    }

    public final Chunk chunkForRow(long i) {
        return this.chunkForChunkIdx(this.elem2ChunkIdx(i));
    }

    public final long at8(long i) {
        return this.chunkForRow(i).at8_abs(i);
    }

    public final double at(long i) {
        return this.chunkForRow(i).at_abs(i);
    }

    public final boolean isNA(long row) {
        return this.chunkForRow(row).isNA_abs(row);
    }

    public final long at16l(long i) {
        return this.chunkForRow(i).at16l_abs(i);
    }

    public final long at16h(long i) {
        return this.chunkForRow(i).at16h_abs(i);
    }

    public final ValueString atStr(ValueString vstr, long i) {
        return this.chunkForRow(i).atStr_abs(vstr, i);
    }

    public final void set(long i, long l) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, l);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, double d) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, d);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, float f) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, f);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    final void setNA(long i) {
        Chunk ck = this.chunkForRow(i);
        ck.setNA_abs(i);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final void set(long i, String str) {
        Chunk ck = this.chunkForRow(i);
        ck.set_abs(i, str);
        this.postWrite(ck.close(ck.cidx(), new Futures())).blockForPending();
    }

    public final Writer open() {
        return new Writer();
    }

    private Futures closeLocal(Futures fs) {
        int nc = this.nChunks();
        for (int i = 0; i < nc; ++i) {
            if (!H2O.containsKey(this.chunkKey(i))) continue;
            this.chunkForChunkIdx(i).close(i, fs);
        }
        return fs;
    }

    public String toString() {
        RollupStats rs = RollupStats.getOrNull(this);
        String s = "[" + this.length() + (rs == null ? ", {" : "," + rs._mins[0] + "/" + rs._mean + "/" + rs._maxs[0] + ", " + PrettyPrint.bytes(rs._size) + ", {");
        int nc = this.nChunks();
        for (int i = 0; i < nc; ++i) {
            s = s + this.chunkKey(i).home_node() + ":" + this.chunk2StartElem(i) + ":";
        }
        return s + "}]";
    }

    public boolean equals(Object o) {
        return o instanceof Vec && ((Vec)o)._key.equals(this._key);
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    @Override
    public Futures remove_impl(Futures fs) {
        final int ncs = this.nChunks();
        new MRTask(){

            @Override
            public void setupLocal() {
                Vec.bulk_remove(Vec.this._key, ncs);
            }
        }.doAllNodes();
        return fs;
    }

    static void bulk_remove(Key vkey, int ncs) {
        for (int i = 0; i < ncs; ++i) {
            Key kc = Vec.chunkKey(vkey, i);
            H2O.raw_remove(kc);
        }
        Key kr = Vec.chunkKey(vkey, -2);
        H2O.raw_remove(kr);
        H2O.raw_remove(vkey);
    }

    public Vec align(final Vec vec) {
        assert (!this.group().equals(vec.group())) : "Vector align expects a vector from different vector group";
        assert (this.length() == vec.length()) : "Trying to align vectors with different length!";
        Vec avec = this.makeZero();
        new MRTask(){

            @Override
            public void map(Chunk c0) {
                long srow = c0._start;
                for (int r = 0; r < c0._len; ++r) {
                    c0.set(r, vec.at(srow + (long)r));
                }
            }
        }.doAll(avec);
        avec._domain = vec._domain;
        return avec;
    }

    public Vec toEnum() {
        long[] dom;
        if (this.isEnum()) {
            return this.makeCopy(this.domain());
        }
        if (!this.isInt()) {
            throw new IllegalArgumentException("Enum conversion only works on integer columns");
        }
        int min = (int)this.min();
        int max = (int)this.max();
        long[] lArray = dom = min >= 0 && max < 0x7FFFFFFB ? ((CollectDomainFast)new CollectDomainFast(max).doAll(this)).domain() : ((CollectDomain)new CollectDomain().doAll(this)).domain();
        if (dom.length > 10000000) {
            throw new IllegalArgumentException("Column domain is too large to be represented as an enum: " + dom.length + " > " + 10000000);
        }
        return this.copyOver(dom);
    }

    private Vec copyOver(long[] domain) {
        String[][] dom = new String[][]{domain == null ? null : ArrayUtils.toString(domain)};
        return ((CPTask)new CPTask(domain).doAll(1, this)).outputFrame(null, dom).anyVec();
    }

    public Vec toInt() {
        if (this.isInt() && this._domain == null) {
            return this.copyOver(null);
        }
        if (!this.isEnum()) {
            throw new IllegalArgumentException("toInt conversion only works on Enum and Int vecs");
        }
        boolean useDomain = false;
        Vec newVec = this.copyOver(null);
        try {
            Integer.parseInt(this._domain[0]);
            useDomain = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (useDomain) {
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        c.set(i, Integer.parseInt(Vec.this._domain[(int)c.at8(i)]));
                    }
                }
            }.doAll(newVec);
        }
        return newVec;
    }

    public EnumWrappedVec adaptTo(String[] domain) {
        return new EnumWrappedVec(this.group().addVec(), this._espc, domain, this._key);
    }

    public StrWrappedVec toStringVec() {
        if (!this.isEnum()) {
            throw new IllegalArgumentException("String conversion only works on enum columns");
        }
        return new StrWrappedVec(this.group().addVec(), this._espc, this._key);
    }

    public double[] toDoubleArray() {
        if ((long)((int)this.length()) != this.length()) {
            throw new IllegalArgumentException("Vec length is larger than int");
        }
        final double[] ds = MemoryManager.malloc8d((int)this.length());
        new MRTask(){

            @Override
            public void map(Chunk cs) {
                for (int i = 0; i < cs._len; ++i) {
                    ds[i + (int)cs._start] = cs.atd(i);
                }
            }
        }.doAll(this);
        return ds;
    }

    public byte[] toByteArray() {
        if ((long)((int)this.length()) != this.length()) {
            throw new IllegalArgumentException("Vec length is larger than int");
        }
        if (this.min() < -128.0 || this.max() > 127.0 || !this.isInt()) {
            throw new IllegalArgumentException("Vec elements do not fit in a byte");
        }
        if (this.naCnt() > 0L) {
            throw new IllegalArgumentException("Byte array does not support missing values");
        }
        final byte[] bs = MemoryManager.malloc1((int)this.length());
        new MRTask(){

            @Override
            public void map(Chunk cs) {
                for (int i = 0; i < cs._len; ++i) {
                    bs[i + (int)cs._start] = (byte)cs.at8(i);
                }
            }
        }.doAll(this);
        return bs;
    }

    public static class VectorGroup
    extends Iced {
        public static final VectorGroup VG_LEN1 = new VectorGroup();
        final int _len;
        final Key _key;

        private VectorGroup(Key key, int len) {
            this._key = key;
            this._len = len;
        }

        public VectorGroup() {
            byte[] bits = new byte[26];
            bits[0] = 6;
            bits[1] = -1;
            UnsafeUtils.set4(bits, 2, -1);
            UnsafeUtils.set4(bits, 6, -1);
            UUID uu = UUID.randomUUID();
            UnsafeUtils.set8(bits, 10, uu.getLeastSignificantBits());
            UnsafeUtils.set8(bits, 18, uu.getMostSignificantBits());
            this._key = Key.make(bits);
            this._len = 0;
        }

        public static boolean sameGroup(Vec v1, Vec v2) {
            byte[] bits1 = v1._key._kb;
            byte[] bits2 = v2._key._kb;
            if (bits1.length != bits2.length) {
                return false;
            }
            int res = 0;
            for (int i = 10; i < bits1.length; ++i) {
                res |= bits1[i] ^ bits2[i];
            }
            return res == 0;
        }

        public Key<Vec> vecKey(int vecId) {
            byte[] bits = (byte[])this._key._kb.clone();
            bits[0] = 4;
            UnsafeUtils.set4(bits, 2, vecId);
            return Key.make(bits);
        }

        public int reserveKeys(int n) {
            AddVecs2GroupTsk tsk = new AddVecs2GroupTsk(this._key, n);
            tsk.invoke(this._key);
            return tsk._n;
        }

        public Future tryReturnKeys(int oldCnt, int newCnt) {
            return new ReturnKeysTsk(oldCnt, newCnt).fork(this._key);
        }

        public Key<Vec>[] addVecs(int n) {
            int nn = this.reserveKeys(n);
            Key[] res = new Key[n];
            for (int i = 0; i < n; ++i) {
                res[i] = this.vecKey(i + nn);
            }
            return res;
        }

        public Key<Vec> addVec() {
            return this.addVecs(1)[0];
        }

        public String toString() {
            return "VecGrp " + this._key.toString() + ", next free=" + this._len;
        }

        public boolean equals(Object o) {
            return o instanceof VectorGroup && ((VectorGroup)o)._key.equals(this._key);
        }

        public int hashCode() {
            return this._key.hashCode();
        }

        private static final class ReturnKeysTsk
        extends TAtomic<VectorGroup> {
            final int _newCnt;
            final int _oldCnt;

            private ReturnKeysTsk(int oldCnt, int newCnt) {
                this._newCnt = newCnt;
                this._oldCnt = oldCnt;
            }

            @Override
            public VectorGroup atomic(VectorGroup old) {
                return old._len == this._oldCnt ? new VectorGroup(this._key, this._newCnt) : old;
            }
        }

        private static final class AddVecs2GroupTsk
        extends TAtomic<VectorGroup> {
            final Key _key;
            int _n;

            private AddVecs2GroupTsk(Key key, int n) {
                this._key = key;
                this._n = n;
            }

            @Override
            protected VectorGroup atomic(VectorGroup old) {
                int n = this._n;
                this._n = old == null ? 1 : old._len;
                return new VectorGroup(this._key, n + this._n);
            }
        }
    }

    public static class CollectDomainFast
    extends MRTask<CollectDomainFast> {
        private final int _s;
        private boolean[] _u;
        private long[] _d;

        public CollectDomainFast(int s) {
            this._s = s;
        }

        @Override
        protected void setupLocal() {
            this._u = MemoryManager.mallocZ(this._s + 1);
        }

        @Override
        public void map(Chunk ys) {
            for (int row = 0; row < ys._len; ++row) {
                if (ys.isNA(row)) continue;
                this._u[(int)ys.at8((int)row)] = true;
            }
        }

        @Override
        public void reduce(CollectDomainFast mrt) {
            if (this._u != mrt._u) {
                ArrayUtils.or(this._u, mrt._u);
            }
        }

        @Override
        protected void postGlobal() {
            int c = 0;
            for (boolean b : this._u) {
                if (!b) continue;
                ++c;
            }
            this._d = MemoryManager.malloc8(c);
            int id = 0;
            for (int i = 0; i < this._u.length; ++i) {
                if (!this._u[i]) continue;
                this._d[id++] = i;
            }
            Arrays.sort(this._d);
        }

        public long[] domain() {
            return this._d;
        }
    }

    public static class CollectDomain
    extends MRTask<CollectDomain> {
        transient NonBlockingHashMapLong<String> _uniques;

        @Override
        protected void setupLocal() {
            this._uniques = new NonBlockingHashMapLong();
        }

        @Override
        public void map(Chunk ys) {
            for (int row = 0; row < ys._len; ++row) {
                if (ys.isNA(row)) continue;
                this._uniques.put(ys.at8(row), "");
            }
        }

        @Override
        public void reduce(CollectDomain mrt) {
            if (this._uniques != mrt._uniques) {
                this._uniques.putAll(mrt._uniques);
            }
        }

        @Override
        public AutoBuffer write_impl(AutoBuffer ab) {
            return ab.putA8(this._uniques == null ? null : this._uniques.keySetLong());
        }

        @Override
        public CollectDomain read_impl(AutoBuffer ab) {
            assert (this._uniques == null || this._uniques.size() == 0);
            long[] ls = ab.getA8();
            this._uniques = new NonBlockingHashMapLong();
            if (ls != null) {
                for (long l : ls) {
                    this._uniques.put(l, "");
                }
            }
            return this;
        }

        @Override
        public void copyOver(CollectDomain that) {
            this._uniques = that._uniques;
        }

        public long[] domain() {
            long[] dom = this._uniques.keySetLong();
            Arrays.sort(dom);
            return dom;
        }
    }

    private static class CPTask
    extends MRTask<CPTask> {
        private final long[] _domain;

        CPTask(long[] domain) {
            this._domain = domain;
        }

        @Override
        public void map(Chunk c, NewChunk nc) {
            for (int i = 0; i < c._len; ++i) {
                if (c.isNA(i)) {
                    nc.addNA();
                    continue;
                }
                if (this._domain == null) {
                    nc.addNum(c.at8(i));
                    continue;
                }
                long num = Arrays.binarySearch(this._domain, c.at8(i));
                if (num < 0L) {
                    throw new IllegalArgumentException("Could not find the enum value!");
                }
                nc.addNum(num);
            }
        }
    }

    public final class Writer
    implements Closeable {
        private Chunk _cache;

        private Chunk chk(long i) {
            Chunk c = this._cache;
            return c != null && c.chk2() == null && c._start <= i && i < c._start + (long)c._len ? c : (this._cache = Vec.this.chunkForRow(i));
        }

        private Writer() {
            Vec.this.preWriting();
        }

        public final void set(long i, long l) {
            this.chk(i).set_abs(i, l);
        }

        public final void set(long i, double d) {
            this.chk(i).set_abs(i, d);
        }

        public final void set(long i, float f) {
            this.chk(i).set_abs(i, f);
        }

        public final void setNA(long i) {
            this.chk(i).setNA_abs(i);
        }

        public final void set(long i, String str) {
            this.chk(i).set_abs(i, str);
        }

        public Futures close(Futures fs) {
            return Vec.this.postWrite(Vec.this.closeLocal(fs));
        }

        @Override
        public void close() {
            this.close(new Futures()).blockForPending();
        }
    }

    public final class Reader {
        private Chunk _cache;

        private Chunk chk(long i) {
            Chunk c = this._cache;
            return c != null && c.chk2() == null && c._start <= i && i < c._start + (long)c._len ? c : (this._cache = Vec.this.chunkForRow(i));
        }

        public final long at8(long i) {
            return this.chk(i).at8_abs(i);
        }

        public final double at(long i) {
            return this.chk(i).at_abs(i);
        }

        public final boolean isNA(long i) {
            return this.chk(i).isNA_abs(i);
        }

        public final long length() {
            return Vec.this.length();
        }
    }

    private static class SetMutating
    extends TAtomic<RollupStats> {
        private SetMutating() {
        }

        @Override
        protected RollupStats atomic(RollupStats rs) {
            return rs != null && rs.isMutating() ? null : RollupStats.makeMutating();
        }
    }
}

