/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.util.Random;
import water.DTask;
import water.Futures;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.MRTask;
import water.RPC;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.Timer;
import water.util.TwoDimTable;

public class NetworkTest
extends Iced {
    public int[] msg_sizes = new int[]{1, 1024, 0x100000};
    public int repeats = 10;
    public boolean collective = true;
    public boolean serial = true;
    public double[] microseconds_collective;
    public double[] bandwidths_collective;
    public double[][] microseconds;
    public double[][] bandwidths;
    public String[] nodes;
    public TwoDimTable table;

    public NetworkTest execImpl() {
        int i;
        this.microseconds = new double[this.msg_sizes.length][];
        this.microseconds_collective = new double[this.msg_sizes.length];
        NetworkTester nt = new NetworkTester(this.msg_sizes, this.microseconds, this.microseconds_collective, this.repeats, this.serial, this.collective);
        H2O.submitTask(nt);
        nt.join();
        this.bandwidths = new double[this.msg_sizes.length][];
        for (i = 0; i < this.bandwidths.length; ++i) {
            this.bandwidths[i] = new double[this.microseconds[i].length];
            for (int j = 0; j < this.microseconds[i].length; ++j) {
                this.bandwidths[i][j] = (double)(2 * this.msg_sizes[i]) / (this.microseconds[i][j] / 1000000.0);
            }
        }
        this.bandwidths_collective = new double[this.msg_sizes.length];
        for (i = 0; i < this.bandwidths_collective.length; ++i) {
            this.bandwidths_collective[i] = (double)(2 * H2O.CLOUD.size() * this.msg_sizes[i]) / (this.microseconds_collective[i] / 1000000.0);
        }
        this.nodes = new String[H2O.CLOUD.size()];
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = H2O.CLOUD._memary[i].toString();
        }
        this.fillTable();
        Log.info(this.table.toString());
        return this;
    }

    private static double[] send_recv_all(int msg_size, int repeats) {
        byte[] payload = new byte[msg_size];
        new Random().nextBytes(payload);
        int siz = H2O.CLOUD.size();
        double[] times = new double[siz];
        for (int i = 0; i < siz; ++i) {
            H2ONode node = H2O.CLOUD._memary[i];
            Timer t = new Timer();
            for (int l = 0; l < repeats; ++l) {
                PingPongTask ppt = new PingPongTask(payload);
                new RPC<PingPongTask>(node, ppt).call().get();
            }
            times[i] = (double)t.nanos() / (double)repeats;
        }
        return times;
    }

    private static double send_recv_collective(int msg_size, int repeats) {
        byte[] payload = new byte[msg_size];
        new Random().nextBytes(payload);
        Vec v = Vec.makeZero(1L);
        Timer t = new Timer();
        for (int l = 0; l < repeats; ++l) {
            new CollectiveTask(payload).doAll(v);
        }
        v.remove(new Futures()).blockForPending();
        return (double)t.nanos() / (double)repeats;
    }

    public void fillTable() {
        String tableHeader = "Network Test";
        String tableDescription = "Launched from " + H2O.SELF._key;
        String[] rowHeaders = new String[H2O.CLOUD.size() + 1];
        rowHeaders[0] = "all - collective bcast/reduce";
        for (int i = 0; i < H2O.CLOUD.size(); ++i) {
            rowHeaders[1 + i] = (H2O.SELF._key.equals(H2O.CLOUD._memary[i]._key) ? "self" : "remote") + " " + H2O.CLOUD._memary[i]._key.toString();
        }
        String[] colHeaders = new String[this.msg_sizes.length];
        for (int i = 0; i < colHeaders.length; ++i) {
            colHeaders[i] = this.msg_sizes[i] + " bytes";
        }
        String[] colTypes = new String[this.msg_sizes.length];
        for (int i = 0; i < colTypes.length; ++i) {
            colTypes[i] = "string";
        }
        String[] colFormats = new String[this.msg_sizes.length];
        for (int i = 0; i < colTypes.length; ++i) {
            colFormats[i] = "%s";
        }
        String colHeaderForRowHeaders = "Destination";
        this.table = new TwoDimTable(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders);
        for (int m = 0; m < this.msg_sizes.length; ++m) {
            this.table.set(0, m, PrettyPrint.usecs((long)this.microseconds_collective[m]) + ", " + PrettyPrint.bytesPerSecond((long)this.bandwidths_collective[m]));
        }
        for (int n = 0; n < H2O.CLOUD._memary.length; ++n) {
            for (int m = 0; m < this.msg_sizes.length; ++m) {
                this.table.set(1 + n, m, PrettyPrint.usecs((long)this.microseconds[m][n]) + ", " + PrettyPrint.bytesPerSecond((long)this.bandwidths[m][n]));
            }
        }
    }

    private static class CollectiveTask
    extends MRTask<CollectiveTask> {
        private final byte[] _payload;

        public CollectiveTask(byte[] payload) {
            this._payload = payload;
        }
    }

    private static class PingPongTask
    extends DTask<PingPongTask> {
        private final byte[] _payload;

        public PingPongTask(byte[] payload) {
            this._payload = payload;
        }

        @Override
        public void compute2() {
            this.tryComplete();
        }

        @Override
        public byte priority() {
            return 119;
        }
    }

    public static class NetworkTester
    extends H2O.H2OCountedCompleter {
        double[][] microseconds;
        double[] microseconds_collective;
        int[] msg_sizes;
        public int repeats = 10;
        boolean serial;
        boolean collective;

        public NetworkTester(int[] msg, double[][] res, double[] res_collective, int rep, boolean serial, boolean collective) {
            this.microseconds = res;
            this.microseconds_collective = res_collective;
            this.msg_sizes = msg;
            this.repeats = rep;
            this.serial = serial;
            this.collective = collective;
        }

        @Override
        public void compute2() {
            int i;
            if (this.serial) {
                for (i = 0; i < this.microseconds.length; ++i) {
                    this.microseconds[i] = NetworkTest.send_recv_all(this.msg_sizes[i], this.repeats);
                    ArrayUtils.div(this.microseconds[i], 1000.0);
                }
            }
            if (this.collective) {
                for (i = 0; i < this.microseconds_collective.length; ++i) {
                    this.microseconds_collective[i] = NetworkTest.send_recv_collective(this.msg_sizes[i], this.repeats);
                }
                ArrayUtils.div(this.microseconds_collective, 1000.0);
            }
            this.tryComplete();
        }
    }
}

