/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.H2O;
import water.Iced;
import water.exceptions.H2OIllegalArgumentException;
import water.rapids.ASTApply;
import water.rapids.ASTAssign;
import water.rapids.ASTBinOp;
import water.rapids.ASTDelete;
import water.rapids.ASTElse;
import water.rapids.ASTFor;
import water.rapids.ASTFrame;
import water.rapids.ASTFunc;
import water.rapids.ASTGetTimeZone;
import water.rapids.ASTId;
import water.rapids.ASTIf;
import water.rapids.ASTKey;
import water.rapids.ASTListTimeZones;
import water.rapids.ASTLs;
import water.rapids.ASTMMult;
import water.rapids.ASTMerge;
import water.rapids.ASTNull;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTReducerOp;
import water.rapids.ASTReturn;
import water.rapids.ASTSeries;
import water.rapids.ASTSetTimeZone;
import water.rapids.ASTSlice;
import water.rapids.ASTSpan;
import water.rapids.ASTStatement;
import water.rapids.ASTStoreSize;
import water.rapids.ASTString;
import water.rapids.ASTTranspose;
import water.rapids.ASTUniPrefixOp;
import water.rapids.ASTddply;
import water.rapids.Env;
import water.rapids.Exec;

public abstract class AST
extends Iced {
    String[] _arg_names;
    AST[] _asts;

    AST parse_impl(Exec e) {
        throw H2O.fail("Missing parse_impl for " + this.getClass());
    }

    abstract String opStr();

    abstract void exec(Env var1);

    abstract String value();

    abstract int type();

    abstract AST make();

    public int numChildren() {
        return this._asts.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Env treeWalk(Env e) {
        if (this instanceof ASTOp) {
            if (this instanceof ASTBinOp) {
                this._asts[1].treeWalk(e);
                this._asts[0].treeWalk(e);
                ((ASTBinOp)this).apply(e);
                return e;
            } else if (this instanceof ASTUniPrefixOp) {
                for (int i = 0; i < this._asts.length; ++i) {
                    this._asts[i].treeWalk(e);
                }
                ((ASTUniPrefixOp)this).apply(e);
                return e;
            } else if (this instanceof ASTReducerOp) {
                for (int i = 0; i < this._asts.length; ++i) {
                    this._asts[i].treeWalk(e);
                }
                ((ASTReducerOp)this).apply(e);
                return e;
            } else if (this instanceof ASTLs || this instanceof ASTSetTimeZone || this instanceof ASTListTimeZones || this instanceof ASTGetTimeZone || this instanceof ASTStoreSize) {
                ((ASTOp)this).apply(e);
                return e;
            } else if (this instanceof ASTFunc) {
                ((ASTFunc)this).apply(e);
                return e;
            } else if (this instanceof ASTApply) {
                this._asts[0].treeWalk(e);
                ((ASTApply)this).apply(e);
                return e;
            } else if (this instanceof ASTMMult) {
                this._asts[1].treeWalk(e);
                this._asts[0].treeWalk(e);
                ((ASTMMult)this).apply(e);
                return e;
            } else if (this instanceof ASTTranspose) {
                this._asts[0].treeWalk(e);
                ((ASTTranspose)this).apply(e);
                return e;
            } else if (this instanceof ASTddply) {
                this._asts[0].treeWalk(e);
                ((ASTddply)this).apply(e);
                return e;
            } else {
                if (!(this instanceof ASTMerge)) throw H2O.fail("Unknown AST in tree walk: " + this.getClass());
                this._asts[1].treeWalk(e);
                this._asts[0].treeWalk(e);
                ((ASTMerge)this).apply(e);
            }
            return e;
        } else if (this instanceof ASTAssign) {
            this._asts[1].treeWalk(e);
            this.exec(e);
            return e;
        } else if (this instanceof ASTId) {
            ASTId id = (ASTId)this;
            assert (id.isValid());
            if (id.isLookup()) {
                AST ast = e.lookup(id);
                ast.exec(e);
                return e;
            } else {
                if (!id.isLocalSet() && !id.isGlobalSet()) throw new H2OIllegalArgumentException("Got a bad identifier: '" + id.value() + "'. It has no type '!' or '$'.", "Got a bad identifier: '" + id.value() + "'. It has no type '!' or '$'." + " AST: " + this);
                e.put(((ASTId)this)._id, 0, "");
                id.exec(e);
            }
            return e;
        } else if (this instanceof ASTStatement) {
            if (this instanceof ASTIf) {
                this.exec(e);
                return e;
            } else if (this instanceof ASTElse) {
                this.exec(e);
                return e;
            } else {
                if (this instanceof ASTFor) {
                    throw H2O.unimpl("`for` loops are currently unsupported.");
                }
                if (this instanceof ASTReturn) {
                    this.exec(e);
                    return e;
                }
                this.exec(e);
            }
            return e;
        } else if (this instanceof ASTSlice) {
            this._asts[0].treeWalk(e);
            this._asts[1].treeWalk(e);
            this._asts[2].treeWalk(e);
            this.exec(e);
            return e;
        } else {
            if (!(this instanceof ASTString) && !(this instanceof ASTNum) && !(this instanceof ASTNull) && !(this instanceof ASTSeries) && !(this instanceof ASTKey) && !(this instanceof ASTSpan) && !(this instanceof ASTFrame) && !(this._asts[0] instanceof ASTFrame) && !(this instanceof ASTDelete)) throw H2O.fail("Unknown AST class: " + this.getClass());
            this.exec(e);
        }
        return e;
    }

    protected StringBuilder indent(StringBuilder sb, int d) {
        for (int i = 0; i < d; ++i) {
            sb.append("  ");
        }
        return sb.append(' ');
    }

    StringBuilder toString(StringBuilder sb, int d) {
        return this.indent(sb, d).append(this);
    }
}

