/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValStr;

class ASTAll
extends ASTUniPrefixOp {
    boolean _narm;

    ASTAll() {
        super(VARS1);
    }

    @Override
    String opStr() {
        return "all";
    }

    @Override
    ASTOp make() {
        return new ASTAll();
    }

    @Override
    ASTAll parse_impl(Exec E) {
        AST arg = E.parse();
        AST a = E.parse();
        if (a instanceof ASTId) {
            this._narm = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
        }
        E.eatEnd();
        ASTAll res = (ASTAll)this.clone();
        res._asts = new AST[]{arg};
        return res;
    }

    @Override
    void apply(Env env) {
        boolean all;
        if (env.isNum()) {
            all = env.popDbl() != 0.0;
        } else {
            Frame fr = env.popAry();
            if (fr.numCols() != 1) {
                throw new IllegalArgumentException("must only have 1 column for `all`");
            }
            Vec v = fr.anyVec();
            if (!v.isInt()) {
                throw new IllegalArgumentException("column must be a column of 1s and 0s.");
            }
            if (v.isConst()) {
                if (v.min() != 0.0 && v.min() != 1.0) {
                    throw new IllegalArgumentException("column must be a column of 1s and 0s");
                }
                if (v.min() != 0.0 && v.max() != 1.0) {
                    throw new IllegalArgumentException("column must be a column of 1s and 0s");
                }
            }
            all = ((AllTask)new AllTask().doAll(fr.anyVec())).all;
        }
        env.push(new ValStr(all ? "TRUE" : "FALSE"));
    }

    private static class AllTask
    extends MRTask<AllTask> {
        private boolean all = true;

        private AllTask() {
        }

        @Override
        public void map(Chunk c) {
            for (int i = 0; i < c._len; ++i) {
                if (!this.all) continue;
                if (c.isNA(i)) {
                    this.all = false;
                    break;
                }
                this.all &= c.atd(i) == 1.0;
            }
        }

        @Override
        public void reduce(AllTask t) {
            this.all &= t.all;
        }
    }
}

