/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.ValStr;

class ASTAny
extends ASTUniPrefixOp {
    boolean _narm;

    ASTAny() {
        super(VARS1);
    }

    @Override
    String opStr() {
        return "any";
    }

    @Override
    ASTOp make() {
        return new ASTAny();
    }

    @Override
    ASTAny parse_impl(Exec E) {
        AST arg = E.parse();
        AST a = E.parse();
        if (a instanceof ASTId) {
            this._narm = ((ASTNum)E._env.lookup((ASTId)((ASTId)a)))._d == 1.0;
        }
        E.eatEnd();
        ASTAny res = (ASTAny)this.clone();
        res._asts = new AST[]{arg};
        return res;
    }

    @Override
    void apply(Env env) {
        boolean any;
        if (env.isNum()) {
            any = env.popDbl() != 0.0;
        } else {
            Frame fr = env.popAry();
            for (int i = 0; i < fr.numCols(); ++i) {
                Vec v = fr.vec(i);
                if (!v.isInt()) {
                    throw new IllegalArgumentException("all columns must be a columns of 1s and 0s.");
                }
                if (!v.isConst()) continue;
                if (v.min() != 0.0 && v.min() != 1.0) {
                    throw new IllegalArgumentException("columns must be a columns of 1s and 0s");
                }
                if (v.min() == 0.0 || v.max() == 1.0) continue;
                throw new IllegalArgumentException("columns must be a columns of 1s and 0s");
            }
            any = ((AnyTask)new AnyTask(this._narm).doAll(fr)).any;
        }
        env.push(new ValStr(any ? "TRUE" : "FALSE"));
    }

    private static class AnyTask
    extends MRTask<AnyTask> {
        private boolean any = false;
        private final boolean _narm;

        AnyTask(boolean narm) {
            this._narm = narm;
        }

        @Override
        public void map(Chunk[] c) {
            int j = 0;
            for (Chunk aC : c) {
                for (j = 0; j < c[0]._len && !this.any; ++j) {
                    if (aC.isNA(j) && !this._narm) {
                        this.any = false;
                        break;
                    }
                    this.any |= aC.atd(j) == 1.0;
                }
                if (j != c[0]._len) break;
            }
        }

        @Override
        public void reduce(AnyTask t) {
            this.any &= t.any;
        }
    }
}

