/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.ArrayList;
import water.Futures;
import water.Key;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTFrame;
import water.rapids.ASTId;
import water.rapids.ASTNum;
import water.rapids.ASTOp;
import water.rapids.Env;
import water.rapids.Exec;

public class ASTApply
extends ASTOp {
    protected static int _margin;
    protected static String _fun;
    protected static AST[] _fun_args;
    static final String[] VARS;

    public ASTApply() {
        super(VARS);
    }

    @Override
    String opStr() {
        return "apply";
    }

    @Override
    ASTOp make() {
        return new ASTApply();
    }

    @Override
    ASTApply parse_impl(Exec E) {
        AST ary = E.parse();
        AST a = E.parse();
        if (!(a instanceof ASTNum)) {
            throw new IllegalArgumentException("`MARGIN` must be either 1 or 2, it cannot be both.");
        }
        _margin = (int)((ASTNum)a)._d;
        _fun = ((ASTId)E.parse())._id;
        ArrayList<AST> fun_args = new ArrayList<AST>();
        while (!E.isEnd()) {
            fun_args.add(E.parse());
        }
        E.eatEnd();
        ASTApply res = (ASTApply)this.clone();
        res._asts = new AST[]{ary};
        _fun_args = fun_args.size() > 0 ? fun_args.toArray(new AST[fun_args.size()]) : null;
        return res;
    }

    @Override
    void apply(Env env) {
        String err = "Result of function produced more than a single column!";
        final ASTOp FUN = ASTOp.get(_fun);
        Frame fr2 = null;
        Frame fr = env.popAry();
        if (_margin == 2) {
            boolean isRow = false;
            Futures fs = new Futures();
            AppendableVec v = null;
            Chunk chunk = null;
            Vec[] vecs = new Vec[fr.numCols()];
            for (int i = 0; i < fr.numCols(); ++i) {
                AST[] funargs = new AST[_fun_args == null ? 1 : _fun_args.length + 1];
                ASTFrame f = new ASTFrame(fr.vec((int)i)._key.toString());
                funargs[0] = f;
                if (_fun_args != null) {
                    System.arraycopy(_fun_args, 0, funargs, 1, _fun_args.length);
                }
                FUN.exec(env, funargs);
                if (i == 0 && (isRow = env.isNum())) {
                    Key<Vec> key = Vec.VectorGroup.VG_LEN1.addVecs(1)[0];
                    v = new AppendableVec((Key)key);
                    chunk = new NewChunk(v, 0);
                }
                if (isRow) {
                    ((NewChunk)chunk).addNum(env.popDbl());
                    continue;
                }
                vecs[i] = env.popAry().anyVec();
                env.lock(vecs[i]);
            }
            if (isRow) {
                chunk.close(0, fs);
                Vec vec = v.close(fs);
                fs.blockForPending();
                fr2 = new Frame(vec);
            } else {
                fr2 = new Frame(fr.names(), vecs);
            }
        }
        if (_margin == 1) {
            double[] rowin = new double[fr.vecs().length];
            for (int c = 0; c < rowin.length; ++c) {
                rowin[c] = fr.vecs()[c].at(0L);
            }
            final int outlen = FUN.map(env, rowin, null, _fun_args).length;
            final Env env0 = env.capture();
            MRTask mrt = new MRTask(){

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    double[] rowin = new double[cs.length];
                    double[] rowout = new double[outlen];
                    for (int row = 0; row < cs[0]._len; ++row) {
                        int c;
                        for (c = 0; c < cs.length; ++c) {
                            rowin[c] = cs[c].atd(row);
                        }
                        rowout = FUN.map(env0, rowin, rowout, _fun_args);
                        for (c = 0; c < ncs.length; ++c) {
                            ncs[c].addNum(rowout[c]);
                        }
                    }
                }
            };
            String[] names = new String[outlen];
            for (int i = 0; i < names.length; ++i) {
                names[i] = "C" + (i + 1);
            }
            fr2 = ((MRTask)mrt.doAll(outlen, fr)).outputFrame(names, null);
        } else if (_margin != 1 && _margin != 2) {
            throw new IllegalArgumentException("MARGIN limited to 1 (rows) or 2 (cols)");
        }
        env.pushAry(fr2);
    }

    static {
        VARS = new String[]{"", "ary", "MARGIN", "FUN", "..."};
    }
}

