/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.ValueString;
import water.rapids.ASTOp;
import water.rapids.ASTUniPrefixOp;
import water.rapids.Env;
import water.rapids.ValFrame;

class ASTAsNumeric
extends ASTUniPrefixOp {
    ASTAsNumeric() {
        super(new String[]{"as.numeric", "ary"});
    }

    @Override
    String opStr() {
        return "as.numeric";
    }

    @Override
    ASTOp make() {
        return new ASTAsNumeric();
    }

    @Override
    void apply(Env env) {
        Frame ary = env.peekAry();
        Vec[] nvecs = new Vec[ary.numCols()];
        for (int c = 0; c < ary.numCols(); ++c) {
            Vec vv = ary.vecs()[c];
            nvecs[c] = vv.isInt() || vv.isEnum() ? vv.toInt() : ASTAsNumeric.copyOver(vv.domain(), vv);
        }
        Frame v = new Frame(ary._names, nvecs);
        env.poppush(1, new ValFrame(v));
    }

    private static Vec copyOver(String[] domain, Vec vv) {
        String[][] dom = new String[][]{domain};
        final byte _type = vv.get_type();
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                ValueString vstr = new ValueString();
                block6: for (int i = 0; i < c._len; ++i) {
                    switch (_type) {
                        case 0: {
                            continue block6;
                        }
                        case 2: {
                            nc.addStr(c.atStr(vstr, i));
                            continue block6;
                        }
                        case 1: {
                            nc.addUUID(c, i);
                            continue block6;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            nc.addNum(c.atd(i));
                            continue block6;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported vector type: " + _type);
                        }
                    }
                }
            }
        }.doAll(1, vv)).outputFrame(null, dom).anyVec();
    }
}

