/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.AST;
import water.rapids.ASTId;
import water.rapids.ASTSlice;
import water.rapids.Env;
import water.rapids.Exec;
import water.rapids.Val;
import water.rapids.ValFrame;

class ASTAssign
extends AST {
    ASTAssign() {
    }

    @Override
    ASTAssign make() {
        return new ASTAssign();
    }

    @Override
    String opStr() {
        return "=";
    }

    @Override
    ASTAssign parse_impl(Exec E) {
        AST l;
        if (E.isSpecial(E.peek())) {
            boolean skip1;
            boolean putkv = E.peek() == '!';
            ++E._x;
            boolean bl = skip1 = E.peek() == '\'' || E.peek() == '\"';
            if (skip1) {
                ++E._x;
            }
            l = new ASTId(putkv ? (char)'!' : '&', E.parseID());
            if (skip1) {
                ++E._x;
            }
        } else {
            l = E.peek() == '(' ? E.parse() : new ASTId('&', E.parseID());
        }
        if (!E.hasNext()) {
            throw new IllegalArgumentException("Missing RHS in ASTAssign.");
        }
        AST r = E.parse();
        E.eatEnd();
        ASTAssign res = (ASTAssign)this.clone();
        res._asts = new AST[]{l, r};
        return res;
    }

    @Override
    int type() {
        return -1;
    }

    @Override
    String value() {
        throw H2O.unimpl("No value() for ASTAssign.");
    }

    private static boolean in(String s, String[] matches) {
        return Arrays.asList(matches).contains(s);
    }

    private static void replaceRow(Chunk[] chks, int row, double d0, String s0, long[] cols) {
        for (int c = 0; c < cols.length; ++c) {
            int col = (int)cols[c];
            if (chks[col].vec().isEnum()) {
                if (s0 == null) {
                    chks[col].setNA(row);
                    continue;
                }
                String[] dom = chks[col].vec().domain();
                if (ASTAssign.in(s0, dom)) {
                    chks[col].set(row, Arrays.asList(dom).indexOf(s0));
                    continue;
                }
                chks[col].setNA(row);
                continue;
            }
            if (!chks[col].vec().isNumeric()) continue;
            if (Double.isNaN(d0) || s0 != null) {
                chks[col].setNA(row);
                continue;
            }
            chks[col].set(row, d0);
        }
    }

    private static void replaceRow(Chunk[] cs, int row0, long row_id, long[] cols, Frame ary) {
        for (int c = 0; c < cols.length; ++c) {
            int col = (int)cols[c];
            if (cs[c].vec().isEnum()) {
                if (ary.vecs()[col].isEnum()) {
                    ary.vecs()[col].set(row_id, cs[c].atd(row0));
                } else {
                    ary.vecs()[col].set(row_id, Double.NaN);
                }
            }
            if (!cs[c].vec().isNumeric()) continue;
            if (ary.vecs()[col].isNumeric()) {
                ary.vecs()[col].set(row_id, cs[c].atd(row0));
                continue;
            }
            ary.vecs()[col].set(row_id, Double.NaN);
        }
    }

    private static void assignRows(Env e, Object rows, final Frame lhs_ary, Object cols) {
        long[] cols0;
        long[] lArray = cols0 = cols == null ? new long[lhs_ary.numCols()] : (long[])cols;
        if (cols == null) {
            for (int i = 0; i < lhs_ary.numCols(); ++i) {
                cols0[i] = i;
            }
        }
        if (!e.isAry()) {
            String s = null;
            double d = Double.NaN;
            if (e.isStr()) {
                s = e.popStr();
            } else if (e.isNum()) {
                d = e.popDbl();
            } else if (e.isNul()) {
                d = Double.NaN;
            } else {
                throw new IllegalArgumentException("Did not get a single number or factor level on the RHS of the assignment. Got type #:" + Env.typeToString(e.peekType()));
            }
            final double d0 = d;
            final String s0 = s;
            if (rows instanceof long[]) {
                final long[] rows0 = (long[])rows;
                new MRTask(){

                    @Override
                    public void map(Chunk[] chks) {
                        for (int row = 0; row < chks[0]._len; ++row) {
                            if (!Arrays.asList(new long[][]{rows0}).contains(row)) continue;
                            ASTAssign.replaceRow(chks, row, d0, s0, cols0);
                        }
                    }
                }.doAll(lhs_ary);
                e.push(new ValFrame(lhs_ary));
                return;
            }
            if (rows instanceof Frame) {
                Frame rr = new Frame(lhs_ary).add((Frame)rows);
                if (rr.numCols() != lhs_ary.numCols() + 1) {
                    throw new IllegalArgumentException("Got multiple columns for row predicate.");
                }
                new MRTask(){

                    @Override
                    public void map(Chunk[] cs, NewChunk[] ncs) {
                        Chunk pred = cs[cs.length - 1];
                        int rows = cs[0]._len;
                        for (int r = 0; r < rows; ++r) {
                            if (pred.atd(r) == 0.0) continue;
                            ASTAssign.replaceRow(cs, r, d0, s0, cols0);
                        }
                    }
                }.doAll(rr);
                e.push(new ValFrame(lhs_ary));
                return;
            }
            throw new IllegalArgumentException("Invalid row selection. (note: RHS was a constant)");
        }
        final Frame rhs_ary = e.popAry();
        if (cols == null && rhs_ary.numCols() != lhs_ary.numCols() || cols != null && rhs_ary.numCols() != ((long[])cols).length) {
            throw new IllegalArgumentException("Right-hand frame has does not match the number of columns required in the assignment to the left-hand side.");
        }
        if (rhs_ary.numRows() > lhs_ary.numRows()) {
            throw new IllegalArgumentException("Right-hand side frame has more rows than the left-hand side.");
        }
        if (rows instanceof long[]) {
            final long[] rows0 = (long[])rows;
            if ((long)rows0.length != rhs_ary.numRows()) {
                throw new IllegalArgumentException("Right-hand side array does not match the number of rows selected in the left-hand side.");
            }
            new MRTask(){

                @Override
                public void map(Chunk[] chks) {
                    for (int row = 0; row < chks[0]._len; ++row) {
                        if (!Arrays.asList(new long[][]{rows0}).contains(row)) continue;
                        long row_id = Arrays.asList(new long[][]{rows0}).indexOf(row);
                        for (int c = 0; c < cols0.length; ++c) {
                            int col = (int)cols0[c];
                            if (chks[col].vec().isEnum()) {
                                if (!rhs_ary.vecs()[col].isEnum()) {
                                    chks[col].setNA(row);
                                    continue;
                                }
                                if (chks[col].vec().isNumeric() && !rhs_ary.vecs()[col].isNumeric()) {
                                    chks[col].setNA(row);
                                    continue;
                                }
                            }
                            chks[col].set(row, rhs_ary.vecs()[col].at(row_id));
                        }
                    }
                }
            }.doAll(lhs_ary);
            e.push(new ValFrame(lhs_ary));
            return;
        }
        if (rows instanceof Frame) {
            if (((Frame)rows).numCols() != 1) {
                throw new IllegalArgumentException("Got multiple columns for row predicate.");
            }
            Frame pred = ((MRTask)new MRTask(){

                @Override
                public void map(Chunk c, NewChunk nc) {
                    for (int r = 0; r < c._len; ++r) {
                        double d = c.atd(r);
                        if (d == 0.0) continue;
                        nc.addNum(d);
                    }
                }
            }.doAll(1, (Frame)rows)).outputFrame(null, null);
            if (pred.numRows() != rhs_ary.numRows()) {
                throw new IllegalArgumentException("Right-hand side array does not match the number of rows selected in the left-hand side.");
            }
            Frame rr = new Frame(rhs_ary).add(pred);
            new MRTask(){

                @Override
                public void map(Chunk[] cs) {
                    Chunk pred = cs[cs.length - 1];
                    int rows = cs[0]._len;
                    for (int r = 0; r < rows; ++r) {
                        long row_id = (long)pred.atd(r) - 1L;
                        ASTAssign.replaceRow(cs, r, row_id, cols0, lhs_ary);
                    }
                }
            }.doAll(rr);
            e.push(new ValFrame(lhs_ary));
            return;
        }
        throw new IllegalArgumentException("Invalid row selection. (note: RHS was Frame");
    }

    @Override
    void exec(Env e) {
        if (this._asts[0] instanceof ASTId) {
            ASTId id = (ASTId)this._asts[0];
            assert (id.isGlobalSet() || id.isLocalSet()) : "Expected to set result into the LHS!.";
            if ((e.isNum() || e.isStr()) && id.isLocalSet()) {
                if (e.isNum()) {
                    e.put(id.value(), 3, String.valueOf(e.popDbl()));
                } else {
                    e.put(id.value(), 2, e.popStr());
                }
                return;
            }
            if (e.isAry() || id.isGlobalSet() && (e.isNum() || e.isStr())) {
                Vec tVec = null;
                Frame f = null;
                if (e.isAry()) {
                    f = e.popAry();
                } else if (e.isNum()) {
                    tVec = Vec.makeCon(e.popDbl(), 1L);
                    f = new Frame(null, new String[]{"C1"}, new Vec[]{tVec});
                } else if (e.isStr()) {
                    Vec v;
                    String s = e.popStr();
                    if (s.equals("TRUE") || s.equals("FALSE")) {
                        v = Vec.makeCon(s.equals("TRUE") ? 1.0 : 0.0, 1L);
                        v.setDomain(new String[]{"FALSE", "TRUE"});
                    } else {
                        v = Vec.makeCon(0.0, 1L);
                        v.setDomain(new String[]{s});
                    }
                    tVec = v;
                    f = new Frame(null, new String[]{"C1"}, new Vec[]{tVec});
                }
                Key k = Key.make(id._id);
                Vec[] vecs = f.vecs();
                if (id.isGlobalSet()) {
                    vecs = f.deepCopy(null).vecs();
                }
                Frame fr = new Frame(k, f.names(), vecs);
                if (id.isGlobalSet()) {
                    DKV.put(k, fr);
                    e.lock(fr);
                    if (tVec != null) {
                        tVec.remove();
                    }
                } else {
                    e.put(k.toString(), fr);
                }
                e.push(new ValFrame(fr, id.isGlobalSet()));
            }
        } else {
            long[] rs1;
            long[] cs1;
            AST x = this._asts[0];
            while (x instanceof ASTAssign) {
                x = x._asts[1];
            }
            ASTSlice lhs_slice = (ASTSlice)x;
            lhs_slice._asts[0].treeWalk(e);
            lhs_slice._asts[1].treeWalk(e);
            lhs_slice._asts[2].treeWalk(e);
            if (e.isNum() && e.peekTypeAt(-1) == 3) {
                int col = (int)e.popDbl();
                long row = (long)e.popDbl();
                Frame ary = e.popAry();
                if (Math.abs(row) > ary.numRows()) {
                    throw new IllegalArgumentException("New rows would leave holes after existing rows.");
                }
                if (Math.abs(col) > ary.numCols()) {
                    throw new IllegalArgumentException("New columns would leave holes after existing columns.");
                }
                if (row < 0L && Math.abs(row) > ary.numRows()) {
                    throw new IllegalArgumentException("Cannot extend rows.");
                }
                if (col < 0 && Math.abs(col) > ary.numCols()) {
                    throw new IllegalArgumentException("Cannot extend columns.");
                }
                if (e.isNum()) {
                    double d = e.popDbl();
                    if (ary.vecs()[col].isEnum()) {
                        ary.vecs()[col].set(row, Double.NaN);
                    } else {
                        ary.vecs()[col].set(row, d);
                    }
                    if (ary._key != null && DKV.get(ary._key) != null) {
                        DKV.put(ary);
                    }
                    e.push(new ValFrame(ary));
                    return;
                }
                if (e.isAry()) {
                    Frame one_by_one_ary = e.popAry();
                    if (one_by_one_ary.numCols() != 1 && one_by_one_ary.numRows() != 1L) {
                        throw new IllegalArgumentException("Expected RHS to be a 1x1 (one row, one column). Got: " + one_by_one_ary.numRows() + " rows " + one_by_one_ary.numCols() + " cols.");
                    }
                    Vec theVec = one_by_one_ary.anyVec();
                    if (theVec.isEnum()) {
                        String[] dom;
                        String s = theVec.domain()[(int)theVec.at(0L)];
                        if (ASTAssign.in(s, dom = ary.vecs()[col].domain())) {
                            ary.vecs()[col].set(row, Arrays.asList(dom).indexOf(s));
                        } else {
                            ary.vecs()[col].set(row, Double.NaN);
                        }
                        if (ary._key != null && DKV.get(ary._key) != null) {
                            DKV.put(ary);
                        }
                        e.push(new ValFrame(ary));
                        return;
                    }
                    if (ary.vecs()[col].isEnum()) {
                        ary.vecs()[col].set(row, Double.NaN);
                        if (ary._key != null && DKV.get(ary._key) != null) {
                            DKV.put(ary);
                        }
                        e.push(new ValFrame(ary));
                        return;
                    }
                    double d = theVec.at(0L);
                    ary.vecs()[col].set(row, d);
                    if (ary._key != null && DKV.get(ary._key) != null) {
                        DKV.put(ary);
                    }
                    e.push(new ValFrame(ary));
                    return;
                }
                if (e.isStr()) {
                    String[] dom;
                    if (!ary.vecs()[col].isEnum()) {
                        throw new IllegalArgumentException("Currently can only set categorical columns.");
                    }
                    String s = e.popStr();
                    if (ASTAssign.in(s, dom = ary.vecs()[col].domain())) {
                        ary.vecs()[col].set(row, Arrays.asList(dom).indexOf(s));
                    } else {
                        ary.vecs()[col].set(row, Double.NaN);
                    }
                    if (ary._key != null && DKV.get(ary._key) != null) {
                        DKV.put(ary);
                    }
                    e.push(new ValFrame(ary));
                    return;
                }
                throw new IllegalArgumentException("Did not get a single number or factor level on the RHS of the assignment.");
            }
            Val colSelect = e.pop();
            Val rowSelect = e.pop();
            Frame lhs_ary = e.peekAry();
            Object cols = ASTSlice.select(lhs_ary.numCols(), colSelect, e, true);
            Object rows = ASTSlice.select(lhs_ary.numRows(), rowSelect, e, false);
            lhs_ary = e.popAry();
            if (cols != null && rows != null && cols instanceof long[] && rows instanceof long[] && (cs1 = (long[])cols).length == 1 && (rs1 = (long[])rows).length == 1) {
                long row = rs1[0];
                int col = (int)cs1[0];
                if (Math.abs(row) > lhs_ary.numRows()) {
                    throw new IllegalArgumentException("New rows would leave holes after existing rows.");
                }
                if (Math.abs(col) > lhs_ary.numCols()) {
                    throw new IllegalArgumentException("New columnss would leave holes after existing columns.");
                }
                if (row < 0L && Math.abs(row) > lhs_ary.numRows()) {
                    throw new IllegalArgumentException("Cannot extend rows.");
                }
                if (col < 0 && Math.abs(col) > lhs_ary.numCols()) {
                    throw new IllegalArgumentException("Cannot extend columns.");
                }
                if (e.isNum()) {
                    if (lhs_ary.vecs()[col].isEnum()) {
                        throw new IllegalArgumentException("Currently can only set numeric columns");
                    }
                    lhs_ary.vecs()[col].set(row, e.popDbl());
                    e.pushAry(lhs_ary);
                    if (lhs_ary._key != null && DKV.get(lhs_ary._key) != null) {
                        DKV.put(lhs_ary);
                    }
                    return;
                }
                if (e.isStr()) {
                    String[] dom;
                    if (!lhs_ary.vecs()[col].isEnum()) {
                        throw new IllegalArgumentException("Currently can only set categorical columns.");
                    }
                    String s = e.popStr();
                    if (ASTAssign.in(s, dom = lhs_ary.vecs()[col].domain())) {
                        lhs_ary.vecs()[col].set(row, Arrays.asList(dom).indexOf(s));
                    } else {
                        lhs_ary.vecs()[col].set(row, Double.NaN);
                    }
                    if (lhs_ary._key != null && DKV.get(lhs_ary._key) != null) {
                        DKV.put(lhs_ary);
                    }
                    e.pushAry(lhs_ary);
                    return;
                }
                throw new IllegalArgumentException("Did not get a single number or factor level on the RHS of the assignment.");
            }
            if (rows != null) {
                if (cols == null) {
                    ASTAssign.assignRows(e, rows, lhs_ary, null);
                } else {
                    ASTAssign.assignRows(e, rows, lhs_ary, cols);
                }
            } else {
                if (cols != null) {
                    Frame rhs_ary;
                    Key tKey = null;
                    if (e.isNum()) {
                        rhs_ary = new Frame(lhs_ary.anyVec().makeCon(e.popDbl()));
                    } else if (e.isStr()) {
                        rhs_ary = new Frame(lhs_ary.anyVec().makeZero(new String[]{e.popStr()}));
                    } else if (e.isAry()) {
                        rhs_ary = e.popAry();
                    } else {
                        throw new IllegalArgumentException("Bad RHS on the stack: " + e.peekType() + " : " + e.toString());
                    }
                    long[] cs = (long[])cols;
                    if (rhs_ary.numCols() != 1 && rhs_ary.numCols() != cs.length) {
                        throw new IllegalArgumentException("Can only assign to a matching set of columns; trying to assign " + rhs_ary.numCols() + " cols over " + cs.length + " cols");
                    }
                    tKey = Key.make();
                    Vec[] rvecs = rhs_ary.deepCopy(tKey.toString()).vecs();
                    Futures fs = new Futures();
                    for (int i = 0; i < cs.length; ++i) {
                        Vec rvOld;
                        int cidx = (int)cs[i];
                        Vec rv = rvecs[i];
                        e.addRef(rv);
                        if (cidx == lhs_ary.numCols()) {
                            if (!rv.group().equals(lhs_ary.anyVec().group())) {
                                rvOld = rv;
                                rv = lhs_ary.anyVec().align(rv);
                                e.subRef(rvOld);
                                e.addRef(rv);
                            }
                            lhs_ary.add("C" + String.valueOf(cidx + 1), rv);
                            continue;
                        }
                        if (!rv.group().equals(lhs_ary.anyVec().group()) && rv.length() == lhs_ary.anyVec().length()) {
                            rvOld = rv;
                            rv = lhs_ary.anyVec().align(rv);
                            e.subRef(rvOld);
                            e.addRef(rv);
                        }
                        Vec vv = lhs_ary.replace(cidx, rv);
                        e._locked.remove(vv._key);
                        e.subRef(vv);
                    }
                    fs.blockForPending();
                    if (lhs_ary._key != null && DKV.get(lhs_ary._key) != null) {
                        DKV.put(lhs_ary);
                    }
                    e.pushAry(lhs_ary);
                    if (tKey != null) {
                        DKV.remove(tKey);
                    }
                    return;
                }
                throw new IllegalArgumentException("Invalid row/col selections.");
            }
        }
    }

    public String toString() {
        return "=";
    }
}

